/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpDangerousArrayInitializationInspection;
import com.jetbrains.php.lang.inspections.type.PhpCastIsUnnecessaryInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAutovivificationOnFalseValuesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAutovivificationOnFalseValuesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                Object element = PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)((Condition)e -> e instanceof AssignmentExpression || e instanceof PhpUnset), GroupStatement.INSTANCEOF);
                if (element != null) {
                    String message;
                    if (!expression.isWriteAccess()) {
                        return;
                    }
                    PhpType type = PhpAutovivificationOnFalseValuesInspection.getType(expression);
                    if (!type.equals(PhpType.FALSE) && !type.equals(PhpType.or(PhpType.FALSE, PhpType.ARRAY))) {
                        return;
                    }
                    PhpDangerousArrayInitializationInspection.ReplaceWithArrayQuickFix replaceWithArrayQuickFix = new PhpDangerousArrayInitializationInspection.ReplaceWithArrayQuickFix(PhpLanguageFeature.SHORT_ARRAY_SYNTAX.isSupported(expression.getProject()));
                    String string = message = type.equals(PhpType.FALSE) ? PhpBundle.message("inspection.php.autovivification.on.false.values", new Object[0]) : PhpBundle.message("inspection.php.autovivification.on.false.values.possible", new Object[0]);
                    if (element instanceof PhpUnset) {
                        holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[0]);
                    }
                    if (element instanceof AssignmentExpression) {
                        if (!type.equals(PhpType.FALSE)) {
                            holder.registerProblem(element, message, new LocalQuickFix[0]);
                        } else {
                            holder.registerProblem(element, message, new LocalQuickFix[]{replaceWithArrayQuickFix});
                        }
                    }
                }
            }
        };
    }

    private static PhpType getType(@NotNull ArrayAccessExpression expression) {
        Variable variable;
        if (expression == null) {
            PhpAutovivificationOnFalseValuesInspection.$$$reportNull$$$0(1);
        }
        if ((variable = (Variable)ObjectUtils.tryCast((Object)expression.getValue(), Variable.class)) == null) {
            return PhpType.EMPTY;
        }
        if (PhpCastIsUnnecessaryInspection.parameterWithoutRealType((PsiElement)variable)) {
            return PhpType.EMPTY;
        }
        ArrayIndex arrayIndex = expression.getIndex();
        if (arrayIndex != null && arrayIndex.getFirstPsiChild() != null) {
            return variable.getType().global(variable.getProject());
        }
        return PhpTypeInfo.getTypeFromAST((PsiElement)variable, new PhpTypeAnalyserVisitor(){

            @Override
            protected boolean extractTypeFromArrayAccessExpression(ArrayAccessExpression arrayAccessExpression) {
                return true;
            }
        }).global(variable.getProject());
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpAutovivificationOnFalseValuesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

