/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassConstantCanBeFinalInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassConstantCanBeFinalInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpField(Field field) {
                if (!field.isConstant() || field.getModifier().isFinal() || field.getModifier().isPrivate() || PhpAnnotatorVisitor.isInsideHierarchy(field)) {
                    return;
                }
                holder.registerProblem((PsiElement)field, PhpBundle.message("inspection.message.can.be.final", new Object[0]), new LocalQuickFix[]{PhpMakeClassConstantFinalQuickFix.INSTANCE});
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpClassConstantCanBeFinalInspection", "buildVisitor"));
    }

    private static class PhpMakeClassConstantFinalQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpMakeClassConstantFinalQuickFix INSTANCE = new PhpMakeClassConstantFinalQuickFix();

        private PhpMakeClassConstantFinalQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.final", new Object[0]);
            if (string == null) {
                PhpMakeClassConstantFinalQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Field field;
            if (project == null) {
                PhpMakeClassConstantFinalQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpMakeClassConstantFinalQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMakeClassConstantFinalQuickFix.$$$reportNull$$$0(3);
            }
            if ((field = (Field)ObjectUtils.tryCast((Object)element, Field.class)) == null) {
                return;
            }
            PhpClassFieldsList list = field.getParentList();
            if (list == null) {
                return;
            }
            Field copyField = (Field)ContainerUtil.getFirstItem(FieldImpl.copyListWithSingleField(field, list).getFields());
            PsiElement defaultValue = copyField.getDefaultValue();
            if (defaultValue == null) {
                return;
            }
            String typeText = copyField.getTypeDeclaration() != null ? copyField.getTypeDeclaration().getText() + " " : "";
            String constantText = String.format("class a{%s final const %s%s = %s;}", new Object[]{copyField.getModifier().getAccess(), typeText, copyField.getName(), defaultValue.getText()});
            list.getParent().addBefore((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpClassConstantsListImpl.class, constantText), (PsiElement)list);
            PhpMoveClassMemberBase.removeFieldWithPhpDoc(field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpClassConstantCanBeFinalInspection$PhpMakeClassConstantFinalQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpClassConstantCanBeFinalInspection$PhpMakeClassConstantFinalQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

