/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpReplaceCallableWithFirstClassCallableQuickFix;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClosureCanBeConvertedToFirstClassCallableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClosureCanBeConvertedToFirstClassCallableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                if (!PhpClosureCanBeConvertedToFirstClassCallableInspection.isClosureFromCallableMethod(reference)) {
                    return;
                }
                if (reference.getName() == null) {
                    return;
                }
                PsiElement firstParameter = reference.getParameter(0);
                if (firstParameter == null || reference.getParameters().length > 1) {
                    return;
                }
                if (firstParameter instanceof PhpExpression) {
                    String functionName = PhpClosureCanBeConvertedToFirstClassCallableInspection.getFunctionName(firstParameter);
                    if (functionName == null) {
                        return;
                    }
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.closure.can.be.converted.to.first.class.callable", new Object[0]), new LocalQuickFix[]{new PhpReplaceCallableWithFirstClassCallableQuickFix(functionName)});
                }
            }
        };
    }

    @Nullable
    public static String getFunctionName(@NotNull PsiElement parameter) {
        StringLiteralExpression stringLiteral;
        if (parameter == null) {
            PhpClosureCanBeConvertedToFirstClassCallableInspection.$$$reportNull$$$0(1);
        }
        PsiElement functionNameElement = parameter;
        ArrayCreationExpression array = (ArrayCreationExpression)ObjectUtils.tryCast((Object)parameter, ArrayCreationExpression.class);
        if (array != null) {
            List elements = ContainerUtil.map((Iterable)ArrayCreationExpressionImpl.children(array).limit(3), PhpPsiElement::getFirstPsiChild);
            if (elements.size() != 2) {
                return null;
            }
            functionNameElement = (PsiElement)elements.get(1);
            if (!(functionNameElement instanceof Variable || functionNameElement instanceof StringLiteralExpression || functionNameElement instanceof ConcatenationExpression)) {
                return null;
            }
            if (PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToWrapWithCurlyBraces(functionNameElement)) {
                return "{" + functionNameElement.getText() + "}";
            }
        }
        if ((stringLiteral = (StringLiteralExpression)ObjectUtils.tryCast((Object)functionNameElement, StringLiteralExpression.class)) != null) {
            return stringLiteral.getContents();
        }
        Object functionName = functionNameElement.getText();
        if (PhpReplaceCallableWithFirstClassCallableQuickFix.isNeedToParenthesize(functionNameElement)) {
            functionName = "(" + (String)functionName + ")";
        }
        return functionName;
    }

    private static boolean isClosureFromCallableMethod(@NotNull MethodReference reference) {
        ResolveResult[] resolveResults;
        if (reference == null) {
            PhpClosureCanBeConvertedToFirstClassCallableInspection.$$$reportNull$$$0(2);
        }
        return (resolveResults = reference.multiResolve(false)).length > 0 && Arrays.stream(resolveResults).map(r -> (Method)ObjectUtils.tryCast((Object)r.getElement(), Method.class)).allMatch(m -> m != null && StringUtil.equalsIgnoreCase((CharSequence)"\\Closure.fromCallable", (CharSequence)m.getFQN()));
    }

    @Override
    protected boolean isLanguageLevelSupported(@NotNull Project project) {
        if (project == null) {
            PhpClosureCanBeConvertedToFirstClassCallableInspection.$$$reportNull$$$0(3);
        }
        return PhpLanguageFeature.FIRST_CLASS_CALLABLE.isSupported(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpClosureCanBeConvertedToFirstClassCallableInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClosureFromCallableMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLanguageLevelSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

