/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDangerousArrayInitializationInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDangerousArrayInitializationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), ArrayAccessExpression.class);
                if (arrayAccessExpression != null) {
                    this.checkPhpArrayAccessExpression(arrayAccessExpression, assignmentExpression);
                }
            }

            private void checkPhpArrayAccessExpression(@NotNull ArrayAccessExpression expression, @NotNull AssignmentExpression assignmentExpression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (assignmentExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!expression.isWriteAccess()) {
                    return;
                }
                if (assignmentExpression instanceof SelfAssignmentExpression) {
                    return;
                }
                if (expression.getValue() instanceof ArrayAccessExpression) {
                    this.checkPhpArrayAccessExpression((ArrayAccessExpression)expression.getValue(), assignmentExpression);
                    return;
                }
                PhpPsiElement value = assignmentExpression.getValue();
                if (value == null) {
                    return;
                }
                Variable variable = (Variable)ObjectUtils.tryCast((Object)expression.getValue(), Variable.class);
                if (variable == null || PhpDangerousArrayInitializationInspection.isAlreadyInitialized(variable)) {
                    return;
                }
                if (PhpDangerousArrayInitializationInspection.isRepeatable(expression, PhpArrayAccessInstruction.class)) {
                    return;
                }
                ReplaceWithArrayQuickFix replaceWithArrayQuickFix = new ReplaceWithArrayQuickFix(PhpLanguageFeature.SHORT_ARRAY_SYNTAX.isSupported(value.getProject()));
                holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.message.dangerous.array.initialization", new Object[0]), new LocalQuickFix[]{replaceWithArrayQuickFix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "assignmentExpression";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpDangerousArrayInitializationInspection$1";
                objectArray[2] = "checkPhpArrayAccessExpression";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static boolean isRepeatable(@NotNull PhpPsiElement expression, Class<? extends PhpAccessInstruction> instructionClass) {
        Statement loopStatement;
        if (expression == null) {
            PhpDangerousArrayInitializationInspection.$$$reportNull$$$0(1);
        }
        if ((loopStatement = (Statement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{For.class, ForeachStatement.class, DoWhile.class, While.class})) == null) {
            return false;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)expression);
        if (scopeHolder == null) {
            return false;
        }
        final Ref isRepeatable = new Ref((Object)Boolean.FALSE);
        final PhpAccessInstruction originalInstruction = scopeHolder.getControlFlow().getInstruction((PsiElement)expression, instructionClass);
        if (originalInstruction == null) {
            return false;
        }
        PhpControlFlowUtil.processSuccessors(originalInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processInstruction(PhpInstruction instruction) {
                if (instruction == originalInstruction) {
                    isRepeatable.set((Object)Boolean.TRUE);
                    return false;
                }
                return super.processInstruction(instruction);
            }
        });
        return (Boolean)isRepeatable.get();
    }

    public static boolean isAlreadyInitialized(@NotNull Variable variable) {
        String variableName;
        if (variable == null) {
            PhpDangerousArrayInitializationInspection.$$$reportNull$$$0(2);
        }
        if (PhpLangUtil.isSuperGlobal(variableName = variable.getName()) || PhpLangUtil.isMagicPredefinedVariable(variableName)) {
            return true;
        }
        if (PhpDangerousArrayInitializationInspection.isParameter(variable)) {
            return true;
        }
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (scopeHolder instanceof Function && ((Function)scopeHolder).isClosure() && ContainerUtil.exists(PhpPsiUtil.getUsedVariables((Function)scopeHolder), v -> PhpLangUtil.equalsVariableNames(variable.getName(), v.getName()))) {
            return true;
        }
        return !PhpDangerousArrayInitializationInspection.isFirstArrayWrite(variable);
    }

    public static boolean isParameter(@NotNull Variable variable) {
        if (variable == null) {
            PhpDangerousArrayInitializationInspection.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists((Iterable)variable.resolveLocal(), v -> v instanceof Parameter);
    }

    private static boolean isFirstArrayWrite(final @NotNull Variable variable) {
        PhpAccessVariableInstruction originalInstruction;
        if (variable == null) {
            PhpDangerousArrayInitializationInspection.$$$reportNull$$$0(4);
        }
        if ((originalInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class)) == null) {
            return false;
        }
        final Ref writeAccessBeforeExists = new Ref((Object)false);
        PhpControlFlowUtil.processPreviousVariableAccesses(originalInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                return this.processAccessInstruction(instruction);
            }

            @Override
            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variable.getName(), instruction.getVariableName())) {
                    return this.processAccessInstruction(instruction);
                }
                return true;
            }

            private boolean processAccessInstruction(PhpAccessInstruction instruction) {
                if (instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef()) {
                    writeAccessBeforeExists.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)writeAccessBeforeExists.get() == false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpDangerousArrayInitializationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isRepeatable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAlreadyInitialized";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isParameter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstArrayWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ReplaceWithArrayQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myIsShortSyntax;

        public ReplaceWithArrayQuickFix(boolean isShortSyntax) {
            this.myIsShortSyntax = isShortSyntax;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message(this.myIsShortSyntax ? "replace.with.array.short.syntax" : "replace.with.array", new Object[0]);
            if (string == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            AssignmentExpression assignmentExpression;
            if (project == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(3);
            }
            if ((assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)element, AssignmentExpression.class)) == null) {
                return;
            }
            if (assignmentExpression instanceof MultiassignmentExpression) {
                this.replaceMultiassignment((MultiassignmentExpression)assignmentExpression);
                return;
            }
            PhpPsiElement value = assignmentExpression.getValue();
            if (value == null) {
                return;
            }
            ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)PsiTreeUtil.getChildOfType((PsiElement)assignmentExpression, ArrayAccessExpression.class);
            if (arrayAccessExpression == null) {
                return;
            }
            this.replace(arrayAccessExpression, (PsiElement)value);
        }

        private void replace(@NotNull ArrayAccessExpression arrayAccessExpression, @NotNull PsiElement value) {
            if (arrayAccessExpression == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(4);
            }
            if (value == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(5);
            }
            ArrayCreationExpression newExpression = this.createArrayCreationExpression(value, arrayAccessExpression);
            if (arrayAccessExpression.getValue() == null) {
                return;
            }
            arrayAccessExpression.replace(arrayAccessExpression.getValue().copy());
            value.replace((PsiElement)newExpression);
        }

        private void replaceMultiassignment(@NotNull MultiassignmentExpression expression) {
            if (expression == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(6);
            }
            if (expression.getValue() == null) {
                return;
            }
            ArrayCreationExpression arrayCreation = (ArrayCreationExpression)ObjectUtils.tryCast((Object)expression.getValue().getFirstPsiChild(), ArrayCreationExpression.class);
            if (arrayCreation == null) {
                return;
            }
            ArrayList values = ContainerUtil.newArrayList(ArrayCreationExpressionImpl.children(arrayCreation));
            ArrayList<PhpPsiElement> variables = new ArrayList<PhpPsiElement>(MultiassignmentExpressionImpl.getUnpackedVariablesFromMultiAssignment(expression));
            for (int i = 0; i < Math.min(values.size(), variables.size()); ++i) {
                ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)ObjectUtils.tryCast(variables.get(i), ArrayAccessExpression.class);
                PhpPsiElement value = ((PhpPsiElement)values.get(i)).getFirstPsiChild();
                if (arrayAccessExpression == null || value == null) continue;
                this.replace(arrayAccessExpression, (PsiElement)value);
            }
        }

        @NotNull
        private ArrayCreationExpression createArrayCreationExpression(@NotNull PsiElement element, @NotNull ArrayAccessExpression arrayAccessExpression) {
            PhpPsiElement indexValue;
            if (element == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(7);
            }
            if (arrayAccessExpression == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(8);
            }
            String content = (indexValue = ReplaceWithArrayQuickFix.getIndexValue(arrayAccessExpression)) == null ? element.getText() : String.format("%s => %s", indexValue.getText(), element.getText());
            String newExpressionTemplate = this.myIsShortSyntax ? "$a=[%s]" : "$a=array(%s)";
            ArrayCreationExpression newExpression = PhpPsiElementFactory.createFirstFromText(element.getProject(), ArrayCreationExpression.class, String.format(newExpressionTemplate, content));
            assert (newExpression != null);
            ArrayCreationExpression arrayCreationExpression = newExpression;
            if (arrayCreationExpression == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(9);
            }
            return arrayCreationExpression;
        }

        @Nullable
        private static PhpPsiElement getIndexValue(@NotNull ArrayAccessExpression exp) {
            if (exp == null) {
                ReplaceWithArrayQuickFix.$$$reportNull$$$0(10);
            }
            if (exp.getIndex() == null) {
                return null;
            }
            return exp.getIndex().getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 10 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpDangerousArrayInitializationInspection$ReplaceWithArrayQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayAccessExpression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpDangerousArrayInitializationInspection$ReplaceWithArrayQuickFix";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createArrayCreationExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceMultiassignment";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createArrayCreationExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndexValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 10 -> new IllegalArgumentException(string);
            };
        }
    }
}

