/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpShortOpenTagInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpEchoOpenTagInspection
extends PhpInspection {
    private static final LocalQuickFix QUICK_FIX = new PhpConvertToShortEchoTagQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpEchoOpenTagInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFile(PhpFile PhpFile2) {
                PhpShortOpenTagInspection.collectOpenTagsByCondition(PhpFile2, (Condition<PsiElement>)((Condition)PhpEchoOpenTagInspection::isOpenEchoTag)).forEach(tag -> holder.registerProblem(tag, PhpBundle.message("inspection.php.open.echo.tag.inspection.display.name", new Object[0]), new LocalQuickFix[]{QUICK_FIX}));
            }
        };
    }

    private static boolean isOpenEchoTag(PsiElement element) {
        if (element instanceof PhpEchoStatement) {
            PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true);
            return PhpPsiUtil.isOfType(prev, PhpTokenTypes.PHP_OPENING_TAG) && prev.textMatches((CharSequence)"<?php");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpEchoOpenTagInspection", "buildVisitor"));
    }

    private static class PhpConvertToShortEchoTagQuickFix
    implements LocalQuickFix {
        private PhpConvertToShortEchoTagQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.all.occurrences.with.short.php.echo", new Object[0]);
            if (string == null) {
                PhpConvertToShortEchoTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpConvertToShortEchoTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertToShortEchoTagQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement shortEchoTag = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.PHP_ECHO_OPENING_TAG, "?> <?=");
            PhpShortOpenTagInspection.collectOpenTagsByCondition(descriptor.getPsiElement().getContainingFile(), (Condition<PsiElement>)((Condition)PhpEchoOpenTagInspection::isOpenEchoTag)).forEach(tag -> {
                PsiElement phpOpenTag = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(tag, true);
                PsiElement echo = tag.getFirstChild();
                if (phpOpenTag == null || echo == null) {
                    return;
                }
                PsiElement betweenPhpTagEcho = phpOpenTag.getNextSibling();
                if (betweenPhpTagEcho instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)betweenPhpTagEcho.getText())) {
                    betweenPhpTagEcho.delete();
                }
                if (PhpPsiUtil.isOfType(PhpPsiUtil.getNextSiblingIgnoreWhitespace(tag, true), PhpTokenTypes.PHP_CLOSING_TAG)) {
                    PsiElement whiteSpace;
                    PsiElement semicolon = tag.getLastChild();
                    if (PhpPsiUtil.isOfType(semicolon, PhpTokenTypes.opSEMICOLON)) {
                        semicolon.delete();
                    }
                    if ((whiteSpace = tag.getNextSibling()) instanceof PsiWhiteSpace && StringUtil.containsLineBreak((CharSequence)whiteSpace.getText())) {
                        whiteSpace.delete();
                    }
                }
                phpOpenTag.replace(shortEchoTag);
                echo.delete();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpEchoOpenTagInspection$PhpConvertToShortEchoTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpEchoOpenTagInspection$PhpConvertToShortEchoTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

