/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExpressionWithoutClarifyingParenthesesInspection
extends PhpInspection {
    private static final LocalQuickFix FIX = new PhpAddClarifyingParenthesesQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionWithoutClarifyingParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpExpression) {
                    PhpExpressionWithoutClarifyingParenthesesVisitor visitor = new PhpExpressionWithoutClarifyingParenthesesVisitor(PhpExpressionWithoutClarifyingParenthesesVisitor.Mode.FIND);
                    element.accept(visitor);
                    if (visitor.myUnclearExpressionWithoutClerifyingParentheses) {
                        holder.registerProblem((PsiElement)element, PhpBundle.message("inspection.message.expression.without.parentheses", new Object[0]), new LocalQuickFix[]{FIX});
                    }
                }
            }
        };
    }

    public static PsiElement wrapInParens(@Nullable PsiElement element) {
        if (element != null) {
            ParenthesizedExpression parenthesizedExpression = PhpPsiElementFactory.createPhpPsiFromText(element.getProject(), ParenthesizedExpression.class, "(" + element.getText() + ")");
            return element.replace((PsiElement)parenthesizedExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection", "buildVisitor"));
    }

    private static class PhpAddClarifyingParenthesesQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpExpressionWithoutClarifyingParenthesesVisitor ADD_CLARIFYING_PARENTHESES_VISITOR = new PhpExpressionWithoutClarifyingParenthesesVisitor(PhpExpressionWithoutClarifyingParenthesesVisitor.Mode.WRAP_IN_PARENTHESES);

        private PhpAddClarifyingParenthesesQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.clarifying.parentheses", new Object[0]);
            if (string == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddClarifyingParenthesesQuickFix.$$$reportNull$$$0(3);
            }
            element.accept((PsiElementVisitor)ADD_CLARIFYING_PARENTHESES_VISITOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection$PhpAddClarifyingParenthesesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpExpressionWithoutClarifyingParenthesesInspection$PhpAddClarifyingParenthesesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class PhpExpressionWithoutClarifyingParenthesesVisitor
    extends PhpElementVisitor {
        private final Mode myMode;
        private boolean myUnclearExpressionWithoutClerifyingParentheses = false;

        private PhpExpressionWithoutClarifyingParenthesesVisitor(Mode mode) {
            this.myMode = mode;
        }

        @Override
        public void visitPhpBinaryExpression(BinaryExpression expression) {
            PsiElement left = expression.getLeftOperand();
            PsiElement right = expression.getRightOperand();
            IElementType operationType = expression.getOperationType();
            if (PhpParenthesesPrecedenceAnalyzer.getAssociativity((PsiElement)expression) != PhpParenthesesPrecedenceAnalyzer.Associativity.NON_ASSOCIATIVE) {
                if (PhpExpressionWithoutClarifyingParenthesesVisitor.binaryExpressionWithDifferentOperation(left, operationType)) {
                    this.process(left);
                }
                if (PhpExpressionWithoutClarifyingParenthesesVisitor.binaryExpressionWithDifferentOperation(right, operationType)) {
                    this.process(right);
                }
            }
        }

        private static boolean binaryExpressionWithDifferentOperation(PsiElement element, IElementType operationType) {
            return element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() != operationType;
        }

        @Override
        public void visitPhpUnaryExpression(UnaryExpression expression) {
            if (PhpParenthesesPrecedenceAnalyzer.getAssociativity((PsiElement)expression) != PhpParenthesesPrecedenceAnalyzer.Associativity.NON_ASSOCIATIVE) {
                this.process((PsiElement)expression.getValue());
            }
        }

        @Override
        public void visitPhpTernaryExpression(TernaryExpression expression) {
            this.process((PsiElement)expression.getCondition());
            this.process((PsiElement)expression.getTrueVariant());
            this.process((PsiElement)expression.getFalseVariant());
        }

        private void process(PsiElement element) {
            if (PhpExpressionWithoutClarifyingParenthesesVisitor.isNonTrivialExpression(element)) {
                if (this.myMode == Mode.WRAP_IN_PARENTHESES) {
                    PhpExpressionWithoutClarifyingParenthesesInspection.wrapInParens(element);
                } else {
                    this.myUnclearExpressionWithoutClerifyingParentheses = true;
                }
            }
        }

        private static boolean isNonTrivialExpression(@Nullable PsiElement operand) {
            return operand instanceof BinaryExpression || operand instanceof UnaryExpression && PhpExpressionWithoutClarifyingParenthesesVisitor.isNonTrivialExpression((PsiElement)((UnaryExpression)operand).getValue()) || operand instanceof AssignmentExpression || operand instanceof TernaryExpression;
        }

        static enum Mode {
            FIND,
            WRAP_IN_PARENTHESES;

        }
    }
}

