/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayAnyInspectionKt;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseConvertLoopToArrayCheckFunctionQuickFix;
import com.jetbrains.php.lang.intentions.PhpNegateExpressionIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAllInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpConvertLoopToArrayCheckAllQuickFix", "intellij.php.impl"})
public final class PhpLoopCanBeConvertedToArrayAllInspection
extends PhpInspection
implements DumbAware {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                If anIf;
                Intrinsics.checkNotNullParameter((Object)foreach, (String)"foreach");
                LocalQuickFix[] localQuickFixArray = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement());
                If if_ = anIf = localQuickFixArray instanceof If ? (If)localQuickFixArray : null;
                if (anIf != null && anIf.getElseBranch() == null) {
                    ElseIf[] elseIfArray = anIf.getElseIfBranches();
                    Intrinsics.checkNotNullExpressionValue((Object)elseIfArray, (String)"getElseIfBranches(...)");
                    if (((Object[])elseIfArray).length == 0 && PhpLoopCanBeConvertedToArrayAnyInspectionKt.isReturnFalse(PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement())) && PhpLoopCanBeConvertedToArrayAnyInspectionKt.isReturnTrue((Statement)PhpPsiUtil.getNextSiblingByCondition(foreach, Statement.INSTANCEOF))) {
                        localQuickFixArray = new LocalQuickFix[]{PhpConvertLoopToArrayCheckAllQuickFix.INSTANCE};
                        this.$holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayall", new Object[0]), localQuickFixArray);
                    }
                }
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayAllInspection$PhpConvertLoopToArrayCheckAllQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertLoopToArrayCheckFunctionQuickFix;", "<init>", "()V", "getFamilyName", "", "getArrayFunctionName", "processCallbackCondition", "Lcom/intellij/psi/PsiElement;", "condition", "intellij.php.impl"})
    public static final class PhpConvertLoopToArrayCheckAllQuickFix
    extends PhpBaseConvertLoopToArrayCheckFunctionQuickFix {
        @NotNull
        public static final PhpConvertLoopToArrayCheckAllQuickFix INSTANCE = new PhpConvertLoopToArrayCheckAllQuickFix();

        private PhpConvertLoopToArrayCheckAllQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.convert.loop.to.arrayall", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getArrayFunctionName() {
            return "array_all";
        }

        @Override
        @Nullable
        public PsiElement processCallbackCondition(@NotNull PsiElement condition) {
            Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
            return PhpNegateExpressionIntention.unwrapIfNecessary(PhpNegateExpressionIntention.createInvertedExpression(condition));
        }
    }
}

