/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFilterInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayFindInspectionKt;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseConvertLoopToArrayCheckFunctionQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFindInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isReturnValue", "statement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "arrayName", "", "key", "Lcom/jetbrains/php/lang/psi/elements/Variable;", "valueName", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "PhpConvertLoopToArrayCheckFindQuickFix", "intellij.php.impl"})
public final class PhpLoopCanBeConvertedToArrayFindInspection
extends PhpInspection
implements DumbAware {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(this, holder){
            final /* synthetic */ PhpLoopCanBeConvertedToArrayFindInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPhpForeach(ForeachStatement foreach) {
                If anIf;
                Intrinsics.checkNotNullParameter((Object)foreach, (String)"foreach");
                Variable variable = foreach.getValue();
                if (variable == null) {
                    return;
                }
                Variable value = variable;
                Object object = foreach.getArray();
                if (object == null || (object = object.getText()) == null) {
                    return;
                }
                Object iteratedArrayName = object;
                LocalQuickFix[] localQuickFixArray = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement());
                If if_ = anIf = localQuickFixArray instanceof If ? (If)localQuickFixArray : null;
                if (anIf != null && anIf.getElseBranch() == null) {
                    ElseIf[] elseIfArray = anIf.getElseIfBranches();
                    Intrinsics.checkNotNullExpressionValue((Object)elseIfArray, (String)"getElseIfBranches(...)");
                    if (((Object[])elseIfArray).length == 0) {
                        Statement statement = PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement());
                        Variable variable2 = foreach.getKey();
                        String string = value.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (PhpLoopCanBeConvertedToArrayFindInspection.access$isReturnValue(this.this$0, statement, (String)iteratedArrayName, variable2, string) && PhpLoopCanBeConvertedToArrayFindInspectionKt.isReturnNull((Statement)PhpPsiUtil.getNextSiblingByCondition(foreach, Statement.INSTANCEOF))) {
                            localQuickFixArray = new LocalQuickFix[]{PhpConvertLoopToArrayCheckFindQuickFix.INSTANCE};
                            this.$holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayfind", new Object[0]), localQuickFixArray);
                        }
                    }
                }
            }
        };
    }

    private final boolean isReturnValue(Statement statement, String arrayName, Variable key, String valueName) {
        PhpReturn returnCall;
        PhpReturn phpReturn = returnCall = statement instanceof PhpReturn ? (PhpReturn)statement : null;
        if (returnCall != null) {
            PsiElement psiElement = returnCall.getArgument();
            if (psiElement == null) {
                return false;
            }
            PsiElement argument = psiElement;
            if (PhpLoopCanBeConvertedToArrayFilterInspection.isVariableWithName(argument, valueName)) {
                return true;
            }
            ArrayAccessExpression arrayAccessExpression = argument instanceof ArrayAccessExpression ? (ArrayAccessExpression)argument : null;
            if (arrayAccessExpression == null) {
                return false;
            }
            ArrayAccessExpression arrayAccessCall = arrayAccessExpression;
            return key != null && PhpLoopCanBeConvertedToArrayFilterInspection.hasName(arrayAccessCall, arrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(arrayAccessCall, key.getName());
        }
        return false;
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    public static final /* synthetic */ boolean access$isReturnValue(PhpLoopCanBeConvertedToArrayFindInspection $this, Statement statement, String arrayName, Variable key, String valueName) {
        return $this.isReturnValue(statement, arrayName, key, valueName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFindInspection$PhpConvertLoopToArrayCheckFindQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpBaseConvertLoopToArrayCheckFunctionQuickFix;", "<init>", "()V", "getFamilyName", "", "getArrayFunctionName", "intellij.php.impl"})
    public static final class PhpConvertLoopToArrayCheckFindQuickFix
    extends PhpBaseConvertLoopToArrayCheckFunctionQuickFix {
        @NotNull
        public static final PhpConvertLoopToArrayCheckFindQuickFix INSTANCE = new PhpConvertLoopToArrayCheckFindQuickFix();

        private PhpConvertLoopToArrayCheckFindQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.convert.loop.to.arrayfind", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @Override
        @NotNull
        public String getArrayFunctionName() {
            return "array_find";
        }
    }
}

