/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpNonCanonicalElementsOrderInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpFlipVariableAndTypeQuickFix.INSTANCE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNonCanonicalElementsOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpDocTag(PhpDocTag tag) {
                if (tag instanceof PhpDocPropertyTag) {
                    PhpDocType type = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)tag, PhpDocType.INSTANCEOF);
                    if (type == null && !tag.getTagValue().isEmpty()) {
                        holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.non.canonical.elements.order.description", new Object[0]), new LocalQuickFix[0]);
                    }
                } else if (tag instanceof PhpDocParamTag) {
                    PhpDocVariable variable = null;
                    for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
                        if (child instanceof PhpDocVariable) {
                            variable = (PhpDocVariable)child;
                            continue;
                        }
                        if (!(child instanceof PhpDocType)) continue;
                        if (variable != null) {
                            holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.php.non.canonical.elements.order.description", new Object[0]), FIXES);
                        }
                        return;
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection", "buildVisitor"));
    }

    private static final class PhpFlipVariableAndTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpFlipVariableAndTypeQuickFix INSTANCE = new PhpFlipVariableAndTypeQuickFix();

        private PhpFlipVariableAndTypeQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.flip.variable.and.type.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpFlipVariableAndTypeQuickFix.$$$reportNull$$$0(3);
            }
            PhpDocTag tag = (PhpDocTag)element;
            PhpDocVariable variable = (PhpDocVariable)PhpPsiUtil.getChildByCondition((PsiElement)tag, PhpDocVariable.INSTANCEOF);
            PhpDocType type = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)tag, PhpDocType.INSTANCEOF);
            PhpDocType lastType = PhpFlipVariableAndTypeQuickFix.getLastType(type);
            if (variable != null && type != null) {
                tag.addRangeBefore((PsiElement)type, (PsiElement)lastType, (PsiElement)variable);
                tag.deleteChildRange((PsiElement)type, (PsiElement)lastType);
            }
        }

        private static PhpDocType getLastType(PhpDocType type) {
            PsiElement next;
            PhpDocType lastType = type;
            PsiElement psiElement = next = type != null ? type.getNextSibling() : null;
            while (next != null) {
                if (next instanceof PhpDocType) {
                    lastType = (PhpDocType)next;
                }
                next = next.getNextSibling();
            }
            return lastType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection$PhpFlipVariableAndTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpNonCanonicalElementsOrderInspection$PhpFlipVariableAndTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

