/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesCanBeOmittedForNewCallInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpParenthesesCanBeOmittedForNewCallInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getMinimumSupportedLanguageLevel", "Lcom/jetbrains/php/config/PhpLanguageLevel;", "ParenthesesCanBeOmittedForNewCallQuickFix", "intellij.php.impl"})
public final class PhpParenthesesCanBeOmittedForNewCallInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpNewExpression(NewExpression expression) {
                ParenthesizedExpression firstParenthesizedExpressionParent;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (expression.getClassReference() != null && expression.getParameterList() == null) {
                    return;
                }
                PsiElement psiElement = expression.getParent();
                ParenthesizedExpression parenthesizedExpression = firstParenthesizedExpressionParent = psiElement instanceof ParenthesizedExpression ? (ParenthesizedExpression)psiElement : null;
                if (firstParenthesizedExpressionParent == null) {
                    return;
                }
                T lastParenthesizedExpressionParent = PhpPsiUtil.getParentByCondition((PsiElement)firstParenthesizedExpressionParent, false, (Condition<? super PsiElement>)((Condition)arg_0 -> buildVisitor.1.visitPhpNewExpression$lambda$1(buildVisitor.1::visitPhpNewExpression$lambda$0, arg_0)), null);
                if (lastParenthesizedExpressionParent == null) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{ParenthesesCanBeOmittedForNewCallQuickFix.INSTANCE};
                this.$holder.registerProblem(lastParenthesizedExpressionParent, PhpBundle.message("inspection.parentheses.around.new.call.can.be.omitted", new Object[0]), localQuickFixArray);
            }

            private static final boolean visitPhpNewExpression$lambda$0(PsiElement elem) {
                return elem.getParent() instanceof FieldReference || elem.getParent() instanceof FunctionReference || elem.getParent() instanceof ArrayAccessExpression;
            }

            private static final boolean visitPhpNewExpression$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @Override
    @NotNull
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP840;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/PhpParenthesesCanBeOmittedForNewCallInspection$ParenthesesCanBeOmittedForNewCallQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.php.impl"})
    public static final class ParenthesesCanBeOmittedForNewCallQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public static final ParenthesesCanBeOmittedForNewCallQuickFix INSTANCE = new ParenthesesCanBeOmittedForNewCallQuickFix();

        private ParenthesesCanBeOmittedForNewCallQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.omit.parentheses.around.new.call", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            ParenthesizedExpression parenthesizedNewExpression;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            ParenthesizedExpression parenthesizedExpression = parenthesizedNewExpression = element instanceof ParenthesizedExpression ? (ParenthesizedExpression)element : null;
            if (parenthesizedNewExpression == null) {
                return;
            }
            PhpPsiElement phpPsiElement = parenthesizedNewExpression.extract();
            if (phpPsiElement == null) {
                return;
            }
            PhpPsiElement newExpression = phpPsiElement;
            ModCommand.psiUpdate((PsiElement)((PsiElement)parenthesizedNewExpression), arg_0 -> ParenthesesCanBeOmittedForNewCallQuickFix.applyFix$lambda$0(parenthesizedNewExpression, newExpression, arg_0));
        }

        private static final void applyFix$lambda$0(ParenthesizedExpression $parenthesizedNewExpression, PhpPsiElement $newExpression, ParenthesizedExpression parenthesizedExpression) {
            Intrinsics.checkNotNullParameter((Object)parenthesizedExpression, (String)"<unused var>");
            $parenthesizedNewExpression.replace((PsiElement)$newExpression);
        }
    }
}

