/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParenthesesPrecedenceAnalyzer {
    private static final Map<IElementType, Pair<Integer, Associativity>> ourBinaryOperationsPrecedence = new HashMap<IElementType, Pair<Integer, Associativity>>();
    private static final Map<IElementType, Pair<Integer, Associativity>> ourUnaryOperationsPrecedence = new HashMap<IElementType, Pair<Integer, Associativity>>();
    private static final Map<IElementType, Pair<Integer, Associativity>> ourElementsOperationsPrecedence = new HashMap<IElementType, Pair<Integer, Associativity>>();
    private static final Pair<Integer, Associativity> CONCATENATION_AFTER_8_PRECEDENCE;
    private static final Pair<Integer, Associativity> CONCATENATION_BEFORE_8_PRECEDENCE;

    @Nullable
    public static Pair<Integer, Associativity> getBinaryPrecedence(@NotNull Project project, IElementType operationType) {
        if (project == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(0);
        }
        if (operationType == PhpTokenTypes.opCONCAT) {
            return PhpParenthesesPrecedenceAnalyzer.getPrecedenceOfConcatOperation(project);
        }
        return operationType != null ? ourBinaryOperationsPrecedence.get(operationType) : null;
    }

    @NotNull
    public static Pair<Integer, Associativity> getPrecedenceOfConcatOperation(@NotNull Project project) {
        if (project == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(1);
        }
        Pair<Integer, Associativity> pair = PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP800) ? CONCATENATION_AFTER_8_PRECEDENCE : CONCATENATION_BEFORE_8_PRECEDENCE;
        if (pair == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(2);
        }
        return pair;
    }

    public static boolean precedenceMatchesParenthesesGrouping(@NotNull PsiElement parent, @NotNull ParenthesizedExpression parenthesizedChild) {
        PhpPsiElement child;
        if (parent == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(3);
        }
        if (parenthesizedChild == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(4);
        }
        if ((child = parenthesizedChild.extract()) == null) {
            return false;
        }
        if (child instanceof NewExpression && parent instanceof MemberReference) {
            return false;
        }
        int parentPrecedence = PhpParenthesesPrecedenceAnalyzer.getPrecedence(parent);
        int childPrecedence = PhpParenthesesPrecedenceAnalyzer.getPrecedence((PsiElement)child);
        return childPrecedence > parentPrecedence || childPrecedence == parentPrecedence && !PhpParenthesesPrecedenceAnalyzer.isArithmeticWithConcatenation(parent, (PsiElement)child) && PhpParenthesesPrecedenceAnalyzer.associativityPrecedenceMatchesParenthesesGrouping(parent, parenthesizedChild);
    }

    private static boolean associativityPrecedenceMatchesParenthesesGrouping(PsiElement parent, ParenthesizedExpression child) {
        PhpAssociativityVisitor visitor = new PhpAssociativityVisitor((PsiElement)child);
        parent.accept((PsiElementVisitor)visitor);
        return visitor.myPrecedenceMatchesParenthesesGrouping;
    }

    private static boolean isArithmeticWithConcatenation(PsiElement parent, PsiElement child) {
        return child instanceof ConcatenationExpression && parent instanceof BinaryExpression && PhpPsiUtil.isOfType(((BinaryExpression)parent).getOperation(), PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS);
    }

    @NotNull
    public static Associativity getAssociativity(@NotNull PsiElement element) {
        if (element == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(5);
        }
        PhpAssociativityVisitor visitor = new PhpAssociativityVisitor(element);
        element.accept((PsiElementVisitor)visitor);
        Associativity associativity = visitor.myAssociativity;
        if (associativity == null) {
            PhpParenthesesPrecedenceAnalyzer.$$$reportNull$$$0(6);
        }
        return associativity;
    }

    public static int getPrecedence(PsiElement element) {
        PhpPrecedenceVisitor visitor = new PhpPrecedenceVisitor();
        element.accept((PsiElementVisitor)visitor);
        return visitor.myPrecedence;
    }

    public static Integer getUnaryOperationPrecedence(IElementType operationType) {
        return (Integer)PhpParenthesesPrecedenceAnalyzer.ourUnaryOperationsPrecedence.get((Object)operationType).first;
    }

    static {
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opLIT_OR, (Pair<Integer, Associativity>)Pair.create((Object)10, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opLIT_XOR, (Pair<Integer, Associativity>)Pair.create((Object)20, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opLIT_AND, (Pair<Integer, Associativity>)Pair.create((Object)30, (Object)((Object)Associativity.LEFT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.YIELD, (Pair<Integer, Associativity>)Pair.create((Object)40, (Object)((Object)Associativity.RIGHT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.ASSIGNMENT_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)60, (Object)((Object)Associativity.RIGHT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)60, (Object)((Object)Associativity.RIGHT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.TERNARY_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)70, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opCOALESCE, (Pair<Integer, Associativity>)Pair.create((Object)80, (Object)((Object)Associativity.RIGHT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opOR, (Pair<Integer, Associativity>)Pair.create((Object)90, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opAND, (Pair<Integer, Associativity>)Pair.create((Object)100, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opBIT_OR, (Pair<Integer, Associativity>)Pair.create((Object)110, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opBIT_XOR, (Pair<Integer, Associativity>)Pair.create((Object)120, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opBIT_AND, (Pair<Integer, Associativity>)Pair.create((Object)130, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opEQUAL, (Pair<Integer, Associativity>)Pair.create((Object)140, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opNOT_EQUAL, (Pair<Integer, Associativity>)Pair.create((Object)140, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opIDENTICAL, (Pair<Integer, Associativity>)Pair.create((Object)140, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opNOT_IDENTICAL, (Pair<Integer, Associativity>)Pair.create((Object)140, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opSPACESHIP, (Pair<Integer, Associativity>)Pair.create((Object)140, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opLESS, (Pair<Integer, Associativity>)Pair.create((Object)150, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opLESS_OR_EQUAL, (Pair<Integer, Associativity>)Pair.create((Object)150, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opGREATER, (Pair<Integer, Associativity>)Pair.create((Object)150, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opGREATER_OR_EQUAL, (Pair<Integer, Associativity>)Pair.create((Object)150, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opSHIFT_RIGHT, (Pair<Integer, Associativity>)Pair.create((Object)160, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opSHIFT_LEFT, (Pair<Integer, Associativity>)Pair.create((Object)160, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opPLUS, (Pair<Integer, Associativity>)Pair.create((Object)170, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opMINUS, (Pair<Integer, Associativity>)Pair.create((Object)170, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opCONCAT, (Pair<Integer, Associativity>)Pair.create((Object)170, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opMUL, (Pair<Integer, Associativity>)Pair.create((Object)180, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opDIV, (Pair<Integer, Associativity>)Pair.create((Object)180, (Object)((Object)Associativity.LEFT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.opREM, (Pair<Integer, Associativity>)Pair.create((Object)180, (Object)((Object)Associativity.LEFT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opNOT, (Pair<Integer, Associativity>)Pair.create((Object)190, (Object)((Object)Associativity.RIGHT)));
        ourBinaryOperationsPrecedence.put(PhpTokenTypes.kwINSTANCEOF, (Pair<Integer, Associativity>)Pair.create((Object)200, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opINCREMENT, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opDECREMENT, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opINTEGER_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opFLOAT_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opSTRING_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opARRAY_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opOBJECT_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opBOOLEAN_CAST, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opSILENCE, (Pair<Integer, Associativity>)Pair.create((Object)210, (Object)((Object)Associativity.RIGHT)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.opEXP, (Pair<Integer, Associativity>)Pair.create((Object)220, (Object)((Object)Associativity.RIGHT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.ARRAY_CREATION_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)230, (Object)((Object)Associativity.LEFT)));
        ourElementsOperationsPrecedence.put(PhpElementTypes.NEW_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)240, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourUnaryOperationsPrecedence.put(PhpTokenTypes.kwCLONE, (Pair<Integer, Associativity>)Pair.create((Object)240, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        ourElementsOperationsPrecedence.put((IElementType)PhpStubElementTypes.INCLUDE_EXPRESSION, (Pair<Integer, Associativity>)Pair.create((Object)240, (Object)((Object)Associativity.NON_ASSOCIATIVE)));
        CONCATENATION_AFTER_8_PRECEDENCE = Pair.create((Object)155, (Object)((Object)Associativity.LEFT));
        CONCATENATION_BEFORE_8_PRECEDENCE = Pair.create((Object)170, (Object)((Object)Associativity.LEFT));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpParenthesesPrecedenceAnalyzer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedChild";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpParenthesesPrecedenceAnalyzer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedenceOfConcatOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociativity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryPrecedence";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedenceOfConcatOperation";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "precedenceMatchesParenthesesGrouping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAssociativity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }

    private static final class PhpAssociativityVisitor
    extends PhpElementVisitor {
        Associativity myAssociativity;
        private boolean myPrecedenceMatchesParenthesesGrouping;
        @NotNull
        private final PsiElement myParenthesizedChild;
        private static final TokenSet ourAlwaysFullyAssociativeOperators = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCONCAT, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR, PhpTokenTypes.opBIT_XOR, PhpTokenTypes.opCOALESCE, PhpTokenTypes.opAND, PhpTokenTypes.opOR, PhpTokenTypes.opLIT_AND, PhpTokenTypes.opLIT_OR, PhpTokenTypes.opLIT_XOR});
        private static final Map<IElementType, PhpType> ourFullyAssociatveForOperandTypeOperators = new HashMap<IElementType, PhpType>();

        private PhpAssociativityVisitor(@NotNull PsiElement parenthesizedChild) {
            if (parenthesizedChild == null) {
                PhpAssociativityVisitor.$$$reportNull$$$0(0);
            }
            this.myAssociativity = Associativity.NON_ASSOCIATIVE;
            this.myPrecedenceMatchesParenthesesGrouping = false;
            this.myParenthesizedChild = parenthesizedChild;
        }

        @Override
        public void visitPhpUnaryExpression(UnaryExpression expr) {
            IElementType operationType = PsiUtilCore.getElementType((PsiElement)expr.getOperation());
            if (operationType != null && ourUnaryOperationsPrecedence.containsKey(operationType)) {
                this.myAssociativity = (Associativity)((Object)PhpParenthesesPrecedenceAnalyzer.ourUnaryOperationsPrecedence.get((Object)operationType).second);
                this.myPrecedenceMatchesParenthesesGrouping = this.myAssociativity == Associativity.RIGHT && PhpPsiUtil.isOfType((PsiElement)expr, PhpElementTypes.INFIX_EXPRESSION) || this.myAssociativity == Associativity.RIGHT && PhpPsiUtil.isOfType((PsiElement)expr, PhpElementTypes.INFIX_WRITE_EXPRESSION) || this.myAssociativity == Associativity.LEFT && PhpPsiUtil.isOfType((PsiElement)expr, PhpElementTypes.POSTFIX_EXPRESSION);
            }
        }

        @Override
        public void visitPhpBinaryExpression(BinaryExpression expression) {
            Pair<Integer, Associativity> precedence = PhpParenthesesPrecedenceAnalyzer.getBinaryPrecedence(expression.getProject(), expression.getOperationType());
            if (precedence != null) {
                this.myAssociativity = (Associativity)((Object)precedence.second);
                if (this.myAssociativity == Associativity.NON_ASSOCIATIVE) {
                    return;
                }
                PsiElement leftOperand = expression.getLeftOperand();
                PsiElement rightOperand = expression.getRightOperand();
                BinaryExpression myBinaryExpressionChild = (BinaryExpression)ObjectUtils.tryCast((Object)PhpPsiUtil.unparenthesize(this.myParenthesizedChild), BinaryExpression.class);
                IElementType type = expression.getOperationType();
                if (myBinaryExpressionChild != null && myBinaryExpressionChild.getOperationType() == type && PhpAssociativityVisitor.isFullyAssociativeOperation(type, leftOperand, rightOperand)) {
                    this.myPrecedenceMatchesParenthesesGrouping = true;
                    return;
                }
                this.myPrecedenceMatchesParenthesesGrouping = this.myAssociativity == Associativity.LEFT && leftOperand == this.myParenthesizedChild || this.myAssociativity == Associativity.RIGHT && rightOperand == this.myParenthesizedChild;
            }
        }

        private static boolean isFullyAssociativeOperation(IElementType operatorType, PsiElement leftOperand, PsiElement rightOperand) {
            if (ourAlwaysFullyAssociativeOperators.contains(operatorType)) {
                return true;
            }
            return ourFullyAssociatveForOperandTypeOperators.containsKey(operatorType) && leftOperand instanceof PhpTypedElement && ourFullyAssociatveForOperandTypeOperators.get(operatorType).equals(((PhpTypedElement)leftOperand).getType()) && rightOperand instanceof PhpTypedElement && ourFullyAssociatveForOperandTypeOperators.get(operatorType).equals(((PhpTypedElement)rightOperand).getType());
        }

        @Override
        public void visitPhpYield(PhpYield element) {
            super.visitPhpYield(element);
            this.myPrecedenceMatchesParenthesesGrouping = true;
        }

        @Override
        public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
            super.visitPhpAssignmentExpression(assignmentExpression);
            this.myPrecedenceMatchesParenthesesGrouping = assignmentExpression.getValue() == this.myParenthesizedChild;
        }

        @Override
        public void visitPhpElement(PhpPsiElement element) {
            IElementType type = PsiUtilCore.getElementType((PsiElement)element);
            if (ourElementsOperationsPrecedence.containsKey(type)) {
                this.myAssociativity = (Associativity)((Object)PhpParenthesesPrecedenceAnalyzer.ourElementsOperationsPrecedence.get((Object)type).second);
            }
        }

        static {
            ourFullyAssociatveForOperandTypeOperators.put(PhpTokenTypes.opPLUS, PhpType.INT);
            ourFullyAssociatveForOperandTypeOperators.put(PhpTokenTypes.opMUL, PhpType.INT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parenthesizedChild", "com/jetbrains/php/lang/inspections/codeStyle/PhpParenthesesPrecedenceAnalyzer$PhpAssociativityVisitor", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static enum Associativity {
        LEFT,
        RIGHT,
        NON_ASSOCIATIVE;

    }

    private static class PhpPrecedenceVisitor
    extends PhpElementVisitor {
        private int myPrecedence = Integer.MAX_VALUE;

        private PhpPrecedenceVisitor() {
        }

        @Override
        public void visitPhpUnaryExpression(UnaryExpression expr) {
            IElementType operationType = PsiUtilCore.getElementType((PsiElement)expr.getOperation());
            if (operationType != null && ourUnaryOperationsPrecedence.containsKey(operationType)) {
                this.myPrecedence = PhpParenthesesPrecedenceAnalyzer.getUnaryOperationPrecedence(operationType);
            }
        }

        @Override
        public void visitPhpBinaryExpression(BinaryExpression expression) {
            Pair<Integer, Associativity> precedence = PhpParenthesesPrecedenceAnalyzer.getBinaryPrecedence(expression.getProject(), expression.getOperationType());
            if (precedence != null) {
                this.myPrecedence = (Integer)precedence.first;
            }
        }

        @Override
        public void visitPhpElement(PhpPsiElement element) {
            IElementType type = PsiUtilCore.getElementType((PsiElement)element);
            if (type != null && ourElementsOperationsPrecedence.containsKey(type)) {
                this.myPrecedence = (Integer)PhpParenthesesPrecedenceAnalyzer.ourElementsOperationsPrecedence.get((Object)type).first;
            }
        }

        @Override
        public void visitPhpYield(PhpYield element) {
            super.visitPhpYield(element);
            LeafPsiElement from = PhpYieldImpl.getFrom(element);
            if (from != null) {
                ++this.myPrecedence;
            }
        }
    }
}

