/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpPluralMixedCanBeReplacedWithArrayInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPluralMixedCanBeReplacedWithArrayInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpDocType(PhpDocType docType) {
                int dimension;
                String type = (String)ContainerUtil.getOnlyItem(docType.getType().getTypes());
                if (type != null && (dimension = PhpType.getPluralDimension(type)) > 0 && PhpType.isMixedType(PhpType.unpluralize(type, dimension))) {
                    String arrayToReplace = PhpType.pluralise("array", dimension - 1);
                    holder.registerProblem((PsiElement)docType, PhpBundle.message("inspection.message.can.be.replaced.with", arrayToReplace), new LocalQuickFix[]{new PhpReplaceWithArrayDocTypeQuickFix(arrayToReplace)});
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithArrayDocTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myDocType;

        private PhpReplaceWithArrayDocTypeQuickFix(String docType) {
            this.myDocType = docType;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myDocType);
            if (string == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithArrayDocTypeQuickFix.$$$reportNull$$$0(3);
            }
            element.replace((PsiElement)PhpPsiElementFactory.createPhpDocType(project, this.myDocType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection$PhpReplaceWithArrayDocTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpPluralMixedCanBeReplacedWithArrayInspection$PhpReplaceWithArrayDocTypeQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

