/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpShortOpenTagInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpShortOpenEchoTagInspection
extends PhpInspection {
    private static final LocalQuickFix QUICK_FIX = new PhpReplaceShortTagWithPhpEchoTagQuickFix();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpShortOpenEchoTagInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFile(PhpFile phpFile) {
                PhpShortOpenTagInspection.collectOpenTagsByCondition(phpFile, (Condition<PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpTokenTypes.PHP_ECHO_OPENING_TAG))).forEach(tag -> holder.registerProblem(tag, PhpBundle.message("inspection.php.short.echo.open.tag.description", new Object[0]), new LocalQuickFix[]{QUICK_FIX}));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenEchoTagInspection", "buildVisitor"));
    }

    private static class PhpReplaceShortTagWithPhpEchoTagQuickFix
    extends PsiUpdateModCommandQuickFix {
        private PhpReplaceShortTagWithPhpEchoTagQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.all.occurrences.with.php.echo", new Object[0]);
            if (string == null) {
                PhpReplaceShortTagWithPhpEchoTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceShortTagWithPhpEchoTagQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceShortTagWithPhpEchoTagQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceShortTagWithPhpEchoTagQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement openingTag = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.PHP_OPENING_TAG, "<?php");
            PhpShortOpenTagInspection.collectOpenTagsByCondition(element.getContainingFile(), (Condition<PsiElement>)((Condition)c -> PhpPsiUtil.isOfType(c, PhpTokenTypes.PHP_ECHO_OPENING_TAG))).forEach(tag -> {
                PhpEchoStatement echoStatement = (PhpEchoStatement)PhpPsiUtil.getNextSiblingByCondition(tag, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpEchoStatement));
                if (echoStatement != null) {
                    echoStatement.addBefore(PhpPsiElementFactory.createFromText(tag.getProject(), PhpTokenTypes.kwECHO, "echo"), echoStatement.getFirstChild());
                    tag.replace(openingTag);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenEchoTagInspection$PhpReplaceShortTagWithPhpEchoTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpShortOpenEchoTagInspection$PhpReplaceShortTagWithPhpEchoTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

