/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.GroupStatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpStatementWithoutBracesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStatementWithoutBracesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpIf(If ifStatement) {
                this.check((PsiElement)ifStatement, (PsiElement)ifStatement.getStatement());
            }

            @Override
            public void visitPhpElseIf(ElseIf elseIfStatement) {
                this.check((PsiElement)elseIfStatement, (PsiElement)elseIfStatement.getStatement());
            }

            @Override
            public void visitPhpElse(Else elseStatement) {
                this.check((PsiElement)elseStatement, (PsiElement)elseStatement.getStatement());
            }

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                this.check(foreach, (PsiElement)foreach.getStatement());
            }

            @Override
            public void visitPhpFor(For forStatement) {
                this.check(forStatement, (PsiElement)forStatement.getStatement());
            }

            @Override
            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.check(doWhileStatement, (PsiElement)doWhileStatement.getStatement());
            }

            @Override
            public void visitPhpWhile(While whileStatement) {
                this.check(whileStatement, (PsiElement)whileStatement.getStatement());
            }

            private void check(@NotNull PsiElement controlStatement, PsiElement innerStatement) {
                if (controlStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpPsiUtil.getChildOfType(controlStatement, PhpTokenTypes.opCOLON) != null) {
                    return;
                }
                if (innerStatement == null || PhpStatementWithoutBracesInspection.groupStatementWithBraces(innerStatement)) {
                    return;
                }
                holder.registerProblem(controlStatement, PhpStatementWithoutBracesInspection.createRangeToHighlight(innerStatement), PhpStatementWithoutBracesInspection.getMessage(), new LocalQuickFix[]{new PhpAddBracesToStatementQuickFix(controlStatement)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controlStatement", "com/jetbrains/php/lang/inspections/codeStyle/PhpStatementWithoutBracesInspection$1", "check"));
            }
        };
    }

    @NotNull
    public static TextRange createRangeToHighlight(PsiElement innerStatement) {
        TextRange textRange = TextRange.create((int)0, (int)innerStatement.getTextRangeInParent().getEndOffset());
        if (textRange == null) {
            PhpStatementWithoutBracesInspection.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    public static boolean groupStatementWithBraces(PsiElement innerStatement) {
        return innerStatement instanceof GroupStatement && PhpPsiUtil.isOfType(innerStatement.getFirstChild(), PhpTokenTypes.chLBRACE);
    }

    public static String toString(@NotNull PsiElement controlStatement) {
        if (controlStatement == null) {
            PhpStatementWithoutBracesInspection.$$$reportNull$$$0(2);
        }
        return StringUtil.toLowerCase((String)controlStatement.getNode().getElementType().toString());
    }

    @InspectionMessage
    private static String getMessage() {
        return PhpBundle.message("inspection.statement.without.braces", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStatementWithoutBracesInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStatementWithoutBracesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class PhpAddBracesToStatementQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        @Nls
        private final String myMessage;

        private PhpAddBracesToStatementQuickFix(@NotNull PsiElement statement) {
            if (statement == null) {
                PhpAddBracesToStatementQuickFix.$$$reportNull$$$0(0);
            }
            this.myMessage = PhpBundle.message("inspection.statement.without.braces.fix.name", PhpStatementWithoutBracesInspection.toString(statement));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                PhpAddBracesToStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Statement statement;
            if (project == null) {
                PhpAddBracesToStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpAddBracesToStatementQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddBracesToStatementQuickFix.$$$reportNull$$$0(4);
            }
            if (element instanceof Else) {
                Else anElse = (Else)element;
                v0 = anElse.getStatement();
            } else {
                v0 = statement = ((ControlStatement)element).getStatement();
            }
            if (statement == null) {
                return;
            }
            statement.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, GroupStatementImpl.class, "{" + statement.getText() + "}"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStatementWithoutBracesInspection$PhpAddBracesToStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStatementWithoutBracesInspection$PhpAddBracesToStatementQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

