/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpPreviousFunctionDfaAnalyzerProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpElementWithCondition;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.util.PhpStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStrFunctionsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStrFunctionsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference strFunctionReference) {
                if (!this.checkStrPosToStrContains(strFunctionReference)) {
                    this.checkSubstrToStartsWith(strFunctionReference);
                }
            }

            private boolean checkStrPosToStrContains(FunctionReference strFunctionReference) {
                IElementType operationType;
                Object elementToReplace = strFunctionReference.getParent();
                if (elementToReplace instanceof BinaryExpression) {
                    if (!PhpLangUtil.isFalse(PhpStrFunctionsInspection.getOppositeOperand((PsiElement)strFunctionReference, (BinaryExpression)elementToReplace))) {
                        return false;
                    }
                    operationType = ((BinaryExpression)elementToReplace).getOperationType();
                } else if (elementToReplace instanceof UnaryExpression && ((UnaryExpression)elementToReplace).getValue() == strFunctionReference && PhpPsiUtil.isOfType(((UnaryExpression)elementToReplace).getOperation(), PhpTokenTypes.opNOT)) {
                    operationType = PhpTokenTypes.opEQUAL;
                } else if (elementToReplace instanceof PhpElementWithCondition && ((PhpElementWithCondition)elementToReplace).getCondition() == strFunctionReference) {
                    operationType = PhpTokenTypes.opNOT_EQUAL;
                    elementToReplace = strFunctionReference;
                } else {
                    return false;
                }
                if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(strFunctionReference, "strpos")) {
                    if (!PhpStrFunctionsInspection.thirdParameterZeroOrAbsent(strFunctionReference)) {
                        return false;
                    }
                    if (operationType == PhpTokenTypes.opNOT_IDENTICAL && this.registerStrContainsFix(strFunctionReference, (PsiElement)elementToReplace, false) || operationType == PhpTokenTypes.opIDENTICAL && this.registerStrContainsFix(strFunctionReference, (PsiElement)elementToReplace, true)) {
                        return true;
                    }
                } else if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(strFunctionReference, "strstr")) {
                    if ((operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opNOT_EQUAL && !PhpStrFunctionsInspection.mayReturnEmptyString(strFunctionReference)) && this.registerStrContainsFix(strFunctionReference, (PsiElement)elementToReplace, false)) {
                        return true;
                    }
                    if ((operationType == PhpTokenTypes.opIDENTICAL || operationType == PhpTokenTypes.opEQUAL && !PhpStrFunctionsInspection.mayReturnEmptyString(strFunctionReference)) && this.registerStrContainsFix(strFunctionReference, (PsiElement)elementToReplace, true)) {
                        return true;
                    }
                }
                return false;
            }

            private boolean registerStrContainsFix(FunctionReference strFunctionReference, PsiElement elementToReplace, boolean negation) {
                LocalQuickFix fix = PhpReplaceWithStrFunctionQuickFixBase.createStrContainsFix(strFunctionReference, elementToReplace, negation);
                if (fix == null) {
                    return false;
                }
                holder.registerProblem(elementToReplace, PhpBundle.message("inspection.str.functions.strpos.call.can.be.converted.to.strcontains", new Object[0]), new LocalQuickFix[]{fix});
                return true;
            }

            private void checkSubstrToStartsWith(FunctionReference strFunctionReference) {
                BinaryExpression binaryExpression = (BinaryExpression)ObjectUtils.tryCast((Object)strFunctionReference.getParent(), BinaryExpression.class);
                if (binaryExpression == null) {
                    return;
                }
                IElementType type = binaryExpression.getOperationType();
                PsiElement rightOperand = PhpStrFunctionsInspection.getOppositeOperand((PsiElement)strFunctionReference, binaryExpression);
                boolean notIdentical = PhpStrFunctionsInspection.isAllowedNotIdentical(type, rightOperand);
                if ((PhpStrFunctionsInspection.isAllowedIdentical(type, rightOperand) || notIdentical) && PhpCodeInsightUtil.isGlobalFunctionCallWithName(strFunctionReference, "substr") && (this.strStartsWith(strFunctionReference, binaryExpression, rightOperand, notIdentical) || this.strEndsWith(strFunctionReference, binaryExpression, rightOperand, notIdentical))) {
                    return;
                }
                if (type == PhpTokenTypes.opIDENTICAL || type == PhpTokenTypes.opNOT_IDENTICAL) {
                    this.checkStrPosWithZeroComparison(strFunctionReference, binaryExpression, notIdentical);
                }
            }

            private void checkStrPosWithZeroComparison(FunctionReference strFunctionReference, BinaryExpression binaryExpression, boolean negation) {
                LocalQuickFix fix;
                if (!PhpStrFunctionsInspection.thirdParameterZeroOrAbsent(strFunctionReference)) {
                    return;
                }
                if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(strFunctionReference, "strpos") && PhpStrFunctionsInspection.isZero(PhpStrFunctionsInspection.getOppositeOperand((PsiElement)strFunctionReference, binaryExpression)) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrStartsWithFix(strFunctionReference, strFunctionReference.getParameter(1), binaryExpression, negation)) != null) {
                    holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.strpos.call.can.be.converted.to.strstartswith", new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private boolean strStartsWith(FunctionReference strFunctionReference, BinaryExpression binaryExpression, PsiElement needle, boolean negation) {
                PsiElement functionReferenceParameter = strFunctionReference.getParameter(2);
                if (PhpStrFunctionsInspection.isZero(strFunctionReference.getParameter(1))) {
                    LocalQuickFix fix;
                    if (functionReferenceParameter instanceof FunctionReference) {
                        LocalQuickFix fix2;
                        PsiElement firstParameter;
                        FunctionReference strlenFunctionReference = (FunctionReference)functionReferenceParameter;
                        if (PhpCodeInsightUtil.isGlobalFunctionCallWithName(strlenFunctionReference, "strlen") && (firstParameter = strlenFunctionReference.getParameter(0)) != null && needle != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)firstParameter, (PsiElement)needle) && (fix2 = PhpReplaceWithStrFunctionQuickFixBase.createStrStartsWithFix(strFunctionReference, needle, binaryExpression, negation)) != null) {
                            holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.substr.call.can.be.converted.to.strstartswith", new Object[0]), new LocalQuickFix[]{fix2});
                            return true;
                        }
                    } else if (PhpStrFunctionsInspection.needleIsStringLiteralWithValueLength(needle, functionReferenceParameter) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrStartsWithFix(strFunctionReference, needle, binaryExpression, negation)) != null) {
                        holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.substr.call.can.be.converted.to.strstartswith", new Object[0]), new LocalQuickFix[]{fix});
                        return true;
                    }
                }
                return false;
            }

            private boolean strEndsWith(FunctionReference strFunctionReference, BinaryExpression binaryExpression, PsiElement needle, boolean negation) {
                LocalQuickFix fix;
                PsiElement value = this.getStrlenValueToCheck(strFunctionReference, needle);
                if ((PhpStrFunctionsInspection.isStrlenCallWithArgumentValue(needle, value) || PhpStrFunctionsInspection.needleIsStringLiteralWithValueLength(needle, value)) && (fix = PhpReplaceWithStrFunctionQuickFixBase.createStrEndsWithFix(strFunctionReference, needle, binaryExpression, negation)) != null) {
                    holder.registerProblem((PsiElement)binaryExpression, PhpBundle.message("inspection.str.functions.substr.call.can.be.converted.to.strendswith", new Object[0]), new LocalQuickFix[]{fix});
                    return true;
                }
                return false;
            }

            @Nullable
            private static PsiElement getNegatedValue(PsiElement element) {
                if (element instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)element).getOperation(), PhpTokenTypes.opMINUS)) {
                    return ((UnaryExpression)element).getValue();
                }
                if (element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() == PhpTokenTypes.opMUL) {
                    PsiElement left = ((BinaryExpression)element).getLeftOperand();
                    PsiElement right = ((BinaryExpression)element).getRightOperand();
                    return PhpStrFunctionsInspection.isNumber(1.getNegatedValue(left), "1") ? right : (PhpStrFunctionsInspection.isNumber(1.getNegatedValue(right), "1") ? left : null);
                }
                return null;
            }

            private PsiElement getStrlenValueToCheck(FunctionReference strFunctionReference, PsiElement needle) {
                PsiElement lengthParameter = strFunctionReference.getParameter(2);
                PsiElement posParameter = strFunctionReference.getParameter(1);
                PsiElement value = 1.getNegatedValue(posParameter);
                if (value != null) {
                    if (lengthParameter == null) {
                        return value;
                    }
                    if (PhpStrFunctionsInspection.isNumber(lengthParameter, value.getText()) && PhpStrFunctionsInspection.isNumber(value, lengthParameter.getText())) {
                        return lengthParameter;
                    }
                }
                if (posParameter instanceof BinaryExpression) {
                    PsiElement left = ((BinaryExpression)posParameter).getLeftOperand();
                    if (((BinaryExpression)posParameter).getOperationType() == PhpTokenTypes.opMINUS) {
                        PsiElement haystack = strFunctionReference.getParameter(0);
                        PsiElement rightOperand = ((BinaryExpression)posParameter).getRightOperand();
                        if (rightOperand != null && PhpStrFunctionsInspection.isStrlenCallWithArgumentValue(haystack, left) && (lengthParameter != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)rightOperand, (PsiElement)lengthParameter) || lengthParameter == null && (PhpStrFunctionsInspection.isStrlenCallWithArgumentValue(needle, rightOperand) || PhpStrFunctionsInspection.needleIsStringLiteralWithValueLength(needle, rightOperand)))) {
                            return rightOperand;
                        }
                    }
                }
                return null;
            }
        };
    }

    private static boolean mayReturnEmptyString(FunctionReference reference) {
        if (reference.getParameter("before_needle", 2) != null) {
            return true;
        }
        PsiElement needle = reference.getParameter("needle", 1);
        PhpPreviousFunctionDfaAnalyzerProcessor.PhpStrLengthEstimation estimation = PhpPreviousFunctionDfaAnalyzerProcessor.estimateStringLength(needle);
        return estimation == null || estimation.getMinLength() == 0;
    }

    private static boolean isStrlenCallWithArgumentValue(PsiElement argument, PsiElement strlenCall) {
        if (strlenCall instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)strlenCall, "strlen")) {
            PsiElement parameter = ((FunctionReference)strlenCall).getParameter(0);
            return parameter != null && argument != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)parameter, (PsiElement)argument);
        }
        return false;
    }

    private static boolean isAllowedIdentical(IElementType operationType, PsiElement operand) {
        return operationType == PhpTokenTypes.opIDENTICAL || operationType == PhpTokenTypes.opEQUAL && PhpStrFunctionsInspection.isConvertibleFromString(operand);
    }

    private static boolean isAllowedNotIdentical(IElementType operationType, PsiElement operand) {
        return operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opNOT_EQUAL && PhpStrFunctionsInspection.isConvertibleFromString(operand);
    }

    private static boolean isConvertibleFromString(PsiElement operand) {
        return operand != null && PhpType.STRING.isConvertibleFromGlobal(operand.getProject(), new PhpType().add(operand));
    }

    private static boolean needleIsStringLiteralWithValueLength(PsiElement needle, PsiElement value) {
        return needle instanceof StringLiteralExpression && PhpPsiUtil.getChildByCondition(needle, Variable.INSTANCEOF) == null && PhpStrFunctionsInspection.isNumber(value, String.valueOf(PhpStrFunctionsInspection.countEscapedLength((StringLiteralExpression)needle)));
    }

    public static int countEscapedLength(StringLiteralExpression literal) {
        int[] length = new int[]{0};
        PhpStringUtil.StringLiteralSpliterator spliterator = new PhpStringUtil.StringLiteralSpliterator(literal.getContents(), literal.isSingleQuote());
        spliterator.forEachRemaining(pair -> {
            length[0] = StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains((IElementType)pair.getSecond()) ? length[0] + 1 : length[0] + ((TextRange)pair.first).getLength();
        });
        return length[0];
    }

    private static boolean thirdParameterZeroOrAbsent(FunctionReference strFunctionReference) {
        PsiElement offsetParameter = strFunctionReference.getParameter(2);
        return offsetParameter == null || PhpStrFunctionsInspection.isZero(offsetParameter);
    }

    @Nullable
    public static PsiElement getOppositeOperand(PsiElement currentOperand, BinaryExpression binaryExpression) {
        PsiElement left = binaryExpression.getLeftOperand();
        PsiElement right = binaryExpression.getRightOperand();
        return left == currentOperand ? right : left;
    }

    private static boolean isZero(@Nullable PsiElement startIndex) {
        return PhpStrFunctionsInspection.isNumber(startIndex, "0");
    }

    public static boolean isNumber(@Nullable PsiElement startIndex, String val) {
        return PhpPsiUtil.isOfType(startIndex, PhpElementTypes.NUMBER) && PhpPsiUtil.getLiteralText(startIndex).equals(val);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithStrFunctionQuickFixBase
    extends LocalQuickFixOnPsiElement {
        private final String myFunctionName;
        @FileModifier.SafeFieldForPreview
        private final SmartPsiElementPointer<PsiElement> myNeedle;
        private final boolean myNegation;

        protected PhpReplaceWithStrFunctionQuickFixBase(@NotNull String functionName, @NotNull PsiElement elementToReplace, @NotNull PsiElement haystack, @NotNull PsiElement needle, boolean negation) {
            if (functionName == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(0);
            }
            if (elementToReplace == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(1);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(2);
            }
            if (needle == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(3);
            }
            super(elementToReplace, haystack);
            this.myFunctionName = functionName;
            this.myNeedle = SmartPointerManager.getInstance((Project)needle.getProject()).createSmartPsiElementPointer(needle);
            this.myNegation = negation;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myFunctionName);
            if (string == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(5);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementToReplace, @NotNull PsiElement haystack) {
            PsiElement needle;
            if (project == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(6);
            }
            if (file == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(7);
            }
            if (elementToReplace == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(8);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(9);
            }
            if ((needle = this.myNeedle.getElement()) == null) {
                return;
            }
            Object createdReplacement = this.createElementToReplace(project, haystack, needle);
            if (this.myNegation) {
                createdReplacement = PhpPsiElementFactory.createPhpPsiFromText(project, UnaryExpression.class, "!" + createdReplacement.getText());
            }
            elementToReplace.replace(createdReplacement);
        }

        @NotNull
        protected PsiElement createElementToReplace(@NotNull Project project, @NotNull PsiElement haystack, PsiElement needle) {
            if (project == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(10);
            }
            if (haystack == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(11);
            }
            FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, String.format("%s(%s, %s)", this.myFunctionName, haystack.getText(), needle.getText()));
            if (functionReference == null) {
                PhpReplaceWithStrFunctionQuickFixBase.$$$reportNull$$$0(12);
            }
            return functionReference;
        }

        @Nullable
        public static LocalQuickFix createStrContainsFix(FunctionReference strFunctionReference, PsiElement elementToReplace, boolean negation) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            PsiElement needle = strFunctionReference.getParameter(1);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_contains", elementToReplace, haystack, needle, negation) : null;
        }

        @Nullable
        public static LocalQuickFix createStrStartsWithFix(FunctionReference strFunctionReference, PsiElement needle, BinaryExpression binaryExpression, boolean negation) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_starts_with", (PsiElement)binaryExpression, haystack, needle, negation) : null;
        }

        @Nullable
        private static LocalQuickFix createStrEndsWithFix(FunctionReference strFunctionReference, PsiElement needle, BinaryExpression binaryExpression, boolean negation) {
            PsiElement haystack = strFunctionReference.getParameter(0);
            return haystack != null && needle != null ? new PhpReplaceWithStrFunctionQuickFixBase("str_ends_with", (PsiElement)binaryExpression, haystack, needle, negation) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToReplace";
                    break;
                }
                case 2: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "haystack";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "needle";
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection$PhpReplaceWithStrFunctionQuickFixBase";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpStrFunctionsInspection$PhpReplaceWithStrFunctionQuickFixBase";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createElementToReplace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 12: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createElementToReplace";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 12 -> new IllegalStateException(string);
            };
        }
    }
}

