/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.probablyBug.PhpUncoveredEnumCasesInspection;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithSwitchIntention;
import com.jetbrains.php.lang.intentions.PhpReplaceSwitchWithIfIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCustomFunctionPredicateIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionAlwaysThrowsIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSwitchCanBeReplacedWithMatchExpressionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSwitch(PhpSwitch switchStatement) {
                if (switchStatement.getArgument() == null) {
                    return;
                }
                List<PhpReplaceSwitchWithIfIntention.SwitchStatementBranch> branches = PhpReplaceSwitchWithIfIntention.collectBranches(holder.getProject(), switchStatement);
                if (branches.isEmpty()) {
                    return;
                }
                PhpCase defaultCase = switchStatement.getDefaultCase();
                if (defaultCase != null && ArrayUtil.getLastElement((Object[])switchStatement.getAllCases()) != defaultCase) {
                    return;
                }
                if (!PhpSwitchCanBeReplacedWithMatchExpressionInspection.canBeReplacedWithMatchExpression((PsiElement)switchStatement, branches, (PsiElement)defaultCase)) {
                    return;
                }
                holder.registerProblem(switchStatement.getFirstChild(), PhpBundle.message("inspection.message.switch.can.be.replaced.with.match", new Object[0]), new LocalQuickFix[]{PhpReplaceSwitchWithMatchExpressionFix.INSTANCE});
            }
        };
    }

    static boolean canBeReplacedWithMatchExpression(PsiElement controlStatement, List<? extends PhpReplaceIfWithSwitchIntention.ControlStatementBranch> branches, PsiElement defaultBranch) {
        PhpReplaceIfWithSwitchIntention.ControlStatementBranch firstBranch = branches.get(0);
        if (firstBranch.getOnlyBodyStatement() == null) {
            return false;
        }
        PsiElement firstCaseLeftHandSide = (PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)firstBranch.getOnlyBodyStatement()).first;
        if (firstCaseLeftHandSide == null) {
            return false;
        }
        if (!(!PhpSwitchCanBeReplacedWithMatchExpressionInspection.isDefaultCaseNeededForProperExtraction(firstCaseLeftHandSide) || defaultBranch != null || firstCaseLeftHandSide instanceof PhpReturn && PhpSwitchCanBeReplacedWithMatchExpressionInspection.hasSuitableReturnForDefaultArmAfter(controlStatement))) {
            return false;
        }
        for (PhpReplaceIfWithSwitchIntention.ControlStatementBranch controlStatementBranch : branches) {
            if (controlStatementBranch.getOnlyBodyStatement() == null) {
                return false;
            }
            PsiElement leftHandSide = (PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)controlStatementBranch.getOnlyBodyStatement()).first;
            if (leftHandSide == null) {
                return false;
            }
            if (!(leftHandSide.getClass() == firstCaseLeftHandSide.getClass() || controlStatementBranch.isDefault() && PhpSwitchCanBeReplacedWithMatchExpressionInspection.isAlwaysThrowExpression(leftHandSide))) {
                return false;
            }
            if (!(leftHandSide instanceof AssignmentExpression) || PhpSwitchCanBeReplacedWithMatchExpressionInspection.isHomogeneousAssignments(firstCaseLeftHandSide, leftHandSide)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlwaysThrowExpression(PsiElement element) {
        if (element instanceof FunctionReference) {
            return PhpCustomFunctionPredicateIndex.matchesHierarchyAware((FunctionReference)element, PhpFunctionAlwaysThrowsIndex.class);
        }
        return element instanceof PhpThrowExpression;
    }

    private static boolean hasSuitableReturnForDefaultArmAfter(PsiElement element) {
        PhpReturn phpReturn = (PhpReturn)ObjectUtils.tryCast((Object)PhpPsiUtil.getNextSiblingIgnoreWhitespace(element, true), PhpReturn.class);
        Function function = PhpPsiUtil.getParentOfClass((PsiElement)phpReturn, Function.class);
        return phpReturn != null && (phpReturn.getArgument() != null || function != null && function.getTypeDeclaration() == null);
    }

    public static boolean isHomogeneousAssignments(PsiElement patternAssignment, PsiElement assignment) {
        if (patternAssignment.getClass() != assignment.getClass()) {
            return false;
        }
        if (patternAssignment instanceof SelfAssignmentExpression && assignment instanceof SelfAssignmentExpression && ((SelfAssignmentExpression)patternAssignment).getOperationType() != ((SelfAssignmentExpression)assignment).getOperationType()) {
            return false;
        }
        if (patternAssignment instanceof AssignmentExpression && assignment instanceof AssignmentExpression) {
            PhpPsiElement patternVariable = ((AssignmentExpression)patternAssignment).getVariable();
            PhpPsiElement variable = ((AssignmentExpression)assignment).getVariable();
            if (patternVariable instanceof FieldReference && variable instanceof FieldReference) {
                return StringUtil.equals((CharSequence)variable.getName(), (CharSequence)patternVariable.getName());
            }
            if (patternVariable instanceof ArrayAccessExpression && variable instanceof ArrayAccessExpression) {
                return StringUtil.equalsIgnoreWhitespaces((CharSequence)patternVariable.getText(), (CharSequence)variable.getText());
            }
            return patternVariable instanceof Variable && variable instanceof Variable && ((Variable)variable).getName().equals(((Variable)patternVariable).getName());
        }
        return false;
    }

    private static boolean isDefaultCaseNeededForProperExtraction(PsiElement firstCaseLeftHandSide) {
        return firstCaseLeftHandSide instanceof PhpReturn || firstCaseLeftHandSide instanceof PhpEchoStatement || firstCaseLeftHandSide instanceof PhpPrintExpression || firstCaseLeftHandSide instanceof PhpThrowExpression || firstCaseLeftHandSide instanceof AssignmentExpression;
    }

    public static @NotNull Pair<@Nullable PsiElement, @Nullable PhpExpression> destructureStatement(@NotNull PsiElement statement) {
        PsiElement firstChild;
        if (statement == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(1);
        }
        if ((firstChild = statement.getFirstChild()) instanceof AssignmentExpression) {
            return PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureAssignment((AssignmentExpression)firstChild);
        }
        if (statement instanceof PhpReturn) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)((PhpReturn)statement).getArgument(), PhpExpression.class);
            if (argument == null) {
                Function function = PhpPsiUtil.getParentOfClass(statement, Function.class);
                if (function == null || function.getTypeDeclaration() != null) {
                    Pair pair = Pair.empty();
                    if (pair == null) {
                        PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(2);
                    }
                    return pair;
                }
                argument = PhpPsiElementFactory.createConstantReference(statement.getProject(), "null");
            }
            Pair pair = Pair.create((Object)statement, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(3);
            }
            return pair;
        }
        if (firstChild instanceof PhpThrowExpression) {
            PhpExpression argument = ((PhpThrowExpression)firstChild).getArgument();
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(4);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)firstChild, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(5);
            }
            return pair;
        }
        if (firstChild instanceof FunctionReference && PhpSwitchCanBeReplacedWithMatchExpressionInspection.isSimpleStatementWithSingleExpression(statement) && PhpSwitchCanBeReplacedWithMatchExpressionInspection.isAlwaysThrowExpression(firstChild)) {
            Pair pair = Pair.create((Object)firstChild, (Object)((FunctionReference)firstChild));
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(6);
            }
            return pair;
        }
        if (statement instanceof PhpEchoStatement) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])((PhpEchoStatement)statement).getArguments()), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(7);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)statement, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(8);
            }
            return pair;
        }
        if (firstChild instanceof PhpPrintExpression) {
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)((PhpPrintExpression)firstChild).getArgument(), PhpExpression.class);
            if (argument == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(9);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)firstChild, (Object)argument);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(10);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static boolean isSimpleStatementWithSingleExpression(@NotNull PsiElement statement) {
        if (statement == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(12);
        }
        return statement instanceof Statement && PhpPsiUtil.getOnlyPsiChild((Statement)statement, PsiElement.class) != null;
    }

    public static @NotNull Pair<@Nullable PsiElement, @Nullable PhpExpression> destructureAssignment(@NotNull AssignmentExpression assignment) {
        if (assignment == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(13);
        }
        if (PhpSwitchCanBeReplacedWithMatchExpressionInspection.isNullCoalesceAssignment((PsiElement)assignment) || PhpWorkaroundUtil.isAssignByReference(assignment)) {
            Pair pair = Pair.empty();
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(14);
            }
            return pair;
        }
        PhpExpression value = (PhpExpression)ObjectUtils.tryCast((Object)assignment.getValue(), PhpExpression.class);
        if (value == null) {
            Pair pair = Pair.empty();
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(15);
            }
            return pair;
        }
        PhpPsiElement variable = assignment.getVariable();
        if (variable instanceof Variable || variable instanceof FieldReference || variable instanceof ArrayAccessExpression) {
            Pair pair = Pair.create((Object)assignment, (Object)value);
            if (pair == null) {
                PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Pair pair = Pair.empty();
        if (pair == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(17);
        }
        return pair;
    }

    private static boolean isNullCoalesceAssignment(@NotNull PsiElement expr) {
        if (expr == null) {
            PhpSwitchCanBeReplacedWithMatchExpressionInspection.$$$reportNull$$$0(18);
        }
        return expr instanceof SelfAssignmentExpression && ((SelfAssignmentExpression)expr).getOperationType() == PhpTokenTypes.opCOALESCE_ASGN;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "destructureStatement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "destructureAssignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "destructureStatement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleStatementWithSingleExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "destructureAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNullCoalesceAssignment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    public static class PhpReplaceSwitchWithMatchExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpReplaceSwitchWithMatchExpressionFix();

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.switch.with.match.expression", new Object[0]);
            if (string == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(3);
            }
            PhpSwitch switchStatement = PhpPsiUtil.getParentOfClass(element, PhpSwitch.class);
            assert (switchStatement != null);
            List<PhpReplaceSwitchWithIfIntention.SwitchStatementBranch> branches = PhpReplaceSwitchWithIfIntention.collectBranches(project, switchStatement);
            if (branches.isEmpty()) {
                return;
            }
            PhpReplaceSwitchWithMatchExpressionFix.applyFix(project, (PsiElement)switchStatement, switchStatement.getArgument(), branches);
        }

        public static void applyFix(@NotNull Project project, PsiElement switchStatement, PsiElement argument, List<? extends PhpReplaceIfWithSwitchIntention.ControlStatementBranch> branches) {
            String matchText;
            if (project == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(4);
            }
            if ((matchText = PhpReplaceSwitchWithMatchExpressionFix.getMatchExpressionText(argument, branches)) == null) {
                return;
            }
            String leftHandSideText = PhpReplaceSwitchWithMatchExpressionFix.getLeftHandSideText((PsiElement)PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)branches.get((int)0).getOnlyBodyStatement()).first);
            if (leftHandSideText == null) {
                return;
            }
            PsiElement newStatement = switchStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(project, leftHandSideText + matchText));
            PhpMatchExpression matchExpression = (PhpMatchExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)newStatement, (Class[])new Class[]{PhpMatchExpression.class});
            assert (matchExpression != null);
            AssignmentExpression assignmentExpression = (AssignmentExpression)PhpPsiUtil.getChildByCondition(newStatement, AssignmentExpression.INSTANCEOF);
            if (assignmentExpression != null && !(assignmentExpression instanceof SelfAssignmentExpression)) {
                PhpReplaceSwitchWithMatchExpressionFix.tryMoveOuterAssignmentToDefaultArm(assignmentExpression, matchExpression);
            } else if (newStatement instanceof PhpReturn && PhpSwitchCanBeReplacedWithMatchExpressionInspection.hasSuitableReturnForDefaultArmAfter(newStatement) && matchExpression.getDefaultMatchArm() == null) {
                PhpReplaceSwitchWithMatchExpressionFix.replaceOuterReturnWithDefaultArm(project, newStatement, matchExpression);
            }
        }

        private static void replaceOuterReturnWithDefaultArm(@NotNull Project project, @NotNull PsiElement newStatement, @NotNull PhpMatchExpression matchExpression) {
            if (project == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(5);
            }
            if (newStatement == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(6);
            }
            if (matchExpression == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(7);
            }
            PhpReturn phpReturn = (PhpReturn)PhpPsiUtil.getNextSiblingByCondition(newStatement, PhpReturn.INSTANCEOF);
            assert (phpReturn != null);
            PsiElement argument = phpReturn.getArgument();
            PhpMatchArm defaultArm = PhpPsiElementFactory.createMatchArm(project, "default", argument != null ? argument.getText() : "null");
            PhpUncoveredEnumCasesInspection.PhpAddMissingEnumCasesQuickFix.appendMatchArm(project, matchExpression, (PsiElement)defaultArm);
            phpReturn.delete();
        }

        private static void tryMoveOuterAssignmentToDefaultArm(@NotNull AssignmentExpression expression, @NotNull PhpMatchExpression matchExpression) {
            PhpPsiElement variable;
            if (expression == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(8);
            }
            if (matchExpression == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(9);
            }
            if (!((variable = expression.getVariable()) instanceof Variable)) {
                return;
            }
            Pair<PsiElement, PsiElement> prevAssignmentToValue = PhpReplaceSwitchWithMatchExpressionFix.getPrevAssignmentStatementToAssignedValue(expression);
            PsiElement value = (PsiElement)prevAssignmentToValue.second;
            if (value == null) {
                return;
            }
            if (matchExpression.getDefaultMatchArm() != null) {
                if (!(expression instanceof SelfAssignmentExpression)) {
                    ((PsiElement)prevAssignmentToValue.first).delete();
                }
                return;
            }
            PhpMatchArm defaultArm = PhpPsiElementFactory.createMatchArm(expression.getProject(), "default", value.getText());
            PhpUncoveredEnumCasesInspection.PhpAddMissingEnumCasesQuickFix.appendMatchArm(expression.getProject(), matchExpression, (PsiElement)defaultArm);
            ((PsiElement)prevAssignmentToValue.first).delete();
        }

        @NotNull
        public static Pair<PsiElement, PsiElement> getPrevAssignmentStatementToAssignedValue(AssignmentExpression assignmentExpression) {
            return PhpReplaceSwitchWithMatchExpressionFix.getPrevAssignmentStatementToAssignedValue((PsiElement)assignmentExpression, assignmentExpression.getVariable());
        }

        @NotNull
        public static Pair<PsiElement, PsiElement> getPrevAssignmentStatementToAssignedValue(final PsiElement statement, final PhpPsiElement variable) {
            PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
            if (instruction == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(10);
                }
                return pair;
            }
            final Ref prevStatementToValueRef = Ref.create((Object)Pair.empty());
            PhpControlFlowUtil.processPreviousVariableAccesses(instruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processHostInstruction(PhpHostInstruction instruction) {
                    Object parentStatement = PhpPsiUtil.getParentByCondition(instruction.getAnchor(), (Condition<? super PsiElement>)((Condition)e -> e == statement), (Condition<? super PsiElement>)((Condition)e -> e != statement && e instanceof Statement));
                    if (parentStatement == null) {
                        return false;
                    }
                    return super.processHostInstruction(instruction);
                }

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    AssignmentExpression prevExpression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                    if (!instruction.getAccess().isWrite() || prevExpression == null || prevExpression instanceof SelfAssignmentExpression) {
                        return false;
                    }
                    PhpPsiElement variableToMove = prevExpression.getVariable();
                    if (variableToMove == null || !PhpLangUtil.equalsVariableNames(variable.getName(), variableToMove.getName())) {
                        return false;
                    }
                    PhpPsiElement value = prevExpression.getValue();
                    if (value == null || PhpSideEffectDetector.canContainSideEffect((PsiElement)value)) {
                        return false;
                    }
                    Statement prevStatement = PhpPsiUtil.getParentOfClass((PsiElement)prevExpression, Statement.class);
                    if (prevStatement == null) {
                        return false;
                    }
                    prevStatementToValueRef.set((Object)Pair.create((Object)prevStatement, (Object)value));
                    return false;
                }
            });
            Pair pair = (Pair)prevStatementToValueRef.get();
            if (pair == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(11);
            }
            return pair;
        }

        @Nullable
        public static String getLeftHandSideText(@Nullable PsiElement element) {
            if (element == null) {
                return null;
            }
            if (element instanceof AssignmentExpression) {
                PhpPsiElement variable = ((AssignmentExpression)element).getVariable();
                if (variable instanceof Variable) {
                    return "$" + ((Variable)variable).getName() + PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText(element);
                }
                if (variable instanceof FieldReference) {
                    return variable.getText() + PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText(element);
                }
                if (variable instanceof ArrayAccessExpression) {
                    return variable.getText() + PhpReplaceSwitchWithMatchExpressionFix.getAssignOpText(element);
                }
            } else if (element instanceof FunctionReference) {
                return element.getText();
            }
            return element.getFirstChild().getText() + " ";
        }

        public static String getAssignOpText(@NotNull PsiElement element) {
            PsiElement op;
            if (element == null) {
                PhpReplaceSwitchWithMatchExpressionFix.$$$reportNull$$$0(12);
            }
            if (element instanceof SelfAssignmentExpression && (op = ((SelfAssignmentExpression)element).getOperation()) != null) {
                return op.getText();
            }
            return "=";
        }

        @Nullable
        private static String getMatchExpressionText(PsiElement argument, List<? extends PhpReplaceIfWithSwitchIntention.ControlStatementBranch> branches) {
            assert (argument != null);
            StringBuilder matchBuilder = new StringBuilder("match(" + argument.getText() + "){");
            boolean allThrows = ContainerUtil.all(branches, b -> PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement((PsiElement)b.getOnlyBodyStatement()).first instanceof PhpThrowExpression);
            for (PhpReplaceIfWithSwitchIntention.ControlStatementBranch controlStatementBranch : branches) {
                Pair<PsiElement, PhpExpression> destructuredStatement = PhpSwitchCanBeReplacedWithMatchExpressionInspection.destructureStatement(controlStatementBranch.getOnlyBodyStatement());
                PhpExpression expression = (PhpExpression)destructuredStatement.second;
                if (expression == null) {
                    return null;
                }
                if (controlStatementBranch.isDefault()) {
                    matchBuilder.append("default");
                } else {
                    matchBuilder.append(StringUtil.join(controlStatementBranch.getValues(), (String)","));
                }
                matchBuilder.append("=>");
                if (!allThrows && controlStatementBranch.isDefault() && destructuredStatement.first instanceof PhpThrowExpression) {
                    matchBuilder.append("throw ");
                }
                matchBuilder.append(expression.getText());
                matchBuilder.append(",");
            }
            matchBuilder.append("};");
            return matchBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection$PhpReplaceSwitchWithMatchExpressionFix";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newStatement";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchExpression";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpSwitchCanBeReplacedWithMatchExpressionInspection$PhpReplaceSwitchWithMatchExpressionFix";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrevAssignmentStatementToAssignedValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceOuterReturnWithDefaultArm";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "tryMoveOuterAssignmentToDefaultArm";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getAssignOpText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12 -> new IllegalArgumentException(string);
            };
        }
    }
}

