/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lexer.FlexAdapter;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.lexer._PhpLexer;
import com.jetbrains.php.lang.lexer.managers.StatesManager;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnnecessaryCurlyVarSyntaxInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryCurlyVarSyntaxInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                if (expression.isSingleQuote()) {
                    return;
                }
                for (Variable variable : PhpPsiUtil.getChildren((PsiElement)expression, (Condition<? super PsiElement>)((Condition)Variable.class::isInstance))) {
                    PsiElement firstChild = variable.getFirstChild();
                    if ((!PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.chLBRACE) || !PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariableExpression(variable)) && !PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariable(variable)) continue;
                    if (isOnTheFly) {
                        TextRange firstChildRange = PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.DOLLAR_LBRACE) ? TextRange.create((int)1, (int)2) : TextRange.create((int)0, (int)1);
                        holder.registerProblem(firstChild, PhpBundle.message("inspection.message.unnecessary.curly.braces", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, firstChildRange, new LocalQuickFix[]{PhpUnwrapCurlyBracesQuickFix.INSTANCE});
                        PsiElement closingBrace = variable.getLastChild();
                        if (!PhpPsiUtil.isOfType(closingBrace, PhpTokenTypes.chRBRACE)) continue;
                        holder.registerProblem(closingBrace, PhpBundle.message("inspection.message.unnecessary.curly.braces", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{PhpUnwrapCurlyBracesQuickFix.INSTANCE});
                        continue;
                    }
                    holder.registerProblem((PsiElement)variable, PhpBundle.message("inspection.message.unnecessary.curly.braces", PhpUnwrapCurlyBracesQuickFix.INSTANCE), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isSimpleVariableExpression(Variable variable) {
        PhpPsiElement child = variable.getFirstPsiChild();
        if (child instanceof ArrayAccessExpression) {
            if (((ArrayAccessExpression)child).getValue() instanceof Variable) {
                ArrayIndex index = ((ArrayAccessExpression)child).getIndex();
                if (index == null) {
                    return true;
                }
                PhpPsiElement value = index.getValue();
                return value instanceof Variable || PhpPsiUtil.isOfType((PsiElement)value, PhpElementTypes.NUMBER);
            }
            return false;
        }
        if (child instanceof FieldReference) {
            return ((FieldReference)child).getClassReference() instanceof Variable && !PhpUnnecessaryCurlyVarSyntaxInspection.nextCharIsPartOfIdentifier(variable);
        }
        return PhpUnnecessaryCurlyVarSyntaxInspection.isSimpleVariable(variable);
    }

    private static boolean isSimpleVariable(Variable variable) {
        PsiElement firstChild = variable.getFirstChild();
        PsiElement innerVariable = firstChild.getNextSibling();
        return variable.getFirstPsiChild() == null && PhpPsiUtil.isOfType(innerVariable, PhpTokenTypes.VARIABLE) && (!PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.DOLLAR_LBRACE) || !innerVariable.getText().startsWith("$")) && !PhpUnnecessaryCurlyVarSyntaxInspection.nextCharIsPartOfIdentifier(variable);
    }

    private static boolean nextCharIsPartOfIdentifier(Variable variable) {
        PsiElement nextSibling = variable.getNextSibling();
        if (nextSibling == null) {
            return false;
        }
        String nextSiblingText = nextSibling.getText();
        if (variable.getPrevSibling() != null && variable.getPrevSibling().getText().endsWith("{")) {
            return true;
        }
        PhpPsiElement innerVariable = variable.getFirstPsiChild();
        return !nextSiblingText.isEmpty() && PhpUnnecessaryCurlyVarSyntaxInspection.willCharBecomePartOfIdentifier((PsiElement)ObjectUtils.notNull((Object)innerVariable, (Object)variable), nextSiblingText.charAt(0));
    }

    private static boolean willCharBecomePartOfIdentifier(PsiElement element, char c) {
        PhpLexer lexer = new PhpLexer(false);
        StatesManager sManager = ((_PhpLexer)((FlexAdapter)lexer.getOriginal()).getFlex()).sManager;
        String elementText = null;
        if (element instanceof FieldReference) {
            elementText = ((FieldReference)element).getName() + c;
            PhpUnnecessaryCurlyVarSyntaxInspection.startInDoubleQuotes(lexer, sManager, elementText);
            sManager.toState(24);
        } else if (element instanceof Variable) {
            elementText = "$" + ((Variable)element).getName() + c;
            PhpUnnecessaryCurlyVarSyntaxInspection.startInDoubleQuotes(lexer, sManager, elementText);
        }
        if (elementText != null && lexer.getTokenText().equals(elementText)) {
            return true;
        }
        lexer.advance();
        return !PhpTokenTypes.tsSTRING_EDGE.contains(lexer.getTokenType()) && !PhpTokenTypes.tsSTRINGS.contains(lexer.getTokenType());
    }

    private static void startInDoubleQuotes(PhpLexer lexer, StatesManager sManager, String elementText) {
        lexer.start((CharSequence)elementText);
        sManager.toState(6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection", "buildVisitor"));
    }

    private static class PhpUnwrapCurlyBracesQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpUnwrapCurlyBracesQuickFix();

        private PhpUnwrapCurlyBracesQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.unwrap.curly.braces", new Object[0]);
            if (string == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Variable variable;
            if (project == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnwrapCurlyBracesQuickFix.$$$reportNull$$$0(3);
            }
            if ((variable = PhpPsiUtil.getParentOfClass(element, false, Variable.class)) == null) {
                return;
            }
            PsiElement innerVariable = variable.getFirstChild().getNextSibling();
            Object innerVariableText = PhpPsiUtil.isOfType(variable.getFirstChild(), PhpTokenTypes.DOLLAR_LBRACE) ? "$" + variable.getName() : innerVariable.getText();
            variable.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Variable.class, "\"" + (String)innerVariableText + "\""));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection$PhpUnwrapCurlyBracesQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryCurlyVarSyntaxInspection$PhpUnwrapCurlyBracesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

