/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpUnnecessaryLeadingBackslashInUseStatementInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryLeadingBackslashInUseStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpUse(PhpUse expression) {
                PhpReference reference = expression.getTargetReference();
                if (PhpUnnecessaryLeadingBackslashInUseStatementInspection.isAbsoluteReference(reference) && !expression.isTraitImport()) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.unnecessary.leading.slash", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, TextRange.create((int)0, (int)1), new LocalQuickFix[]{PhpRemoveLeadingSlashQuickFix.INSTANCE});
                }
            }
        };
    }

    private static boolean isAbsoluteReference(PhpReference reference) {
        return reference != null && StringUtil.startsWithChar((CharSequence)reference.getImmediateNamespaceName(), (char)'\\');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection", "buildVisitor"));
    }

    private static class PhpRemoveLeadingSlashQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpRemoveLeadingSlashQuickFix();

        private PhpRemoveLeadingSlashQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.remove.leading", new Object[0]);
            if (string == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PhpReference classReference;
            if (project == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpRemoveLeadingSlashQuickFix.$$$reportNull$$$0(4);
            }
            if (!PhpUnnecessaryLeadingBackslashInUseStatementInspection.isAbsoluteReference(classReference = PhpPsiUtil.getParentOfClass(element, false, PhpReference.class))) {
                return;
            }
            classReference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpReference.class, String.format("use %s %s", PhpBaseImportQuickFix.getKeyword(classReference).getValue(), classReference.getText().substring(1))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpUnnecessaryLeadingBackslashInUseStatementInspection$PhpRemoveLeadingSlashQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

