/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldByVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessFieldInObjectContextInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpArrayIndexResetIsUnnecessaryInspection
extends PhpInspection {
    private static final Set<String> STD_ARRAY_INDEX_RESET_FUNCTIONS = Set.of("rsort", "shuffle", "sort", "uasort", "uksort", "usort", "krsort", "ksort", "natcasesort", "natsort", "array_multisort", "arsort", "asort", "array_unshift", "reset");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArrayIndexResetIsUnnecessaryInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                if (PhpCodeInsightUtil.isResultUsed((PsiElement)reference)) {
                    return;
                }
                ParameterList argumentsList = reference.getParameterList();
                if (argumentsList == null) {
                    return;
                }
                Variable value = (Variable)ObjectUtils.tryCast((Object)argumentsList.getParameter(0), Variable.class);
                if (value == null) {
                    return;
                }
                String arrayName = value.getName();
                PhpCallInstruction instruction = PhpControlFlowUtil.getCallInstruction(reference);
                Ref navigateToElement = new Ref(null);
                if (instruction == null || !PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, "reset")) {
                    return;
                }
                if ((PhpArrayIndexResetIsUnnecessaryInspection.argumentPassedByRefToParentFunction(reference, value) || !PhpArrayIndexResetIsUnnecessaryInspection.isLastRefAccess(instruction, value)) && PhpArrayIndexResetIsUnnecessaryInspection.arrayInternalPointerChanged(instruction, arrayName, reference, (Ref<PsiElement>)navigateToElement)) {
                    return;
                }
                PsiElement parent = reference.getParent();
                PhpDeleteElementQuickFix fix = new PhpDeleteElementQuickFix(parent, PhpBundle.message("remove.unnecessary.reset", new Object[0]));
                PhpNavigateToElementQuickFix navigateToElementQuickFix = null;
                if (navigateToElement.get() != null) {
                    navigateToElementQuickFix = new PhpNavigateToElementQuickFix((PsiElement)navigateToElement.get(), PhpBundle.message("inspection.php.internal.array.index.reset.is.unnecessary.navigate.to.function", new Object[0]));
                }
                holder.problem((PsiElement)reference, PhpBundle.message("inspection.php.internal.array.index.reset.is.unnecessary", new Object[0])).fix((ModCommandAction)fix).maybeFix((ModCommandAction)navigateToElementQuickFix).register();
            }
        };
    }

    private static boolean arrayInternalPointerChanged(PhpCallInstruction instruction, final CharSequence arrayName, final FunctionReference reference, final Ref<PsiElement> navigateToElement) {
        final Ref ambiguous = new Ref((Object)false);
        final Ref arrayPointerReset = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), arrayName)) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    if (access.isWrite()) {
                        PsiElement value = PhpArrayIndexResetIsUnnecessaryInspection.getAssignedValue(instruction);
                        if (PhpArrayIndexResetIsUnnecessaryInspection.isArrayInZeroStateCreation(value)) {
                            arrayPointerReset.set((Object)Boolean.TRUE);
                        } else {
                            ambiguous.set((Object)Boolean.TRUE);
                            this.haltTraversal();
                        }
                        return false;
                    }
                    if (access.isReadRef()) {
                        FunctionReference functionReference = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), FunctionReference.class);
                        if (functionReference != null) {
                            if (reference.equals(functionReference)) {
                                return true;
                            }
                            if (PhpArrayIndexResetIsUnnecessaryInspection.isStdArrayResetFunction(functionReference)) {
                                navigateToElement.set((Object)functionReference);
                                arrayPointerReset.set((Object)Boolean.TRUE);
                                return false;
                            }
                        }
                        ambiguous.set((Object)Boolean.TRUE);
                        this.haltTraversal();
                        return false;
                    }
                    if (access.isWriteRef()) {
                        ambiguous.set((Object)Boolean.TRUE);
                        this.haltTraversal();
                        return false;
                    }
                }
                return super.processAccessVariableInstruction(instruction);
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguous.set((Object)Boolean.TRUE);
                this.haltTraversal();
                return super.processEntryPointInstruction(instruction);
            }
        });
        return (Boolean)ambiguous.get() != false || (Boolean)arrayPointerReset.get() == false;
    }

    private static boolean argumentPassedByRefToParentFunction(FunctionReference reference, Variable argument) {
        Function parentFunction = PhpPsiUtil.getParentOfClass((PsiElement)reference, Function.class);
        if (parentFunction != null && parentFunction.hasRefParams()) {
            return ContainerUtil.exists((Object[])parentFunction.getParameters(), p -> PhpLangUtil.equalsVariableNames(argument.getName(), p.getNameCS()) && p.isPassByRef());
        }
        return false;
    }

    private static boolean isLastRefAccess(PhpCallInstruction originalInstruction, final Variable argument) {
        final Ref isLastRefAccess = new Ref((Object)true);
        PhpControlFlowUtil.processSuccessors(originalInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpAccessInstruction.Access access;
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), argument.getNameCS()) && !(access = instruction.getAccess()).isWrite() && !access.isUnset()) {
                    isLastRefAccess.set((Object)Boolean.FALSE);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return (Boolean)isLastRefAccess.get();
    }

    private static boolean isArrayInZeroStateCreation(PsiElement value) {
        Collection function;
        if (value instanceof ArrayCreationExpression) {
            return true;
        }
        return value instanceof FunctionReference && !(function = ((FunctionReference)value).multiResolveStrict(Function.class)).isEmpty() && ContainerUtil.all((Collection)function, v -> !PhpSideEffectDetector.canContainSideEffect(value));
    }

    private static PsiElement getAssignedValue(PhpAccessInstruction instruction) {
        PsiElement psiElement;
        if (instruction instanceof PhpAccessVariableInstructionImpl) {
            return ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
        }
        if ((instruction instanceof PhpAccessFieldByVariableInstructionImpl || instruction instanceof PhpAccessFieldInObjectContextInstructionImpl) && (psiElement = instruction.getAnchor().getParent()) instanceof AssignmentExpression) {
            AssignmentExpression expression = (AssignmentExpression)psiElement;
            return expression.getValue();
        }
        return null;
    }

    private static boolean isStdArrayResetFunction(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpArrayIndexResetIsUnnecessaryInspection.$$$reportNull$$$0(1);
        }
        for (String name : STD_ARRAY_INDEX_RESET_FUNCTIONS) {
            if (!PhpCodeInsightUtil.isGlobalFunctionCallWithName(reference, name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpArrayIndexResetIsUnnecessaryInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdArrayResetFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

