/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpTernaryExpressionCanBeReplacedWithConditionInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpInitialDfaBasedTypeStateAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpConditionCheckedByNextConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpConditionCheckedByNextConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpBinaryExpression(BinaryExpression expression) {
                this.doCheck(expression.getOperationType(), expression.getLeftOperand(), expression.getRightOperand());
            }

            @Override
            public void visitPhpIf(If ifStatement) {
                if (!1.isSimpleIf(ifStatement)) {
                    return;
                }
                Statement statement = ifStatement.getStatement();
                ControlStatement innerControlStatement = (ControlStatement)ObjectUtils.tryCast((Object)(statement instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement), ControlStatement.class);
                if (innerControlStatement instanceof If && 1.isSimpleIf((If)innerControlStatement) || innerControlStatement instanceof While) {
                    this.doCheck(PhpTokenTypes.opAND, (PsiElement)ifStatement.getCondition(), (PsiElement)innerControlStatement.getCondition());
                }
            }

            private static boolean isSimpleIf(If innerOnlyIf) {
                return innerOnlyIf != null && innerOnlyIf.getElseIfBranches().length == 0 && innerOnlyIf.getElseBranch() == null;
            }

            private void doCheck(IElementType type, PsiElement leftOperand, PsiElement rightOperand) {
                if (type != PhpTokenTypes.opAND && type != PhpTokenTypes.opOR || PhpSideEffectDetector.canContainSideEffect(leftOperand) || PhpSideEffectDetector.canContainSideEffect(rightOperand)) {
                    return;
                }
                PsiElement right = PhpPsiUtil.unparenthesize(rightOperand);
                if (right == null) {
                    return;
                }
                boolean isTrue = type == PhpTokenTypes.opAND;
                for (PsiElement rightPart : PhpConditionCheckedByNextConditionInspection.splitByToken(right, type)) {
                    for (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> rightState : PhpConditionCheckedByNextConditionInspection.findStates(rightPart, isTrue)) {
                        if (!this.doCheck(leftOperand, type, rightPart, isTrue, rightState)) continue;
                        return;
                    }
                }
            }

            private boolean doCheck(@Nullable PsiElement leftOperand, @Nullable IElementType operationType, PsiElement right, boolean isTrue, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> rightState) {
                if (rightState == null) {
                    return false;
                }
                for (PsiElement left : PhpConditionCheckedByNextConditionInspection.splitByToken(leftOperand, operationType)) {
                    if (!this.stateFromLeftElementWillBeCheckedInRightState(left, isTrue, rightState, false) && !this.stateFromLeftElementWillBeCheckedInRightState(left, isTrue, rightState, true)) continue;
                    PsiElement element = PhpTernaryExpressionCanBeReplacedWithConditionInspection.skipParentParenthesis(left);
                    LocalQuickFix fix = element.getParent() instanceof BinaryExpression ? LocalQuickFix.from((ModCommandAction)new PhpInstanceofIsAlwaysTrueInspection.PhpDeleteBinaryOperandQuickFix(element)) : PhpInstanceofIsAlwaysTrueInspection.getFixInternal(PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE, element);
                    MyPhpShowCauseInstructionQuickFix navigateFix = isOnTheFly ? new MyPhpShowCauseInstructionQuickFix(right, left) : null;
                    holder.problem(element, PhpBundle.message("inspection.message.will.be.covered.by", right.getText())).fix(fix).maybeFix((ModCommandAction)navigateFix).register();
                    return true;
                }
                return false;
            }

            private boolean stateFromLeftElementWillBeCheckedInRightState(PsiElement left, boolean isTrue, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> rightState, boolean negations) {
                PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> state = PhpDfaBasedAnalyzerProcessor.wrapWithInstruction(null, rightState);
                PhpPreviousDfaAnalyzerProcessor analyzer = PhpConditionAlreadyCheckedInspection.createPreviousAnalyzer(left, state, negations, TextRange.EMPTY_RANGE, true);
                if (analyzer == null) {
                    return false;
                }
                PhpPreviousDfaBaseStateConditionDFAnalyzer dfaAnalyzer = analyzer.createAnalyzer();
                dfaAnalyzer.preserveStatesInAmbiguousStates();
                PhpDfaBaseStateConditionDFAnalyzer.PhpVariableDfaState leftState = dfaAnalyzer.performDFA(left, true);
                PhpDfaBasedTypeState leftDfaState = (PhpDfaBasedTypeState)leftState.getState();
                PhpDfaBasedTypeState rightDfaState = rightState.getState();
                if (PhpConditionCheckedByNextConditionInspection.isLightAccess(leftDfaState) && !PhpConditionCheckedByNextConditionInspection.isLightAccess(rightDfaState)) {
                    return false;
                }
                return !analyzer.isUnknown(leftState) && !leftDfaState.is(rightDfaState) && StringUtil.equals((CharSequence)rightState.getVariableName(), (CharSequence)leftState.getVariableName()) && PhpConditionCheckedByNextConditionInspection.isChecked(holder.getProject(), leftDfaState, rightDfaState, isTrue);
            }
        };
    }

    private static boolean isLightAccess(PhpDfaBasedTypeState leftDfaState) {
        return leftDfaState == PhpStrictVariableDfaState.ISSET || leftDfaState == PhpCompositeTypeState.NOT_EMPTY_CHECK || leftDfaState == PhpDfaBaseStateConditionDFAnalyzer.NOT_ISSET || leftDfaState == PhpPreviousDfaBaseStateConditionDFAnalyzer.EMPTY_CHECK_STATE;
    }

    private static Collection<PsiElement> splitByToken(PsiElement element, IElementType type) {
        if ((element = PhpPsiUtil.unparenthesize(element)) == null) {
            return Collections.emptyList();
        }
        if (element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() == type) {
            ArrayList<PsiElement> res = new ArrayList<PsiElement>();
            res.addAll(PhpConditionCheckedByNextConditionInspection.splitByToken(((BinaryExpression)element).getLeftOperand(), type));
            res.addAll(PhpConditionCheckedByNextConditionInspection.splitByToken(((BinaryExpression)element).getRightOperand(), type));
            return res;
        }
        return Collections.singleton(element);
    }

    private static boolean isChecked(@NotNull Project project, PhpDfaBasedTypeState left, PhpDfaBasedTypeState right, boolean isTrue) {
        if (project == null) {
            PhpConditionCheckedByNextConditionInspection.$$$reportNull$$$0(1);
        }
        if (left == PhpDfaDelegateBasedTypeState.NOT_PRIMITIVE && right instanceof PhpDfaBaseStateConditionDFAnalyzer.PhpClassEqualToState || PhpConditionCheckedByNextConditionInspection.mayBeTypedCallGuard(left, right)) {
            return false;
        }
        return isTrue ? right.coveredBy(project, left, true) : right.excludedBy(project, left, true);
    }

    private static boolean mayBeTypedCallGuard(PhpDfaBasedTypeState left, PhpDfaBasedTypeState right) {
        return left instanceof PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker && right instanceof PhpDfaBaseStateConditionDFAnalyzer.PhpFunctionCallDfaState && PhpConditionCheckedByNextConditionInspection.hasTypedParameterWithTypeCheckerName(((PhpDfaBaseStateConditionDFAnalyzer.PhpFunctionCallDfaState)right).getCall(), ((PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker)left).getPrimitiveTypeCheckerName());
    }

    private static boolean hasTypedParameterWithTypeCheckerName(FunctionReference call, String typeCheckerName) {
        PhpTypeConditionDFAnalyzer.PhpTypeContract typeContract = PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(typeCheckerName);
        return typeContract != null && call.multiResolveStrict(Function.class).stream().flatMap(f -> Arrays.stream(f.getParameters())).anyMatch(p -> PhpType.intersects(p.getDeclaredType(), typeContract.getType()));
    }

    private static Collection<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> findStates(PsiElement operand, boolean result) {
        ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>> res = new ArrayList<PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState>>();
        for (PhpInitialDfaBasedTypeStateAnalyzer<?> processor : PhpConditionAlreadyCheckedInspection.createProcessorsToFindInitialState()) {
            PhpConditionDFAnalyzer<?> analyzer;
            PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState state;
            if (processor.isUnknown(state = (PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState)((Object)(analyzer = processor.createAnalyzer()).performDFA(operand, result)))) continue;
            res.add(state);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionCheckedByNextConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isChecked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyPhpShowCauseInstructionQuickFix
    extends PhpNavigateToElementQuickFix {
        private MyPhpShowCauseInstructionQuickFix(@NotNull PsiElement rightElement, PsiElement leftElement) {
            if (rightElement == null) {
                MyPhpShowCauseInstructionQuickFix.$$$reportNull$$$0(0);
            }
            super(rightElement, PhpBundle.message("intention.family.name.navigate.to.cause", new Object[0]), PhpBundle.message("hint.evaluation.fully.contains", leftElement.getText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightElement", "com/jetbrains/php/lang/inspections/controlFlow/PhpConditionCheckedByNextConditionInspection$MyPhpShowCauseInstructionQuickFix", "<init>"));
        }
    }
}

