/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpForeachHostInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpForeachVariableOverwritesAlreadyDefinedVariableInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpForeachVariableOverwritesAlreadyDefinedVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                Variable key = foreach.getKey();
                Variable value = foreach.getValue();
                if (key == null && value == null) {
                    return;
                }
                PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder(foreach);
                if (scopeHolder == null) {
                    return;
                }
                PhpStatementInstruction statementInstruction = PhpControlFlowUtil.getStatementInstruction(scopeHolder.getControlFlow(), foreach);
                if (statementInstruction == null) {
                    return;
                }
                PhpForeachHostInstructionImpl foreachHostInstruction = PhpForeachVariableOverwritesAlreadyDefinedVariableInspection.findForeachHostInstruction(statementInstruction);
                if (foreachHostInstruction == null) {
                    return;
                }
                this.doCheck(key, statementInstruction, foreachHostInstruction);
                this.doCheck(value, statementInstruction, foreachHostInstruction);
            }

            private void doCheck(Variable key, PhpStatementInstruction statementInstruction, PhpForeachHostInstructionImpl foreachHostInstruction) {
                if (key != null && this.readAfterForeachExists(key, statementInstruction, foreachHostInstruction) && this.definitionBeforeForeachWithNonPrimitiveType(key, statementInstruction)) {
                    holder.registerProblem((PsiElement)key, PhpBundle.message("inspection.php.foreach.variable.overwrite.already.defined.variable", new Object[0]), new LocalQuickFix[0]);
                }
            }

            private boolean readAfterForeachExists(final Variable key, final PhpStatementInstruction statementInstruction, PhpForeachHostInstructionImpl foreachHostInstruction) {
                final Ref readBeforeWriteExists = new Ref((Object)false);
                for (PhpInstruction outInstruction : foreachHostInstruction.getOutInstructions()) {
                    if (((Boolean)readBeforeWriteExists.get()).booleanValue()) break;
                    PhpControlFlowUtil.processSuccessors(outInstruction, false, new PhpInstructionProcessor(){

                        @Override
                        public boolean processInstruction(PhpInstruction instruction) {
                            if (instruction.num() < statementInstruction.num()) {
                                return false;
                            }
                            return super.processInstruction(instruction);
                        }

                        @Override
                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                            if (!super.processAccessVariableInstruction(instruction)) {
                                return false;
                            }
                            CharSequence name = instruction.getVariableName();
                            if (PhpLangUtil.equalsVariableNames(name, key.getName())) {
                                PhpAccessInstruction.Access access = instruction.getAccess();
                                if (access.isRead()) {
                                    readBeforeWriteExists.set((Object)true);
                                }
                                return false;
                            }
                            return super.processAccessVariableInstruction(instruction);
                        }
                    });
                }
                return (Boolean)readBeforeWriteExists.get();
            }

            private boolean definitionBeforeForeachWithNonPrimitiveType(final Variable key, PhpStatementInstruction statementInstruction) {
                final Ref definitionBeforeForeachExists = new Ref((Object)false);
                PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(statementInstruction, false, new PhpInstructionProcessor(){

                    @Override
                    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                        Function function = PhpPsiUtil.getParentOfClass((PsiElement)key, Function.class);
                        if (function != null && ContainerUtil.exists((Object[])function.getParameters(), p -> PhpLangUtil.equalsParameterNames(key.getName(), p.getName()))) {
                            definitionBeforeForeachExists.set((Object)true);
                        }
                        return super.processEntryPointInstruction(instruction);
                    }

                    @Override
                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        CharSequence name;
                        if ((instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef()) && PhpLangUtil.equalsVariableNames(name = instruction.getVariableName(), key.getName())) {
                            PhpType assignedType;
                            PsiElement value = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
                            if (value != null && !(assignedType = new PhpType().add(value).global(holder.getProject())).isEmpty() && !assignedType.isNotExtendablePrimitiveType()) {
                                definitionBeforeForeachExists.set((Object)true);
                            }
                            return false;
                        }
                        return true;
                    }
                });
                return (Boolean)definitionBeforeForeachExists.get();
            }
        };
    }

    @Nullable
    private static PhpForeachHostInstructionImpl findForeachHostInstruction(PhpStatementInstruction statementInstruction) {
        final Ref res = new Ref(null);
        final Statement foreachStatement = statementInstruction.getStatement();
        PhpControlFlowUtil.processSuccessors(statementInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processHostInstruction(PhpHostInstruction instruction) {
                if (instruction instanceof PhpForeachHostInstructionImpl && instruction.getAnchor() == foreachStatement) {
                    res.set((Object)((PhpForeachHostInstructionImpl)instruction));
                    return false;
                }
                return super.processHostInstruction(instruction);
            }
        });
        return (PhpForeachHostInstructionImpl)res.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpForeachVariableOverwritesAlreadyDefinedVariableInspection", "buildVisitor"));
    }
}

