/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.PhpStatementsHolder;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIfWithCommonPartsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIfWithCommonPartsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpIf(If ifStatement) {
                PsiElement parent = ifStatement.getParent();
                if (parent instanceof ControlStatement || parent instanceof Else) {
                    return;
                }
                PhpIfWithCommonPartsInspection.doCheck(new PhpIfStatementsHolder(ifStatement), holder, new PhpExtractIfCommonPartsQuickFix());
            }
        };
    }

    public static <T extends PsiElement> void doCheck(PhpStatementsHolder<T> statementsHolder, @NotNull ProblemsHolder holder, PhpExtractCommonPartsQuickFix<T> fixDelegate) {
        if (holder == null) {
            PhpIfWithCommonPartsInspection.$$$reportNull$$$0(1);
        }
        if (!statementsHolder.isValid()) {
            return;
        }
        List<PsiElement> thenStatements = statementsHolder.getFirstBranchStatements();
        int longestCommonPrefix = PhpIfWithCommonPartsInspection.getLongestCommonPurePrefix(statementsHolder);
        int longestCommonSuffix = PhpIfWithCommonPartsInspection.getLongestCommonSuffix(statementsHolder.getElseStatement(), statementsHolder);
        if (longestCommonPrefix > 0 && !PhpIfWithCommonPartsInspection.allPhpDocs(thenStatements.subList(0, longestCommonPrefix)) || longestCommonSuffix > 0 && !PhpIfWithCommonPartsInspection.allPhpDocs(thenStatements.subList(thenStatements.size() - longestCommonSuffix, thenStatements.size()))) {
            LocalQuickFix fix = PhpIfWithCommonPartsInspection.getFix(fixDelegate, longestCommonPrefix, longestCommonSuffix, thenStatements.size(), statementsHolder.getElseStatementsSize());
            holder.registerProblem(statementsHolder.myHolder.getFirstChild(), PhpBundle.message("inspection.message.if.statement.with.common.parts", fixDelegate.getHolderName()), new LocalQuickFix[]{fix});
        }
    }

    private static boolean allPhpDocs(List<PsiElement> elements) {
        return ContainerUtil.and(elements, PhpDocComment.class::isInstance);
    }

    private static LocalQuickFix getFix(PhpExtractCommonPartsQuickFix<?> fix, int prefixSize, int suffixSize, int thenSize, int elseSize) {
        if (prefixSize == thenSize && prefixSize == elseSize) {
            return fix.createCollapseInstance();
        }
        if (prefixSize == thenSize || prefixSize == elseSize || suffixSize == thenSize || suffixSize == elseSize) {
            return fix.createCommonPartsRemovingBranchInstance();
        }
        return fix.createCommonPartsInstance();
    }

    private static int getLongestCommonSuffix(@Nullable Statement elseStatement, PhpStatementsHolder<?> statements) {
        if (elseStatement == null) {
            return 0;
        }
        return PhpIfWithCommonPartsInspection.findLongestCommonPrefix(Collections.emptySet(), statements.reversed());
    }

    private static <T extends PsiElement> int getLongestCommonPurePrefix(PhpStatementsHolder<T> statements) {
        Collection variablesNames = PhpPsiUtil.findChildrenNonStrict(statements.getCondition(), Variable.class).stream().map(PhpNamedElement::getName).collect(Collectors.toCollection(() -> CollectionFactory.createCaseInsensitiveStringSet()));
        return PhpIfWithCommonPartsInspection.findLongestCommonPrefix(variablesNames, statements);
    }

    @NotNull
    public static List<PsiElement> getStatements(PsiElement statement) {
        List<PsiElement> list = PhpPsiUtil.getChildren(statement, (Condition<? super PsiElement>)((Condition)PhpPsiElement.class::isInstance));
        if (list == null) {
            PhpIfWithCommonPartsInspection.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static int findLongestCommonPrefix(Collection<String> variablesNames, PhpStatementsHolder<?> elements) {
        int res = -1;
        for (List<PsiElement> first : elements.myStatements) {
            for (List<PsiElement> other : elements.myStatements) {
                int i;
                if (first == other) continue;
                for (i = 0; i < Math.min(first.size(), other.size()) && !PhpPsiUtil.isOfType(first.get(i), PhpElementTypes.HTML) && !PhpPsiUtil.isOfType(other.get(i), PhpElementTypes.HTML) && PsiEquivalenceUtil.areEquivalent((PsiElement)first.get(i), (PsiElement)other.get(i), (o1, o2) -> true, null, null, (boolean)true) && !PhpIfWithCommonPartsInspection.possibleConditionVariableChange(first.get(i), variablesNames); ++i) {
                }
                if ((res = res < 0 ? i : Math.min(res, i)) != 0) continue;
                return 0;
            }
        }
        return res;
    }

    private static boolean possibleConditionVariableChange(PsiElement first, Collection<String> variablesNames) {
        return ContainerUtil.exists(PhpPsiUtil.findChildrenNonStrict(first, Variable.class), v -> variablesNames.contains(v.getName()) && PhpIfWithCommonPartsInspection.possibleVariableChange((PsiElement)v));
    }

    private static boolean possibleVariableChange(PsiElement v) {
        if (VariableImpl.isLocalWriteAccess(v) || PhpCodeInsightUtil.isPassByRefParameter(v, true)) {
            return true;
        }
        PsiElement parent = v.getParent();
        if ((parent instanceof FieldReference && ((FieldReference)parent).getClassReference() == v || parent instanceof ArrayAccessExpression && ((ArrayAccessExpression)parent).getValue() == v) && PhpIfWithCommonPartsInspection.possibleVariableChange(parent)) {
            return true;
        }
        FunctionReference functionCall = PhpPsiUtil.getParentOfClass(v, FunctionReference.class);
        return functionCall != null && (functionCall instanceof MethodReference && ((MethodReference)functionCall).getClassReference() == v || ArrayUtil.indexOfIdentity((Object[])functionCall.getParameters(), (Object)v) >= 0) && PhpSideEffectDetector.canContainSideEffect((PsiElement)functionCall);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static abstract class PhpExtractCommonPartsQuickFix<T extends PsiElement>
    extends PsiUpdateModCommandQuickFix {
        @IntentionFamilyName
        protected String myName;

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected abstract PhpStatementsHolder<T> createHolder(PsiElement var1);

        protected abstract String getHolderName();

        protected abstract PhpExtractCommonPartsQuickFix<T> createInstance();

        public PhpExtractCommonPartsQuickFix<T> createCollapseInstance() {
            PhpExtractCommonPartsQuickFix<T> fix = this.createInstance();
            fix.myName = PhpBundle.message("intention.family.name.collapse.if.statement", this.getHolderName());
            return fix;
        }

        public PhpExtractCommonPartsQuickFix<T> createCommonPartsRemovingBranchInstance() {
            PhpExtractCommonPartsQuickFix<T> fix = this.createInstance();
            fix.myName = PhpBundle.message("intention.family.name.extract.common.parts.with.removing.branch", new Object[0]);
            return fix;
        }

        public PhpExtractCommonPartsQuickFix<T> createCommonPartsInstance() {
            PhpExtractCommonPartsQuickFix<T> fix = this.createInstance();
            fix.myName = PhpBundle.message("intention.family.name.extract.common.parts", new Object[0]);
            return fix;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(3);
            }
            PhpStatementsHolder<T> statementsHolder = this.createHolder(element.getParent());
            Object ifStatement = statementsHolder.myHolder;
            int longestCommonPrefix = PhpIfWithCommonPartsInspection.getLongestCommonPurePrefix(statementsHolder);
            Statement elseStatement = statementsHolder.getElseStatement();
            int longestCommonSuffix = PhpIfWithCommonPartsInspection.getLongestCommonSuffix(elseStatement, statementsHolder);
            List<PsiElement> thenStatements = statementsHolder.getFirstBranchStatements();
            if (longestCommonPrefix > 0) {
                PhpExtractCommonPartsQuickFix.moveStatements(ifStatement, thenStatements.subList(0, longestCommonPrefix), true);
            }
            if (longestCommonSuffix > 0 && (longestCommonPrefix <= 0 || longestCommonPrefix != thenStatements.size())) {
                PhpExtractCommonPartsQuickFix.moveStatements(ifStatement, thenStatements.subList(thenStatements.size() - longestCommonSuffix, thenStatements.size()), false);
            }
            for (List<PsiElement> statement : statementsHolder.myStatements) {
                PhpExtractCommonPartsQuickFix.deleteStatements(statement, longestCommonPrefix, longestCommonSuffix);
            }
            this.cleanupEmptyBranches(project, ifStatement);
        }

        protected void cleanupEmptyBranches(@NotNull Project project, T holder) {
            if (project == null) {
                PhpExtractCommonPartsQuickFix.$$$reportNull$$$0(4);
            }
        }

        private static void moveStatements(PsiElement ifStatement, List<PsiElement> statements, boolean up) {
            PsiElement anchor = ifStatement;
            for (PsiElement statement : up ? ContainerUtil.reverse(statements) : statements) {
                PsiElement parent = anchor.getParent();
                if (up) {
                    anchor = parent.addBefore(statement, anchor);
                    continue;
                }
                anchor = parent.addAfter(statement, anchor);
            }
        }

        private static void deleteStatements(List<PsiElement> thenStatements, int longestCommonPrefix, int longestCommonSuffix) {
            for (int i = 0; i < thenStatements.size(); ++i) {
                if (i >= longestCommonPrefix && thenStatements.size() - i > longestCommonSuffix) continue;
                thenStatements.get(i).delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractCommonPartsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "cleanupEmptyBranches";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpIfStatementsHolder
    extends PhpStatementsHolder<If> {
        private PhpIfStatementsHolder(If statement) {
            super(statement);
        }

        private PhpIfStatementsHolder(If holder, List<List<PsiElement>> statements) {
            super(holder, statements);
        }

        @Override
        protected PhpStatementsHolder<If> reversed() {
            return new PhpIfStatementsHolder((If)this.myHolder, this.reversedStatements());
        }

        @Override
        protected List<Statement> getThenStatements(If holder) {
            ArrayList<Statement> res = new ArrayList<Statement>();
            res.add(holder.getStatement());
            for (ElseIf branch : holder.getElseIfBranches()) {
                res.add(branch.getStatement());
            }
            return res;
        }

        @Override
        @Nullable
        protected Statement getElseStatement(If holder) {
            Else branch = holder.getElseBranch();
            return branch != null ? (Statement)ObjectUtils.tryCast((Object)branch.getStatement(), Statement.class) : null;
        }

        @Override
        public PsiElement getCondition() {
            return ((If)this.myHolder).getCondition();
        }
    }

    private static class PhpExtractIfCommonPartsQuickFix
    extends PhpExtractCommonPartsQuickFix<If> {
        private PhpExtractIfCommonPartsQuickFix() {
        }

        @Override
        protected PhpStatementsHolder<If> createHolder(PsiElement holder) {
            return new PhpIfStatementsHolder((If)holder);
        }

        @Override
        protected String getHolderName() {
            return "if";
        }

        @Override
        protected PhpExtractCommonPartsQuickFix<If> createInstance() {
            return new PhpExtractIfCommonPartsQuickFix();
        }

        @Override
        protected void cleanupEmptyBranches(@NotNull Project project, If holder) {
            boolean emptyElse;
            if (project == null) {
                PhpExtractIfCommonPartsQuickFix.$$$reportNull$$$0(0);
            }
            Else elseBranch = holder.getElseBranch();
            boolean emptyThen = PhpIfWithCommonPartsInspection.getStatements((PsiElement)holder.getStatement()).isEmpty();
            Object[] elseIfBranches = holder.getElseIfBranches();
            boolean emptyElseIfBranches = ContainerUtil.and((Object[])elseIfBranches, elseIf -> PhpIfWithCommonPartsInspection.getStatements((PsiElement)elseIf.getStatement()).isEmpty());
            boolean bl = emptyElse = elseBranch != null && PhpIfWithCommonPartsInspection.getStatements((PsiElement)elseBranch.getStatement()).isEmpty();
            if (emptyThen && emptyElseIfBranches && (emptyElse || elseBranch == null)) {
                holder.delete();
            } else if (emptyElse) {
                elseBranch.delete();
                for (int i = elseIfBranches.length - 1; i >= 0 && PhpIfWithCommonPartsInspection.getStatements((PsiElement)elseIfBranches[i].getStatement()).isEmpty(); --i) {
                    elseIfBranches[i].delete();
                }
            } else if (emptyThen && elseIfBranches.length == 0) {
                PhpInvertIfIntention.flipIfElse(project, holder);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/controlFlow/PhpIfWithCommonPartsInspection$PhpExtractIfCommonPartsQuickFix", "cleanupEmptyBranches"));
        }
    }
}

