/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableHandler;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpPrivateFieldCanBeLocalVariableInspection
extends PhpDeprecationInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClass(PhpClass clazz) {
                Collection<Field> candidateFields = PhpPrivateFieldCanBeLocalVariableInspection.getCandidateFields(clazz);
                HashMap<Field, Method> fieldsWithMethodUsage = new HashMap<Field, Method>();
                for (Field field2 : candidateFields) {
                    fieldsWithMethodUsage.put(field2, null);
                }
                Map<Field, Collection<PhpAccessFieldByVariableInstruction>> candidateFieldsReadInstructions = PhpPrivateFieldCanBeLocalVariableInspection.collectFieldReadInstructionsInsideOnlyOneMethod(clazz, candidateFields, fieldsWithMethodUsage);
                candidateFieldsReadInstructions.entrySet().stream().filter(e -> PhpPrivateFieldCanBeLocalVariableInspection.allInstructionHasPreviousWriteAccessInSameControlStatement((Collection)e.getValue())).map(Map.Entry::getKey).forEach(field -> holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)field.getNameIdentifier(), (Object)field), PhpBundle.message("inspection.php.private.field.can.be.local.variable.description", new Object[0]), new LocalQuickFix[]{new PhpReplaceWithLocalVariableQuickFix((Field)field, (Method)fieldsWithMethodUsage.get(field))}));
            }
        };
    }

    @NotNull
    private static Map<Field, Collection<PhpAccessFieldByVariableInstruction>> collectFieldReadInstructionsInsideOnlyOneMethod(final PhpClass clazz, final Collection<Field> candidateFields, final Map<Field, Method> fieldNamesWithMethod) {
        final HashMap<Field, Collection<PhpAccessFieldByVariableInstruction>> fieldReadInstructions = new HashMap<Field, Collection<PhpAccessFieldByVariableInstruction>>();
        for (final Method currentMethod : clazz.getOwnMethods()) {
            if (candidateFields.isEmpty()) {
                HashMap<Field, Collection<PhpAccessFieldByVariableInstruction>> hashMap = fieldReadInstructions;
                if (hashMap == null) {
                    PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(1);
                }
                return hashMap;
            }
            if (currentMethod.getMethodType(false) == Method.MethodType.CONSTRUCTOR) continue;
            PhpControlFlowUtil.processFlow(currentMethod.getControlFlow(), new PhpInstructionProcessor(){

                @Override
                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    FieldReference fieldReference = instruction.getFieldReference();
                    if (fieldReference == null) {
                        return true;
                    }
                    PhpReference classReference = (PhpReference)ObjectUtils.tryCast((Object)fieldReference.getClassReference(), PhpReference.class);
                    if (classReference == null) {
                        return true;
                    }
                    for (ResolveResult result : fieldReference.multiResolve(false)) {
                        Field field = (Field)ObjectUtils.tryCast((Object)result.getElement(), Field.class);
                        if (field == null || !candidateFields.contains(field)) continue;
                        Method previousMethod = fieldNamesWithMethod.put(field, currentMethod);
                        if (classReference.resolve() != clazz || previousMethod != null && previousMethod != currentMethod) {
                            candidateFields.remove(field);
                            fieldReadInstructions.remove(field);
                            continue;
                        }
                        if (!PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction(instruction)) continue;
                        fieldReadInstructions.computeIfAbsent(field, e -> new HashSet()).add(instruction);
                    }
                    return !candidateFields.isEmpty();
                }

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PhpPsiElement anchor;
                    Function function;
                    if (PhpLangUtil.isThisReference(instruction.getVariableName()) && (function = (Function)ObjectUtils.tryCast((Object)PhpPsiUtil.getScopeHolder((PsiElement)(anchor = instruction.getAnchor())), Function.class)) != null && function.isClosure()) {
                        this.removeFieldReferencesUsedInClosureFromCandidates(function);
                    }
                    return true;
                }

                private void removeFieldReferencesUsedInClosureFromCandidates(Function closure) {
                    Set removedFieldReferencesNames = CollectionFactory.createCaseInsensitiveStringSet();
                    PsiTreeUtil.processElements((PsiElement)closure, element -> {
                        if (element instanceof FieldReference && PhpLangUtil.isThisReference((PsiElement)((FieldReference)element).getClassReference()) && removedFieldReferencesNames.add(((FieldReference)element).getName())) {
                            StreamEx.of((Object[])((FieldReference)element).multiResolve(false)).map(ResolveResult::getElement).select(Field.class).forEach(f -> {
                                candidateFields.remove(f);
                                fieldReadInstructions.remove(f);
                            });
                        }
                        return !candidateFields.isEmpty();
                    });
                }
            });
        }
        HashMap<Field, Collection<PhpAccessFieldByVariableInstruction>> hashMap = fieldReadInstructions;
        if (hashMap == null) {
            PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    private static boolean allInstructionHasPreviousWriteAccessInSameControlStatement(Collection<PhpAccessFieldByVariableInstruction> instructions) {
        return !ContainerUtil.exists(instructions, instruction -> PhpPrivateFieldCanBeLocalVariableInspection.findPreviousAlwaysAccessibleWriteInstruction(instruction, instruction::isSameFieldReference).isNull());
    }

    @NotNull
    public static Ref<PhpAccessFieldByVariableInstruction> findPreviousAlwaysAccessibleWriteInstruction(PhpInstruction startInstruction, final Predicate<PhpAccessFieldByVariableInstruction> shouldProcess) {
        final Ref writeInstruction = new Ref();
        final Ref writeAccessCanBeUnreachable = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(startInstruction, false, new PhpInstructionProcessor(){

            @Override
            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction writeFieldReference) {
                if (!PhpPrivateFieldCanBeLocalVariableInspection.isReadInstruction(writeFieldReference) && !writeFieldReference.getAccess().isReadRef() && shouldProcess.test(writeFieldReference)) {
                    writeInstruction.set((Object)writeFieldReference);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                writeAccessCanBeUnreachable.set((Object)Boolean.TRUE);
                return true;
            }
        });
        if (((Boolean)writeAccessCanBeUnreachable.get()).booleanValue()) {
            writeInstruction.set(null);
        }
        Ref ref = writeInstruction;
        if (ref == null) {
            PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(3);
        }
        return ref;
    }

    @NotNull
    private static Collection<Field> getCandidateFields(PhpClass clazz) {
        Collection candidateFields = Arrays.stream(clazz.getOwnFields()).filter(field -> field.getModifier().isPrivate() && !field.getModifier().isStatic()).collect(Collectors.toCollection(HashSet::new));
        PhpPrivateFieldCanBeLocalVariableInspection.removeFieldsUsedInConstructor(clazz, candidateFields);
        Collection collection = candidateFields;
        if (collection == null) {
            PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(4);
        }
        return collection;
    }

    static boolean isReadInstruction(@NotNull PhpAccessInstruction instruction) {
        PhpAccessInstruction.Access access;
        if (instruction == null) {
            PhpPrivateFieldCanBeLocalVariableInspection.$$$reportNull$$$0(5);
        }
        return (access = instruction.getAccess()).isRead() || access.isLightRead();
    }

    private static void removeFieldsUsedInConstructor(final PhpClass clazz, final Collection<Field> fields) {
        Method constructor = clazz.getOwnConstructor();
        if (constructor == null) {
            return;
        }
        PhpControlFlowUtil.processFlow(constructor.getControlFlow(), new PhpInstructionProcessor(){

            @Override
            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference fieldReference = instruction.getFieldReference();
                if (fieldReference == null) {
                    return true;
                }
                PhpReference classReference = (PhpReference)ObjectUtils.tryCast((Object)fieldReference.getClassReference(), PhpReference.class);
                Field resolvedField = (Field)ObjectUtils.tryCast((Object)fieldReference.resolve(), Field.class);
                if (resolvedField != null && (classReference == null || classReference.resolve() == clazz && fields.contains(resolvedField))) {
                    fields.remove(resolvedField);
                }
                return !fields.isEmpty();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpPrivateFieldCanBeLocalVariableInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpPrivateFieldCanBeLocalVariableInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFieldReadInstructionsInsideOnlyOneMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreviousAlwaysAccessibleWriteInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReadInstruction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyNameSuggestionProvider
    extends PhpIntroduceVariableNameSuggestionProvider {
        private final String myFieldName;

        private MyNameSuggestionProvider(String fieldName, PhpIntroduceContext introduceContext) {
            super(introduceContext, PhpIntroduceVariableHandler.getOccupiedElements(introduceContext));
            this.myFieldName = fieldName;
        }

        @Override
        protected void suggest() {
            this.myManager.add(this.myFieldName, 1);
        }
    }

    private static final class PhpReplaceWithLocalVariableQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpReplaceWithLocalVariableQuickFix(Field field, Method method) {
            super((PsiElement)field, (PsiElement)method);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement field, @NotNull PsiElement method) {
            FieldReference firstTargetReference;
            if (project == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(2);
            }
            if (field == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (method == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(4);
            }
            if ((firstTargetReference = (FieldReference)ContainerUtil.find((Iterable)PsiTreeUtil.findChildrenOfAnyType((PsiElement)method, (Class[])new Class[]{FieldReference.class}), r -> r.resolve() == field)) == null) {
                return;
            }
            PhpIntroduceVariableHandler handler = new PhpIntroduceVariableHandler();
            try {
                PhpIntroduceContext context = handler.getIntroduceContext(null, (PsiElement)firstTargetReference);
                PhpIntroduceVariableSettings settings = PhpReplaceWithLocalVariableQuickFix.getIntroduceVariableSettings(firstTargetReference, context);
                PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(context, settings);
                PsiElement anchor = PhpIntroduceVariableHandler.replaceAnchor(context, expressionForOriginalElement, PhpIntroduceVariableHandler.findAnchor(context, settings.getReplaceChoice()));
                PsiElement defaultValue = ((Field)field).getDefaultValue();
                if (anchor != null && !VariableImpl.isLocalWriteAccess((PsiElement)firstTargetReference) && defaultValue != null) {
                    PhpCodeEditUtil.putStatementBefore(anchor, PhpIntroduceVariableHandler.getVariableDeclaration(context, settings, defaultValue.getText()));
                }
                PhpIntroduceVariableHandler.replaceOccurrences(context, settings, expressionForOriginalElement);
            }
            catch (PhpIntroduceBaseHandler.RefactoringErrorException refactoringErrorException) {
                // empty catch block
            }
            PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)field);
        }

        @NotNull
        private static PhpIntroduceVariableSettings getIntroduceVariableSettings(final FieldReference firstTargetReference, final PhpIntroduceContext context) {
            return new PhpIntroduceVariableSettings(){

                @Override
                public OccurrencesChooser.BaseReplaceChoice getReplaceChoice() {
                    return OccurrencesChooser.ReplaceChoice.ALL;
                }

                @Override
                public boolean isEmbedVariable() {
                    return false;
                }

                @Override
                public String getName() {
                    return (String)ArrayUtil.getFirstElement((Object[])new MyNameSuggestionProvider(firstTargetReference.getName(), context).getSuggestedNames());
                }
            };
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with.local.variable.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpReplaceWithLocalVariableQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpPrivateFieldCanBeLocalVariableInspection$PhpReplaceWithLocalVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpPrivateFieldCanBeLocalVariableInspection$PhpReplaceWithLocalVariableQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

