/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpIfWithCommonPartsInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpStatementsHolder;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpSwitchWithCommonPartsInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpSwitchWithCommonPartsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpCase[] allCases;
                for (PhpCase aCase : allCases = switchStatement.getCases()) {
                    Statement statement = aCase.getStatement();
                    if (statement == null) {
                        return;
                    }
                    PsiElement lastStatement = (PsiElement)ArrayUtil.getLastElement((Object[])statement.getChildren());
                    if (PhpSwitchWithCommonPartsInspection.isStopStatement(lastStatement)) continue;
                    return;
                }
                PhpIfWithCommonPartsInspection.doCheck(new PhpSwitchStatementsHolder(switchStatement), holder, new PhpExtractSwitchCommonPartsQuickFix());
            }
        };
    }

    private static boolean isStopStatement(PsiElement lastStatement) {
        return lastStatement instanceof PhpBreak || lastStatement instanceof PhpReturn;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpSwitchWithCommonPartsInspection", "buildVisitor"));
    }

    private static class PhpExtractSwitchCommonPartsQuickFix
    extends PhpIfWithCommonPartsInspection.PhpExtractCommonPartsQuickFix<PhpSwitch> {
        private PhpExtractSwitchCommonPartsQuickFix() {
        }

        @Override
        protected PhpStatementsHolder<PhpSwitch> createHolder(PsiElement holder) {
            return new PhpSwitchStatementsHolder((PhpSwitch)holder);
        }

        @Override
        protected String getHolderName() {
            return "switch";
        }

        @Override
        protected PhpIfWithCommonPartsInspection.PhpExtractCommonPartsQuickFix<PhpSwitch> createInstance() {
            return new PhpExtractSwitchCommonPartsQuickFix();
        }

        @Override
        protected void cleanupEmptyBranches(@NotNull Project project, PhpSwitch phpSwitch) {
            if (project == null) {
                PhpExtractSwitchCommonPartsQuickFix.$$$reportNull$$$0(0);
            }
            PhpSwitchStatementsHolder holder = new PhpSwitchStatementsHolder(phpSwitch);
            PhpCase[] cases = phpSwitch.getAllCases();
            for (int i = cases.length - 1; i >= 0; --i) {
                List<PsiElement> statements = PhpIfWithCommonPartsInspection.getStatements((PsiElement)cases[i].getStatement());
                if (!statements.isEmpty() && !(ContainerUtil.getOnlyItem(statements) instanceof PhpBreak)) {
                    return;
                }
                cases[i].delete();
            }
            phpSwitch.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/lang/inspections/controlFlow/PhpSwitchWithCommonPartsInspection$PhpExtractSwitchCommonPartsQuickFix", "cleanupEmptyBranches"));
        }
    }

    private static class PhpSwitchStatementsHolder
    extends PhpStatementsHolder<PhpSwitch> {
        PhpSwitchStatementsHolder(PhpSwitch holder) {
            super(holder);
        }

        PhpSwitchStatementsHolder(PhpSwitch holder, List<List<PsiElement>> statements) {
            super(holder, statements);
        }

        @Override
        protected PhpStatementsHolder<PhpSwitch> reversed() {
            return new PhpSwitchStatementsHolder((PhpSwitch)this.myHolder, this.reversedStatements());
        }

        @Override
        protected List<Statement> getThenStatements(PhpSwitch holder) {
            return ContainerUtil.map((Object[])holder.getCases(), ControlStatement::getStatement);
        }

        @Override
        @Nullable
        protected Statement getElseStatement(PhpSwitch holder) {
            PhpCase defaultCase = holder.getDefaultCase();
            return defaultCase != null ? defaultCase.getStatement() : null;
        }

        @Override
        @NotNull
        protected List<PsiElement> getStatements(Statement statement) {
            List<PsiElement> statements = super.getStatements(statement);
            if (PhpSwitchWithCommonPartsInspection.isStopStatement((PsiElement)ContainerUtil.getLastItem(statements))) {
                List<PsiElement> list = statements.subList(0, statements.size() - 1);
                if (list == null) {
                    PhpSwitchStatementsHolder.$$$reportNull$$$0(0);
                }
                return list;
            }
            List<PsiElement> list = statements;
            if (list == null) {
                PhpSwitchStatementsHolder.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        public PsiElement getCondition() {
            return ((PhpSwitch)this.myHolder).getArgument();
        }

        @Override
        protected boolean lastStatementIsExit(List<PsiElement> statements) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpSwitchWithCommonPartsInspection$PhpSwitchStatementsHolder", "getStatements"));
        }
    }
}

