/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpLoop;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnnecessaryStopStatementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnnecessaryStopStatementInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpReturn(PhpReturn returnStatement) {
                if (returnStatement.getArgument() != null) {
                    return;
                }
                Function parentFunction = PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
                this.doCheck((PsiElement)returnStatement, parentFunction);
            }

            @Override
            public void visitPhpContinue(PhpContinue continueStatement) {
                if (continueStatement.getArgument() != null) {
                    return;
                }
                PhpLoop loop = PhpPsiUtil.getParentOfClass((PsiElement)continueStatement, PhpLoop.class);
                if (loop != null && !PhpUnnecessaryStopStatementInspection.isAlternativeSyntax(loop) && !PhpUnnecessaryStopStatementInspection.isSingleContinueInConditionWithFollowingBranches(continueStatement)) {
                    this.doCheck((PsiElement)continueStatement, loop);
                }
            }

            private void doCheck(PsiElement stopStatement, PsiElement parentBlock) {
                if (PhpUnnecessaryStopStatementInspection.isUnnecessaryStopStatement(stopStatement, parentBlock) && !PhpUnnecessaryStopStatementInspection.isSingleStatementInsideControlStatementWithFollowingDependencies(stopStatement)) {
                    holder.problem(stopStatement, 1.getMessage(stopStatement, parentBlock)).highlight(ProblemHighlightType.LIKE_UNUSED_SYMBOL).fix((ModCommandAction)new PhpDeleteElementQuickFix(stopStatement)).register();
                }
            }

            @NotNull
            @Nls
            private static String getMessage(PsiElement stopStatement, PsiElement parentBlock) {
                if (stopStatement instanceof PhpContinue) {
                    String string = PhpBundle.message("inspection.php.unnecessary.continue", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = parentBlock instanceof Method ? PhpBundle.message("inspection.php.unnecessary.return.method", new Object[0]) : PhpBundle.message("inspection.php.unnecessary.return.function", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryStopStatementInspection$1", "getMessage"));
            }
        };
    }

    private static boolean isSingleStatementInsideControlStatementWithFollowingDependencies(PsiElement stopStatement) {
        PsiElement parent = stopStatement.getParent();
        if (parent instanceof ControlStatement && ((ControlStatement)parent).getStatement() == stopStatement || parent instanceof Else && ((Else)parent).getStatement() == stopStatement) {
            return true;
        }
        if (parent instanceof GroupStatement) {
            parent = parent.getParent();
        }
        return (parent instanceof If && (((If)parent).getElseIfBranches().length > 0 || ((If)parent).getElseBranch() != null) || parent instanceof ElseIf && PhpUnnecessaryStopStatementInspection.isElseIfOrElse(PhpPsiUtil.getNextSiblingIgnoreWhitespace(parent, true))) && PhpInvertIfIntention.getOnlyStatement((PsiElement)((ControlStatement)parent).getStatement()) == stopStatement;
    }

    private static boolean isElseIfOrElse(PsiElement element) {
        return element instanceof ElseIf || element instanceof Else;
    }

    public static boolean isUnnecessaryStopStatement(PsiElement stopStatement, PsiElement parentBlock) {
        return PhpUnnecessaryStopStatementInspection.isEffectivelyLastStatement(stopStatement, parentBlock) || PhpUnnecessaryStopStatementInspection.insideDefaultCaseInLastSwitch(stopStatement, parentBlock);
    }

    public static boolean isEffectivelyLastStatement(PsiElement stopStatement, PsiElement parentBlock) {
        return PhpUnnecessaryStopStatementInspection.isLastStatement(stopStatement, parentBlock) || PhpUnnecessaryStopStatementInspection.insideLastStatementIf(stopStatement, parentBlock);
    }

    private static boolean isAlternativeSyntax(PsiElement loop) {
        return PhpPsiUtil.getChildOfType(loop, PhpTokenTypes.opCOLON) != null;
    }

    private static boolean isSingleContinueInConditionWithFollowingBranches(PhpContinue continueStatement) {
        ControlStatement controlStatement = (ControlStatement)PhpPsiUtil.getParentByCondition((PsiElement)continueStatement, (Condition<? super PsiElement>)((Condition)a -> a instanceof If || a instanceof ElseIf));
        if (controlStatement != null) {
            Statement onlyStatement;
            Statement statement = controlStatement.getStatement();
            Statement statement2 = onlyStatement = statement instanceof GroupStatement ? ((GroupStatement)statement).getOnlyStatement() : statement;
            if (onlyStatement == continueStatement && PhpUnnecessaryStopStatementInspection.followingBranchExists(controlStatement)) {
                return true;
            }
        }
        return false;
    }

    private static boolean followingBranchExists(ControlStatement statement) {
        if (statement instanceof If) {
            return ((If)statement).getElseIfBranches().length > 0 || ((If)statement).getElseBranch() != null;
        }
        if (statement instanceof ElseIf) {
            PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)statement, true);
            return nextSibling instanceof ElseIf || nextSibling instanceof Else;
        }
        return false;
    }

    private static boolean insideLastStatementIf(PsiElement statement, PsiElement parentBlock) {
        If anIf = PhpUnnecessaryStopStatementInspection.getParentIfStatement(statement.getParent());
        if (anIf == null) {
            return false;
        }
        if (PhpUnnecessaryStopStatementInspection.isLastStatement((PsiElement)anIf, parentBlock)) {
            return true;
        }
        PsiElement sibling = PhpPsiUtil.getNextSibling((PsiElement)anIf, e -> PhpUnnecessaryStopStatementInspection.isElementToSkip(e));
        boolean isLastStatement = !(sibling instanceof PhpPsiElement) && !PhpPsiUtil.isOfType(sibling, PhpElementTypes.HTML);
        return isLastStatement && PhpUnnecessaryStopStatementInspection.insideLastStatementIf((PsiElement)anIf, parentBlock);
    }

    private static boolean isElementToSkip(PsiElement e) {
        return e instanceof PsiWhiteSpace || e instanceof PsiComment || PhpPsiUtil.isOfType(e, PhpTokenTypes.PHP_OPENING_TAG, PhpTokenTypes.PHP_ECHO_OPENING_TAG, PhpTokenTypes.PHP_CLOSING_TAG);
    }

    private static boolean insideDefaultCaseInLastSwitch(PsiElement statement, PsiElement parentFunction) {
        PhpCase phpCase;
        PsiElement parent = statement.getParent();
        if (parent instanceof GroupStatement && PhpPsiUtil.isOfType((PsiElement)(phpCase = (PhpCase)ObjectUtils.tryCast((Object)parent.getParent(), PhpCase.class)), PhpElementTypes.CASE_DEFAULT)) {
            return PhpUnnecessaryStopStatementInspection.isLastStatement(phpCase.getParent(), parentFunction);
        }
        return false;
    }

    private static If getParentIfStatement(PsiElement parent) {
        if (parent instanceof GroupStatement) {
            return PhpUnnecessaryStopStatementInspection.getParentIfStatement(parent.getParent());
        }
        if (parent instanceof Else || parent instanceof ElseIf) {
            return (If)ObjectUtils.tryCast((Object)parent.getParent(), If.class);
        }
        if (parent instanceof If) {
            return (If)parent;
        }
        return null;
    }

    private static boolean ifWithElseBranch(@Nullable If anIf) {
        PhpPsiElement elseStatement;
        Else elseBranch = anIf != null ? anIf.getElseBranch() : null;
        PhpPsiElement phpPsiElement = elseStatement = elseBranch != null ? elseBranch.getStatement() : null;
        return elseStatement instanceof If ? PhpUnnecessaryStopStatementInspection.ifWithElseBranch((If)elseStatement) : elseStatement != null;
    }

    private static boolean isLastStatement(PsiElement statement, PsiElement parentFunction) {
        PsiElement lastStatement = PhpUnnecessaryStopStatementInspection.getLastStatement(parentFunction);
        return lastStatement != null && statement == lastStatement;
    }

    private static PsiElement getLastStatement(PsiElement function) {
        Statement statement;
        Statement statement2 = statement = function instanceof ControlStatement ? ((ControlStatement)function).getStatement() : (Statement)PhpPsiUtil.getChildByCondition(function, Statement.INSTANCEOF);
        if (statement instanceof GroupStatement) {
            return (PsiElement)ContainerUtil.findLast(Arrays.asList(((GroupStatement)statement).getStatements()), e -> !PhpUnnecessaryStopStatementInspection.isElementToSkip(e));
        }
        return statement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpUnnecessaryStopStatementInspection", "buildVisitor"));
    }
}

