/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpForeachHostInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpWriteAccessToReferencedArrayValueWithoutUnsetInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpWriteAccessToReferencedArrayValueWithoutUnsetInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                Variable value = foreach.getValue();
                if (value != null && PhpCodeInsightUtil.getAccess(value).isWriteRef()) {
                    PhpScopeHolder scopeHolder = (PhpScopeHolder)PhpPsiUtil.getParentByCondition(foreach, PhpScopeHolder.INSTANCE_OF);
                    if (scopeHolder == null) {
                        return;
                    }
                    PhpForeachHostInstructionImpl instruction = (PhpForeachHostInstructionImpl)ObjectUtils.tryCast((Object)ContainerUtil.find((Object[])scopeHolder.getControlFlow().getInstructions(), i -> i instanceof PhpForeachHostInstructionImpl && i.getAnchor() == foreach), PhpForeachHostInstructionImpl.class);
                    if (instruction == null) {
                        return;
                    }
                    Ref unsetAccessExists = new Ref((Object)false);
                    HashSet<PsiElement> writeAccessAnchors = new HashSet<PsiElement>();
                    for (PhpInstruction outInstruction : instruction.getOutInstructions()) {
                        this.checkFollowingWriteAccess(value, (Ref<Boolean>)unsetAccessExists, writeAccessAnchors, outInstruction);
                    }
                    if (!((Boolean)unsetAccessExists.get()).booleanValue()) {
                        for (PsiElement writeAccessAnchor : writeAccessAnchors) {
                            holder.registerProblem(writeAccessAnchor, PhpBundle.message("inspection.message.write.access.to.variable.that.still.references.array.value", new Object[0]), new LocalQuickFix[]{new PhpInsertUnsetBeforeWriteQuickFix(value.getName())});
                        }
                    }
                }
            }

            public void checkFollowingWriteAccess(final Variable value, final Ref<Boolean> resetVariableAccessExists, final Collection<PsiElement> writeAccessAnchors, final PhpInstruction outInstruction) {
                PhpControlFlowUtil.processSuccessors(outInstruction, true, new PhpInstructionProcessor(){

                    @Override
                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (instruction.num() <= outInstruction.num()) {
                            return false;
                        }
                        if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), value.getName())) {
                            PhpAccessInstruction.Access access = instruction.getAccess();
                            if (access.isUnset()) {
                                resetVariableAccessExists.set((Object)true);
                                return false;
                            }
                            if (access.isWrite() || access.isReadRef() || access.isWriteRef()) {
                                this.processPreviousVariablesAccessesForUnset(instruction, value.getName());
                                writeAccessAnchors.add(instruction.getAnchor());
                                return false;
                            }
                        }
                        return super.processAccessVariableInstruction(instruction);
                    }

                    public void processPreviousVariablesAccessesForUnset(PhpInstruction instruction, final @Nullable CharSequence variableName) {
                        PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(instruction, false, new PhpInstructionProcessor(){

                            @Override
                            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                                if (instruction == outInstruction) {
                                    return false;
                                }
                                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && instruction.getAccess().isUnset()) {
                                    resetVariableAccessExists.set((Object)true);
                                    return false;
                                }
                                return super.processAccessVariableInstruction(instruction);
                            }
                        });
                    }

                    @Override
                    public boolean processHostInstruction(PhpHostInstruction instruction) {
                        if (instruction instanceof PhpForeachHostInstructionImpl) {
                            Variable v;
                            ForeachStatement anchor = (ForeachStatement)instruction.getAnchor();
                            Variable variable = v = anchor != null ? anchor.getValue() : null;
                            if (v != null && PhpLangUtil.equalsVariableNames(v.getName(), value.getName())) {
                                if (!PhpCodeInsightUtil.getAccess(v).isWriteRef()) {
                                    this.processPreviousVariablesAccessesForUnset(instruction, value.getName());
                                    writeAccessAnchors.add(v);
                                } else {
                                    resetVariableAccessExists.set((Object)true);
                                }
                                return false;
                            }
                        }
                        return super.processHostInstruction(instruction);
                    }
                });
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/controlFlow/PhpWriteAccessToReferencedArrayValueWithoutUnsetInspection", "buildVisitor"));
    }

    private static class PhpInsertUnsetBeforeWriteQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myVariableName;

        private PhpInsertUnsetBeforeWriteQuickFix(@NotNull @NlsSafe String variableName) {
            if (variableName == null) {
                PhpInsertUnsetBeforeWriteQuickFix.$$$reportNull$$$0(0);
            }
            this.myVariableName = variableName;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.insert.unset.before", this.myVariableName);
            if (string == null) {
                PhpInsertUnsetBeforeWriteQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Statement statement;
            if (project == null) {
                PhpInsertUnsetBeforeWriteQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpInsertUnsetBeforeWriteQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpInsertUnsetBeforeWriteQuickFix.$$$reportNull$$$0(4);
            }
            if ((statement = PhpPsiUtil.getParentOfClass(element, false, Statement.class)) == null) {
                return;
            }
            statement.getParent().addBefore((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpUnset.class, "unset($" + this.myVariableName + ");"), (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/PhpWriteAccessToReferencedArrayValueWithoutUnsetInspection$PhpInsertUnsetBeforeWriteQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/PhpWriteAccessToReferencedArrayValueWithoutUnsetInspection$PhpInsertUnsetBeforeWriteQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

