/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpIntCapableComparisonState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateWithArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpVariableCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpDfaBasedArrayAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpPreviousArrayDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.field.PhpDfaBasedFieldAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessConditionDfaAnalyzer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRangeCheckDfaBasedTypeState
extends PhpDfaBasedTypeState {
    protected final Operand myOperand;

    public PhpRangeCheckDfaBasedTypeState(Operand operand, String value) {
        super("COMPARISON " + operand.name() + " with " + value);
        this.myOperand = operand;
    }

    public abstract boolean isComparable(PhpRangeCheckDfaBasedTypeState var1);

    public abstract int compare(PhpRangeCheckDfaBasedTypeState var1);

    public Operand getOperand() {
        return this.myOperand;
    }

    @Nullable
    public static PhpRangeCheckDfaBasedTypeState tryToCreate(@Nullable PsiElement right, IElementType operandType, boolean result, boolean global) {
        if (right == null) {
            return null;
        }
        Operand operand = PhpRangeCheckDfaBasedTypeState.normalizeOperand(operandType, result);
        if (operand == null) {
            return null;
        }
        PhpStateArgumentInfo encodedName = PhpStateArgumentInfo.tryCreateInfo(right, global);
        if (encodedName != null) {
            return new PhpVariableRangeCheckDfaBasedTypeState(operand, encodedName);
        }
        if (PhpPsiUtil.isOfType(right, PhpElementTypes.NUMBER)) {
            try {
                int value = Integer.parseInt(right.getText());
                return new PhpIntRangeCheckDfaBasedTypeState(operand, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Operand normalizeOperand(IElementType operandType, boolean result) {
        IElementType normalizedOperand = !result ? PhpArrayEmptinessConditionDfaAnalyzer.invert(operandType) : operandType;
        return (Operand)((Object)ContainerUtil.find((Object[])Operand.values(), o -> o.myTokenType == normalizedOperand));
    }

    @Override
    public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
        PhpRangeCheckDfaBasedTypeState followingState;
        if (state == null) {
            PhpRangeCheckDfaBasedTypeState.$$$reportNull$$$0(0);
        }
        if ((followingState = (PhpRangeCheckDfaBasedTypeState)ObjectUtils.tryCast((Object)state, PhpRangeCheckDfaBasedTypeState.class)) instanceof PhpVariableCheckDfaBasedTypeState.PhpModuloOnVariableState) {
            return false;
        }
        if (followingState != null && this.isComparable(followingState) && !(followingState instanceof PhpVariableCheckDfaBasedTypeState.PhpAdditionOnVariableState)) {
            Operand operand = ((PhpRangeCheckDfaBasedTypeState)state).myOperand;
            if (this.myOperand == Operand.GREATER && (operand == Operand.GREATER_EQ || operand == Operand.GREATER) && this.compare(followingState) >= 0) {
                return true;
            }
            if (this.myOperand == Operand.GREATER_EQ && (operand == Operand.GREATER || operand == Operand.GREATER_EQ) && this.compare(followingState) > 0) {
                return true;
            }
            if (this.myOperand == Operand.LOWER && (operand == Operand.LOWER_EQ || operand == Operand.LOWER) && this.compare(followingState) <= 0) {
                return true;
            }
            if (this.myOperand == Operand.LOWER_EQ && (operand == Operand.LOWER || operand == Operand.LOWER_EQ) && this.compare(followingState) < 0) {
                return true;
            }
        }
        return super.coveredBy(project, state, global, skippedStates);
    }

    @Override
    public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
        PhpRangeCheckDfaBasedTypeState followingState;
        if (state == null) {
            PhpRangeCheckDfaBasedTypeState.$$$reportNull$$$0(1);
        }
        if (!((followingState = (PhpRangeCheckDfaBasedTypeState)ObjectUtils.tryCast((Object)state, PhpRangeCheckDfaBasedTypeState.class)) == null || !this.isComparable(followingState) || followingState instanceof PhpVariableCheckDfaBasedTypeState.PhpAdditionOnVariableState && ((PhpVariableCheckDfaBasedTypeState.PhpAdditionOnVariableState)followingState).myNegatedCheck)) {
            Operand operand = ((PhpRangeCheckDfaBasedTypeState)state).myOperand;
            if (this.myOperand == Operand.GREATER && (operand == Operand.LOWER || operand == Operand.LOWER_EQ) && this.compare(followingState) >= 0) {
                return true;
            }
            if (this.myOperand == Operand.GREATER_EQ) {
                if (operand == Operand.LOWER && this.compare(followingState) >= 0) {
                    return true;
                }
                if (operand == Operand.LOWER_EQ && this.compare(followingState) > 0) {
                    return true;
                }
            }
            if (this.myOperand == Operand.LOWER && (operand == Operand.GREATER || operand == Operand.GREATER_EQ) && this.compare(followingState) <= 0) {
                return true;
            }
            if (this.myOperand == Operand.LOWER_EQ) {
                if (operand == Operand.GREATER && this.compare(followingState) <= 0) {
                    return true;
                }
                if (operand == Operand.GREATER_EQ && this.compare(followingState) < 0) {
                    return true;
                }
            }
        }
        return super.excludedBy(project, state, global, skippedStates);
    }

    @Override
    public boolean is(PhpDfaBasedTypeState state) {
        return !(state instanceof PhpVariableCheckDfaBasedTypeState.PhpAdditionOnVariableState) && this.isSameRange(state);
    }

    protected boolean isSameRange(PhpDfaBasedTypeState state) {
        return state instanceof PhpRangeCheckDfaBasedTypeState && ((PhpRangeCheckDfaBasedTypeState)state).myOperand == this.myOperand && this.isComparable((PhpRangeCheckDfaBasedTypeState)state) && this.compare((PhpRangeCheckDfaBasedTypeState)state) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "state";
        objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpRangeCheckDfaBasedTypeState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "coveredBy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "excludedBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Operand {
        GREATER(PhpTokenTypes.opGREATER),
        GREATER_EQ(PhpTokenTypes.opGREATER_OR_EQUAL),
        LOWER(PhpTokenTypes.opLESS),
        LOWER_EQ(PhpTokenTypes.opLESS_OR_EQUAL);

        public final IElementType myTokenType;

        private Operand(IElementType tokenType) {
            this.myTokenType = tokenType;
        }

        @NotNull
        public Operand invert() {
            IElementType invertedToken = PhpArrayEmptinessConditionDfaAnalyzer.invert(this.myTokenType);
            Operand operand = (Operand)((Object)ContainerUtil.find((Object[])Operand.values(), t -> t.myTokenType == invertedToken));
            if (operand == null) {
                Operand.$$$reportNull$$$0(0);
            }
            return operand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpRangeCheckDfaBasedTypeState$Operand", "invert"));
        }
    }

    public static class PhpVariableRangeCheckDfaBasedTypeState
    extends PhpRangeCheckDfaBasedTypeState
    implements PhpStateWithArgumentInfo {
        public final PhpStateArgumentInfo myArgumentInfo;
        public final String myVariableName;

        @Override
        public int getCustomHashCode() {
            return Objects.hash(this.myArgumentInfo, this.myVariableName);
        }

        public PhpVariableRangeCheckDfaBasedTypeState(Operand operand, PhpStateArgumentInfo argumentInfo) {
            super(operand, argumentInfo.getArgumentName());
            this.myVariableName = argumentInfo.getArgumentName();
            this.myArgumentInfo = argumentInfo;
        }

        @Override
        public boolean isComparable(PhpRangeCheckDfaBasedTypeState state) {
            return state instanceof PhpVariableRangeCheckDfaBasedTypeState && PhpLangUtil.equalsVariableNames(this.myVariableName, ((PhpVariableRangeCheckDfaBasedTypeState)state).myVariableName);
        }

        @Override
        public int compare(PhpRangeCheckDfaBasedTypeState state) {
            return 0;
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpVariableRangeCheckDfaBasedTypeState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpVariableBasedTypeState && this.excludedBy((PhpVariableBasedTypeState)((Object)state), ((PhpVariableBasedTypeState)((Object)state)).isNegated())) {
                return true;
            }
            return super.excludedBy(project, state, global, skippedStates);
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpVariableRangeCheckDfaBasedTypeState.$$$reportNull$$$0(1);
            }
            if (state instanceof PhpVariableBasedTypeState && ((PhpVariableBasedTypeState)((Object)state)).isNegated() && this.excludedBy((PhpVariableBasedTypeState)((Object)state), false)) {
                return true;
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        private boolean excludedBy(PhpVariableBasedTypeState state, boolean negated) {
            return !negated && PhpLangUtil.equalsVariableNames(state.getVariableName(), this.myVariableName) && (this.myOperand == Operand.GREATER || this.myOperand == Operand.LOWER);
        }

        @Override
        public Collection<PhpStateArgumentInfo> getInfo(boolean global) {
            return ContainerUtil.createMaybeSingletonList((Object)this.myArgumentInfo);
        }

        @NotNull
        public static Function<PhpInstruction, Boolean> createFieldNameDependency(@Nullable PhpStateArgumentInfo baseInfo, @Nullable String fullName, boolean global) {
            Function<PhpInstruction, Boolean> function = i -> {
                FunctionReference reference;
                if (i instanceof PhpAccessFieldByVariableInstruction) {
                    PhpExpression fieldReference = ((PhpAccessFieldByVariableInstruction)i).getFieldReference();
                    while (fieldReference instanceof FieldReference) {
                        PhpStateArgumentInfo classReferenceInfo;
                        String currentFieldName = PhpDfaBasedFieldAnalyzerProcessor.computeFieldName(fieldReference);
                        PhpExpression classReference = fieldReference.getClassReference();
                        if (currentFieldName != null && currentFieldName.equals(fullName)) {
                            return true;
                        }
                        if ((fullName == null || StringUtil.isEmpty((String)fieldReference.getName())) && baseInfo != null && classReference != null && (classReferenceInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)classReference, global)) != null && classReferenceInfo.getArgumentName().equals(baseInfo.getArgumentName())) {
                            return true;
                        }
                        fieldReference = classReference;
                    }
                } else if (i instanceof PhpCallInstruction && (reference = ((PhpCallInstruction)i).getFunctionReference()) instanceof MethodReference) {
                    PhpExpression classReference = ((MethodReference)reference).getClassReference();
                    PhpStateArgumentInfo classReferenceInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)classReference, global);
                    if (baseInfo != null && classReferenceInfo != null && classReferenceInfo.getArgumentName().equals(baseInfo.getArgumentName())) {
                        return PhpSideEffectDetector.canContainSideEffect((PsiElement)reference);
                    }
                }
                return i instanceof PhpYieldInstruction;
            };
            if (function == null) {
                PhpVariableRangeCheckDfaBasedTypeState.$$$reportNull$$$0(2);
            }
            return function;
        }

        @NotNull
        public static Function<PhpInstruction, Boolean> createArrayNameDependency(@NotNull PhpStateArgumentInfo originalInfo, @Nullable String fullName, Predicate<PsiElement> arrayValuePredicate, boolean global) {
            if (originalInfo == null) {
                PhpVariableRangeCheckDfaBasedTypeState.$$$reportNull$$$0(3);
            }
            PhpStateArgumentInfo baseInfo = originalInfo.getBaseInfo();
            Function<PhpInstruction, Boolean> function = i -> {
                if (i instanceof PhpArrayAccessInstruction) {
                    Object anchor = i.getAnchor();
                    while (anchor instanceof ArrayAccessExpression) {
                        PhpPsiElement value = ((ArrayAccessExpression)anchor).getValue();
                        PhpStateArgumentInfo valueInfo = null;
                        if (fullName != null) {
                            if (fullName.contains("#") && fullName.equals(PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)anchor))) {
                                return true;
                            }
                            if (value != null && arrayValuePredicate.test((PsiElement)value)) {
                                String valueName;
                                valueInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)value, false);
                                String string = valueName = valueInfo != null ? valueInfo.getArgumentName() : null;
                                if (PhpLangUtil.equalsVariableNames(fullName, valueName)) {
                                    return true;
                                }
                            }
                        }
                        if (baseInfo != null && baseInfo.getElementPredicate().test((PsiElement)value) && (PhpPreviousArrayDfaAnalyzerProcessor.nonConstantIndexValue(anchor) || originalInfo instanceof PhpStateArgumentInfo.PhpArrayStateArgumentInfo && PhpVariableRangeCheckDfaBasedTypeState.nonConstantIndex(((PhpStateArgumentInfo.PhpArrayStateArgumentInfo)originalInfo).getIndex()))) {
                            if (valueInfo == null) {
                                valueInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)value, global);
                            }
                            if (valueInfo != null && valueInfo.getArgumentName().equals(baseInfo.getArgumentName())) {
                                return true;
                            }
                        }
                        anchor = value;
                    }
                }
                return false;
            };
            if (function == null) {
                PhpVariableRangeCheckDfaBasedTypeState.$$$reportNull$$$0(4);
            }
            return function;
        }

        private static boolean nonConstantIndex(PsiElement indexValue) {
            return indexValue == null || !PhpDfaBasedArrayAnalyzerProcessor.isStaticIndexValue(indexValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpRangeCheckDfaBasedTypeState$PhpVariableRangeCheckDfaBasedTypeState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpRangeCheckDfaBasedTypeState$PhpVariableRangeCheckDfaBasedTypeState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFieldNameDependency";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createArrayNameDependency";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "excludedBy";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "coveredBy";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createArrayNameDependency";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpIntRangeCheckDfaBasedTypeState
    extends PhpRangeCheckDfaBasedTypeState {
        private final int myValue;

        public PhpIntRangeCheckDfaBasedTypeState(Operand operand, int value) {
            super(operand, String.valueOf(value));
            this.myValue = value;
        }

        @Override
        public int getCustomHashCode() {
            return Objects.hash(this.myValue, this.myName);
        }

        public int getValue() {
            return this.myValue;
        }

        @Override
        public boolean isComparable(PhpRangeCheckDfaBasedTypeState state) {
            return state instanceof PhpIntRangeCheckDfaBasedTypeState;
        }

        @Override
        public int compare(PhpRangeCheckDfaBasedTypeState state) {
            if (!(state instanceof PhpIntRangeCheckDfaBasedTypeState)) {
                throw new IllegalArgumentException(state.getClass().getName());
            }
            return Integer.compare(this.myValue, ((PhpIntRangeCheckDfaBasedTypeState)state).myValue);
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpIntRangeCheckDfaBasedTypeState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpVariableCheckDfaBasedTypeState.PhpIntModuloOnVariableState) {
                return false;
            }
            if (state instanceof PhpIntCapableComparisonState && ((PhpIntCapableComparisonState)((Object)state)).isNegated() && this.excludedBy((PhpIntCapableComparisonState)((Object)state), false)) {
                return true;
            }
            return super.coveredBy(project, state, global, skippedStates);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global, MultiMap<PhpDfaBasedTypeState, PhpDfaBasedTypeState> skippedStates) {
            if (state == null) {
                PhpIntRangeCheckDfaBasedTypeState.$$$reportNull$$$0(1);
            }
            if (state instanceof PhpIntCapableComparisonState && this.excludedBy((PhpIntCapableComparisonState)((Object)state), ((PhpIntCapableComparisonState)((Object)state)).isNegated())) {
                return true;
            }
            return super.excludedBy(project, state, global, skippedStates);
        }

        private boolean excludedBy(PhpIntCapableComparisonState state, boolean negated) {
            if (!negated) {
                Integer value = state.getValue();
                return value != null && (this.myOperand == Operand.LOWER && value >= this.myValue || this.myOperand == Operand.LOWER_EQ && value > this.myValue || this.myOperand == Operand.GREATER && value <= this.myValue || this.myOperand == Operand.GREATER_EQ && value < this.myValue);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "state";
            objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpRangeCheckDfaBasedTypeState$PhpIntRangeCheckDfaBasedTypeState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

