/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpDfaBasedArrayAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.field.PhpPreviousFieldDfaAnalyzerProcessor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface PhpStateArgumentInfo {
    @NotNull
    public String getArgumentName();

    @Nullable
    public PhpStateArgumentInfo getBaseInfo();

    public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean var1);

    default public @Unmodifiable Collection<Function<PhpInstruction, Boolean>> getStateDependenciesCheckers(boolean global) {
        Collection<Function<PhpInstruction, Boolean>> dependencies = this.doGetStateDependenciesCheckers(global);
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        return ContainerUtil.union(dependencies, this.getIndirectDependencies(global));
    }

    default public Collection<Function<PhpInstruction, Boolean>> getIndirectDependencies(boolean global) {
        return Collections.singleton(PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createArrayNameDependency(this, this.getArgumentName(), this.getElementPredicate(), global));
    }

    public Predicate<PsiElement> getElementPredicate();

    @Nullable
    public static PhpStateArgumentInfo tryCreateInfo(@Nullable PsiElement argument, boolean global) {
        if (argument instanceof Variable) {
            return new PhpVariableStateArgumentInfo(((Variable)argument).getName());
        }
        if (argument instanceof FieldReference) {
            PhpStateArgumentInfo variableInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)((FieldReference)argument).getClassReference(), global);
            String name = ((FieldReference)argument).getName();
            if (variableInfo != null) {
                if (name == null) {
                    PhpStateArgumentInfo variableNameNodeInfo = PhpPreviousFieldDfaAnalyzerProcessor.getNameNodeArgumentInfo((FieldReference)argument, global);
                    return variableNameNodeInfo != null ? new PhpDynamicFieldStateArgumentInfo(variableInfo, variableNameNodeInfo) : null;
                }
                return new PhpFieldStateArgumentInfo(variableInfo, name);
            }
        } else if (argument instanceof ArrayAccessExpression) {
            ArrayIndex index;
            PhpPsiElement indexValue;
            PhpStateArgumentInfo variableInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)((ArrayAccessExpression)argument).getValue(), global);
            PhpArrayStateArgumentInfo info = PhpArrayStateArgumentInfo.create(variableInfo, indexValue = (index = ((ArrayAccessExpression)argument).getIndex()) != null ? index.getValue() : null);
            if (info != null) {
                return info;
            }
        } else if (argument instanceof ConstantReference || argument instanceof ClassConstantReference && ((ClassConstantReference)argument).getClassReference() instanceof ClassReference) {
            String signature = ((PhpReference)argument).getSignature();
            if (!signature.isEmpty()) {
                return new PhpConstantReferenceArgumentInfo(signature);
            }
        } else {
            PhpStateArgumentInfo valueInfo;
            PsiElement operation;
            IElementType operationType;
            if (argument instanceof FunctionReference && global && !PhpSideEffectDetector.canContainSideEffect(argument)) {
                String signature = PhpStateArgumentInfo.getFullSignature(argument, 0);
                if (signature == null || signature.isEmpty()) {
                    return null;
                }
                List<PsiElement> arguments = Arrays.asList(((FunctionReference)argument).getParameters());
                Map argumentsInfosMap = ContainerUtil.map2Map(arguments, p -> Pair.create((Object)p, (Object)PhpStateArgumentInfo.tryCreateInfo(p, global)));
                if (PhpStateArgumentInfo.containsNonConstantExpressionWithoutInfo(argumentsInfosMap)) {
                    return null;
                }
                if (argument instanceof MethodReference) {
                    PhpStateArgumentInfo classReferenceInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)((MethodReference)argument).getClassReference(), global);
                    return classReferenceInfo != null ? new PhpMethodStateArgumentInfo(signature, classReferenceInfo, arguments) : null;
                }
                return new PhpFunctionStateArgumentInfo(signature, arguments);
            }
            if (argument instanceof UnaryExpression && (operationType = PsiUtilCore.getElementType((PsiElement)(operation = ((UnaryExpression)argument).getOperation()))) != null && PhpTokenTypes.tsCAST_OPS.contains(operationType) && (valueInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)((UnaryExpression)argument).getValue(), global)) != null) {
                return new PhpTypeCastArgumentInfo(operationType, valueInfo);
            }
        }
        return null;
    }

    public static PsiElement getVariableNameNode(FieldReference field) {
        for (PsiElement child = field.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (child instanceof PhpExpression || PhpPsiUtil.isOfType(child, PhpStubElementTypes.VARIABLE)) {
                return child;
            }
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.ARROW, PhpTokenTypes.SCOPE_RESOLUTION)) continue;
            return null;
        }
        return null;
    }

    @Nullable
    private static String getFullSignature(PsiElement argument, int depth) {
        if (depth >= 200) {
            return null;
        }
        if (argument instanceof MethodReference) {
            return PhpTypeSignatureKey.METHOD.sign(PhpStateArgumentInfo.getFullSignature((PsiElement)((MethodReference)argument).getClassReference(), depth + 1) + "." + ((MethodReference)argument).getName());
        }
        if (argument instanceof PhpReference) {
            return ((PhpReference)argument).getSignature();
        }
        return null;
    }

    private static boolean containsNonConstantExpressionWithoutInfo(Map<PsiElement, PhpStateArgumentInfo> argumentsInfosMap) {
        return EntryStream.of(argumentsInfosMap).filterKeyValue((k, v) -> v == null && !PhpStateArgumentInfo.isConstantExpression(k)).findAny().isPresent();
    }

    private static boolean isConstantExpression(PsiElement key) {
        return key instanceof StringLiteralExpression || PhpPsiUtil.isOfType(key, PhpElementTypes.NUMBER) || key instanceof ConstantReference || key instanceof ClassConstantReference;
    }

    public static class PhpVariableStateArgumentInfo
    implements PhpStateArgumentInfo {
        @NotNull
        @NlsSafe
        private final String myVariableName;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpVariableStateArgumentInfo info = (PhpVariableStateArgumentInfo)o;
            return Objects.equals(this.myVariableName, info.myVariableName);
        }

        public int hashCode() {
            return Objects.hash(this.myVariableName);
        }

        public PhpVariableStateArgumentInfo(@NotNull @NlsSafe String variableName) {
            if (variableName == null) {
                PhpVariableStateArgumentInfo.$$$reportNull$$$0(0);
            }
            this.myVariableName = variableName;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.myVariableName;
            if (string == null) {
                PhpVariableStateArgumentInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return this;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return Collections.singleton(PhpPreviousDfaAnalyzerProcessor.createVariableNameDependency(this.myVariableName));
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> getIndirectDependencies(boolean global) {
            return this.getIndirectDependencies(global, null);
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return obj -> obj instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)obj).getName(), this.getArgumentName());
        }

        public Collection<Function<PhpInstruction, Boolean>> getIndirectDependencies(boolean global, @Nullable PhpScopeHolder scopeHolder) {
            Collection<Function<PhpInstruction, Boolean>> indirectDependencies = PhpStateArgumentInfo.super.getIndirectDependencies(global);
            if (scopeHolder != null) {
                if (PhpLangUtil.isSuperGlobal(this.myVariableName)) {
                    return ContainerUtil.union(indirectDependencies, Collections.singleton(PhpVariableStateArgumentInfo.createNonPureFunctionCallDependency(global)));
                }
                if (global) {
                    Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarationsByScope((PsiElement)scopeHolder, false, this.myVariableName);
                    if (scopeHolder instanceof PhpFile && !declarations.isEmpty() || ContainerUtil.exists(declarations, v -> v.getParent() instanceof Global)) {
                        return ContainerUtil.union(indirectDependencies, Collections.singleton(PhpVariableStateArgumentInfo.createNonPureFunctionCallDependency(global)));
                    }
                }
            }
            return indirectDependencies;
        }

        private static Function<PhpInstruction, Boolean> createNonPureFunctionCallDependency(boolean global) {
            return i -> i instanceof PhpCallInstruction && PhpSideEffectDetector.canContainSideEffect((PsiElement)((PhpCallInstruction)i).getFunctionReference(), global);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpVariableStateArgumentInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpVariableStateArgumentInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PhpDynamicFieldStateArgumentInfo
    extends PhpFieldStateArgumentInfo {
        @NotNull
        private final PhpStateArgumentInfo myDynamicVariableNameNode;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PhpDynamicFieldStateArgumentInfo info = (PhpDynamicFieldStateArgumentInfo)o;
            return Objects.equals(this.myDynamicVariableNameNode, info.myDynamicVariableNameNode);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myDynamicVariableNameNode);
        }

        public PhpDynamicFieldStateArgumentInfo(PhpStateArgumentInfo baseInfo, PhpStateArgumentInfo dynamicVariableNameNode) {
            super(baseInfo, "$" + dynamicVariableNameNode.getArgumentName());
            this.myDynamicVariableNameNode = dynamicVariableNameNode;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return ContainerUtil.union(super.doGetStateDependenciesCheckers(global), this.getDynamicVariableNameNodeDependencies(global));
        }

        @NotNull
        private List<Function<PhpInstruction, Boolean>> getDynamicVariableNameNodeDependencies(boolean global) {
            List list = (List)PhpFunctionStateArgumentInfo.expand(this, global).append(this.myDynamicVariableNameNode.doGetStateDependenciesCheckers(global)).append(PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createFieldNameDependency(this.getBaseInfo(), null, global)).collect(Collectors.toList());
            if (list == null) {
                PhpDynamicFieldStateArgumentInfo.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpDynamicFieldStateArgumentInfo", "getDynamicVariableNameNodeDependencies"));
        }
    }

    public static class PhpFieldStateArgumentInfo
    implements PhpStateArgumentInfo {
        private final PhpStateArgumentInfo myBaseInfo;
        private final String myFieldName;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpFieldStateArgumentInfo info = (PhpFieldStateArgumentInfo)o;
            return Objects.equals(this.myBaseInfo, info.myBaseInfo) && Objects.equals(this.myFieldName, info.myFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.myBaseInfo, this.myFieldName);
        }

        public PhpFieldStateArgumentInfo(PhpStateArgumentInfo baseInfo, String fieldName) {
            this.myBaseInfo = baseInfo;
            this.myFieldName = fieldName;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.myBaseInfo.getArgumentName() + "." + this.myFieldName;
            if (string == null) {
                PhpFieldStateArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return this.myBaseInfo;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return (Collection)((StreamEx)StreamEx.of(this.myBaseInfo.doGetStateDependenciesCheckers(global)).append(PhpFunctionStateArgumentInfo.expand(this, global))).collect(Collectors.toList());
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return FieldReference.class::isInstance;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpFieldStateArgumentInfo", "getArgumentName"));
        }
    }

    public static class PhpArrayStateArgumentInfo
    implements PhpStateArgumentInfo {
        private final PhpStateArgumentInfo myBaseInfo;
        @Nullable
        private final PsiElement myIndex;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpArrayStateArgumentInfo info = (PhpArrayStateArgumentInfo)o;
            return Objects.equals(this.myBaseInfo, info.myBaseInfo) && Objects.equals(this.myIndex, info.myIndex);
        }

        public int hashCode() {
            return Objects.hash(this.myBaseInfo, this.myIndex);
        }

        public PhpArrayStateArgumentInfo(PhpStateArgumentInfo baseInfo, @Nullable PsiElement index) {
            this.myBaseInfo = baseInfo;
            this.myIndex = index;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.myBaseInfo.getArgumentName() + "#" + (this.myIndex != null ? PhpDfaBasedArrayAnalyzerProcessor.getValueInfoText(this.myIndex) : "");
            if (string == null) {
                PhpArrayStateArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return this.myBaseInfo;
        }

        @Nullable
        public PsiElement getIndex() {
            return this.myIndex;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            Set dependencies = ContainerUtil.union(this.myBaseInfo.doGetStateDependenciesCheckers(global), Collections.singleton(PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createArrayNameDependency(this, this.getArgumentName(), this.getElementPredicate(), global)));
            return ContainerUtil.union((Collection)dependencies, PhpArrayStateArgumentInfo.getIndexDependencies(this.myIndex, global));
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return ArrayAccessExpression.class::isInstance;
        }

        public static Collection<Function<PhpInstruction, Boolean>> getIndexDependencies(@Nullable PsiElement index, boolean global) {
            PhpStateArgumentInfo indexInfo = PhpStateArgumentInfo.tryCreateInfo(index, global);
            if (indexInfo != null) {
                return indexInfo.getStateDependenciesCheckers(global);
            }
            if (index instanceof StringLiteralExpression) {
                return PhpPsiUtil.getChildren(index, (Condition<? super PsiElement>)((Condition)Variable.class::isInstance)).stream().map(v -> (PhpPsiElement)ObjectUtils.notNull((Object)v.getFirstPsiChild(), (Object)v)).map(v -> PhpStateArgumentInfo.tryCreateInfo((PsiElement)v, global)).filter(Objects::nonNull).flatMap(i -> i.getStateDependenciesCheckers(global).stream()).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        @Nullable
        public static PhpArrayStateArgumentInfo create(@Nullable PhpStateArgumentInfo baseInfo, PhpPsiElement indexValue) {
            if (baseInfo != null && (PhpDfaBasedArrayAnalyzerProcessor.getValueInfoText((PsiElement)indexValue) != null || indexValue == null)) {
                return new PhpArrayStateArgumentInfo(baseInfo, (PsiElement)indexValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpArrayStateArgumentInfo", "getArgumentName"));
        }
    }

    public static class PhpConstantReferenceArgumentInfo
    implements PhpStateArgumentInfo {
        private final String mySignature;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpConstantReferenceArgumentInfo info = (PhpConstantReferenceArgumentInfo)o;
            return Objects.equals(this.mySignature, info.mySignature);
        }

        public int hashCode() {
            return Objects.hash(this.mySignature);
        }

        public PhpConstantReferenceArgumentInfo(String signature) {
            this.mySignature = signature;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = "?" + this.mySignature;
            if (string == null) {
                PhpConstantReferenceArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return null;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return Collections.emptyList();
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return argument -> argument instanceof ConstantReference || argument instanceof ClassConstantReference && ((ClassConstantReference)argument).getClassReference() instanceof ClassReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpConstantReferenceArgumentInfo", "getArgumentName"));
        }
    }

    public static class PhpMethodStateArgumentInfo
    extends PhpFunctionStateArgumentInfo {
        private final PhpStateArgumentInfo myClassArgumentIfo;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PhpMethodStateArgumentInfo info = (PhpMethodStateArgumentInfo)o;
            return Objects.equals(this.myClassArgumentIfo, info.myClassArgumentIfo);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myClassArgumentIfo);
        }

        public PhpMethodStateArgumentInfo(String signature, PhpStateArgumentInfo classArgumentIfo, Collection<PsiElement> argumentsInfos) {
            super(signature, argumentsInfos);
            this.myClassArgumentIfo = classArgumentIfo;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return (Collection)((StreamEx)StreamEx.of(super.doGetStateDependenciesCheckers(global)).append(this.myClassArgumentIfo.doGetStateDependenciesCheckers(global)).append(PhpMethodStateArgumentInfo.expand(this, global))).append(PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createFieldNameDependency(this.getBaseInfo(), null, global)).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return this.myClassArgumentIfo;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.myClassArgumentIfo.getArgumentName() + "|" + super.getArgumentName();
            if (string == null) {
                PhpMethodStateArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return MethodReference.class::isInstance;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpMethodStateArgumentInfo", "getArgumentName"));
        }
    }

    public static class PhpFunctionStateArgumentInfo
    implements PhpStateArgumentInfo {
        private final String mySignature;
        private final Collection<PsiElement> myInfos;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpFunctionStateArgumentInfo info = (PhpFunctionStateArgumentInfo)o;
            return Objects.equals(this.mySignature, info.mySignature) && Objects.equals(this.myInfos, info.myInfos);
        }

        public int hashCode() {
            return Objects.hash(this.mySignature, this.myInfos);
        }

        public PhpFunctionStateArgumentInfo(String signature, Collection<@NotNull PsiElement> argumentsInfos) {
            this.mySignature = signature;
            this.myInfos = argumentsInfos;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.mySignature + "|" + StringUtil.join(this.myInfos, p -> PhpFunctionStateArgumentInfo.getName(p), (String)"|");
            if (string == null) {
                PhpFunctionStateArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static String getName(PsiElement argument) {
            PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(argument, false);
            return info != null ? info.getArgumentName() : argument.getText();
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return null;
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return this.myInfos.stream().map(argument -> PhpStateArgumentInfo.tryCreateInfo(argument, global)).filter(Objects::nonNull).flatMap(info -> StreamEx.of(info.doGetStateDependenciesCheckers(global)).append(PhpFunctionStateArgumentInfo.expand(info, global))).collect(Collectors.toList());
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return FunctionReference.class::isInstance;
        }

        public static StreamEx<Function<PhpInstruction, Boolean>> expand(PhpStateArgumentInfo info, boolean global) {
            PhpStateArgumentInfo baseInfo = info.getBaseInfo();
            StreamEx checkers = StreamEx.of((Object[])new Function[]{PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createFieldNameDependency(baseInfo, info.getArgumentName(), global), PhpRangeCheckDfaBasedTypeState.PhpVariableRangeCheckDfaBasedTypeState.createArrayNameDependency(info, info.getArgumentName(), info.getElementPredicate(), global)});
            PhpStateArgumentInfo unwrappedBaseInfo = PhpFunctionStateArgumentInfo.unwrapBaseInfo(baseInfo);
            if (unwrappedBaseInfo instanceof PhpVariableStateArgumentInfo && PhpLangUtil.isThisReference(unwrappedBaseInfo.getArgumentName())) {
                return checkers.append(PhpFunctionStateArgumentInfo.getCallDependencyChecker(global));
            }
            return checkers;
        }

        @NotNull
        public static Function<PhpInstruction, Boolean> getCallDependencyChecker(boolean global) {
            Function<PhpInstruction, Boolean> function = i -> {
                FunctionReference reference;
                if (i instanceof PhpCallInstruction && (reference = ((PhpCallInstruction)i).getFunctionReference()) instanceof MethodReference && PhpFunctionStateArgumentInfo.isMethodCallFromHierarchyWithSideEffects((MethodReference)reference, global)) {
                    return true;
                }
                return false;
            };
            if (function == null) {
                PhpFunctionStateArgumentInfo.$$$reportNull$$$0(1);
            }
            return function;
        }

        private static boolean isMethodCallFromHierarchyWithSideEffects(MethodReference reference, boolean global) {
            if (!reference.isStatic() || !(reference.getClassReference() instanceof ClassReference)) {
                return false;
            }
            PhpClass phpClass = PhpPsiUtil.getParentOfClass((PsiElement)reference, PhpClass.class);
            if (phpClass == null) {
                return false;
            }
            return !global || PhpSideEffectDetector.canContainSideEffect((PsiElement)reference) && PhpFunctionStateArgumentInfo.isResolvedMethodInsideHierarchy(reference, phpClass);
        }

        private static boolean isResolvedMethodInsideHierarchy(MethodReference reference, PhpClass phpClass) {
            return ContainerUtil.exists((Iterable)reference.multiResolveStrict(Method.class), m -> {
                PhpClass superClass = m.getContainingClass();
                return !m.isStatic() && superClass != null && (superClass == phpClass || PhpClassHierarchyUtils.isSuperClass(superClass, phpClass, true) || PhpClassHierarchyUtils.isSuperClass(phpClass, superClass, true));
            });
        }

        @Nullable
        private static PhpStateArgumentInfo unwrapBaseInfo(PhpStateArgumentInfo baseInfo) {
            PhpStateArgumentInfo base;
            PhpStateArgumentInfo oldInfo;
            while (baseInfo != null && (oldInfo = baseInfo) != (base = baseInfo.getBaseInfo())) {
                baseInfo = base;
            }
            return baseInfo;
        }

        public String getSignature() {
            return this.mySignature;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpFunctionStateArgumentInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgumentName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallDependencyChecker";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class PhpTypeCastArgumentInfo
    implements PhpStateArgumentInfo {
        private final IElementType myTokenType;
        private final PhpStateArgumentInfo myValueInfo;

        public PhpTypeCastArgumentInfo(IElementType tokenType, PhpStateArgumentInfo valueInfo) {
            this.myTokenType = tokenType;
            this.myValueInfo = valueInfo;
        }

        @Override
        @NotNull
        public String getArgumentName() {
            String string = this.myTokenType.getDebugName() + "|" + this.myValueInfo.getArgumentName();
            if (string == null) {
                PhpTypeCastArgumentInfo.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PhpStateArgumentInfo getBaseInfo() {
            return this.myValueInfo.getBaseInfo();
        }

        @Override
        public Collection<Function<PhpInstruction, Boolean>> doGetStateDependenciesCheckers(boolean global) {
            return this.myValueInfo.doGetStateDependenciesCheckers(global);
        }

        @Override
        public Predicate<PsiElement> getElementPredicate() {
            return UnaryExpression.class::isInstance;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/PhpStateArgumentInfo$PhpTypeCastArgumentInfo", "getArgumentName"));
        }
    }
}

