/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.controlFlow.PhpConditionAlreadyCheckedInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.array.PhpDfaBasedArrayAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpPreviousFunctionDfaAnalyzerProcessor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPreviousArrayDfaAnalyzerProcessor
extends PhpPreviousDfaAnalyzerProcessor {
    @Nullable
    private final String myArrayName;

    public PhpPreviousArrayDfaAnalyzerProcessor(@NotNull Project project, String argumentName, @NotNull ArrayAccessExpression reference, boolean stopOnNegations, TextRange outerTextRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global) {
        if (project == null) {
            PhpPreviousArrayDfaAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            PhpPreviousArrayDfaAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        super(project, reference.getName(), argumentName, stopOnNegations, outerTextRange, (PsiElement)reference, currentState, global);
        ArrayIndex index = reference.getIndex();
        if (index != null) {
            this.myStateDependenciesCheckers = ContainerUtil.union((Collection)this.myStateDependenciesCheckers, PhpStateArgumentInfo.PhpArrayStateArgumentInfo.getIndexDependencies((PsiElement)index.getValue(), global));
        }
        this.myArrayName = this.myAnchor != null ? PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)this.myAnchor) : null;
    }

    @Override
    @NotNull
    protected Collection<Function<PhpInstruction, Boolean>> getStateDependenciesCheckers(PhpDfaBasedTypeState currentState) {
        ArrayIndex index;
        PhpPsiElement indexValue;
        PhpStateArgumentInfo indexInfo;
        Collection<Function<PhpInstruction, Boolean>> checkers = super.getStateDependenciesCheckers(currentState);
        if (this.myAnchor instanceof ArrayAccessExpression && (indexInfo = PhpStateArgumentInfo.tryCreateInfo((PsiElement)(indexValue = (index = ((ArrayAccessExpression)this.myAnchor).getIndex()) != null ? index.getValue() : null), false)) != null) {
            Set set = ContainerUtil.union(checkers, indexInfo.getStateDependenciesCheckers(false));
            if (set == null) {
                PhpPreviousArrayDfaAnalyzerProcessor.$$$reportNull$$$0(2);
            }
            return set;
        }
        Collection<Function<PhpInstruction, Boolean>> collection = checkers;
        if (collection == null) {
            PhpPreviousArrayDfaAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    protected boolean sameVariableName(CharSequence name) {
        return this.myAnchor == null || name != null && name.equals(this.myArrayName);
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (!super.processAccessVariableInstruction(instruction)) {
            return false;
        }
        PhpAccessInstruction.Access access = instruction.getAccess();
        String valueVariableName = this.getValueVariableName();
        if (valueVariableName != null && PhpLangUtil.equalsVariableNames(valueVariableName, instruction.getVariableName()) && PhpConditionAlreadyCheckedInspection.isModifyingAccess(access, this.myGlobal)) {
            PsiElement assignedValue = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue();
            if (assignedValue != null && PhpPreviousFunctionDfaAnalyzerProcessor.doRegisterStateFromArrayKeyInInit(assignedValue, (Processor<? super ArrayHashElement>)((Processor)hashElement -> this.tryRegisterArrayKeyAssignment(instruction, (ArrayHashElement)hashElement, (PsiElement)instruction.getAnchor())))) {
                return false;
            }
            this.registerUnsetOrUnknownState(instruction, this.myArrayName);
            return false;
        }
        return true;
    }

    @Nullable
    private String getValueVariableName() {
        Object value = this.myAnchor;
        while (value instanceof ArrayAccessExpression) {
            value = ((ArrayAccessExpression)value).getValue();
        }
        return value instanceof Variable ? ((Variable)value).getName() : null;
    }

    @Override
    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        String name = this.getValueVariableName();
        if (this.myAnchor != null && name != null && PhpPreviousArrayDfaAnalyzerProcessor.isUnresolvedFunctionWithVariableParameter(name, instruction)) {
            this.setUnknownState(instruction, this.myArrayName);
        }
        return super.processPhpCallInstruction(instruction);
    }

    @Override
    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        if (PhpConditionAlreadyCheckedInspection.isModifyingAccess(instruction.getAccess(), false)) {
            PhpPsiElement anchor = instruction.getAnchor();
            while (anchor instanceof ArrayAccessExpression) {
                ArrayAccessExpression anchorToCreateName;
                PhpPsiElement value = ((ArrayAccessExpression)anchor).getValue();
                ArrayAccessExpression arrayAccessExpression = anchorToCreateName = this.myAnchor != null ? (ArrayAccessExpression)this.myAnchor : (ArrayAccessExpression)anchor;
                if (this.sameElement((PsiElement)anchor)) {
                    AssignmentExpression assignment = PhpPsiUtil.getParentOfClass((PsiElement)anchor, AssignmentExpression.class);
                    if (assignment != null && assignment.getVariable() == anchor && this.registerStateFromWrappedAssignedValue(instruction, (PsiElement)assignment.getValue(), (PsiElement)anchorToCreateName)) {
                        return false;
                    }
                    this.registerUnsetOrUnknownState(instruction, PhpDfaBasedArrayAnalyzerProcessor.computeArrayName(anchorToCreateName));
                    return false;
                }
                if (value instanceof Variable && PhpPreviousArrayDfaAnalyzerProcessor.nonConstantIndexValue((PsiElement)anchor) && PhpLangUtil.equalsVariableNames(value.getName(), this.getVariableName()) || PhpPreviousArrayDfaAnalyzerProcessor.nonConstantIndexValue(this.myAnchor) && this.sameValue((ArrayAccessExpression)anchor)) {
                    this.setUnknownState(instruction, PhpDfaBasedArrayAnalyzerProcessor.computeArrayName(anchorToCreateName));
                    return false;
                }
                anchor = value;
            }
        }
        return super.processArrayAccessInstruction(instruction);
    }

    @Nullable
    private CharSequence getVariableName() {
        if (this.myAnchor == null) {
            return null;
        }
        Variable variable = (Variable)ObjectUtils.tryCast((Object)((ArrayAccessExpression)this.myAnchor).getValue(), Variable.class);
        return variable != null ? variable.getName() : null;
    }

    @Override
    public boolean sameElement(@Nullable PsiElement element) {
        return element instanceof ArrayAccessExpression && (this.myAnchor == null || Objects.equals(PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)element), this.myArrayName));
    }

    private boolean sameValue(ArrayAccessExpression element) {
        return PhpPsiUtil.areElementsEquivalent((PsiElement)element.getValue(), (PsiElement)((ArrayAccessExpression)this.myAnchor).getValue());
    }

    public static boolean nonConstantIndexValue(@Nullable PsiElement anchor) {
        if (anchor instanceof ArrayAccessExpression) {
            PhpPsiElement indexValue;
            ArrayIndex index = ((ArrayAccessExpression)anchor).getIndex();
            PhpPsiElement phpPsiElement = indexValue = index != null ? index.getValue() : null;
            if (indexValue != null && !PhpDfaBasedArrayAnalyzerProcessor.isStaticIndexValue((PsiElement)indexValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected PhpPreviousDfaAnalyzerProcessor createProcessor(TextRange outerRange) {
        return new PhpPreviousArrayDfaAnalyzerProcessor(this.myProject, this.myArgumentName, (ArrayAccessExpression)this.myAnchor, this.myStopOnNegations, outerRange, this.myCurrentState, this.myGlobal);
    }

    @Override
    @NotNull
    protected PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer(boolean stopOnNegations) {
        return new PhpDfaBasedArrayAnalyzerProcessor.PhpArrayDfaBaseStateConditionDFAnalyzer((ArrayAccessExpression)this.myAnchor, this.myGlobal, stopOnNegations, false);
    }

    @Override
    protected CharSequence computeVariableName(PsiElement variable) {
        return PhpDfaBasedArrayAnalyzerProcessor.computeArrayName((ArrayAccessExpression)variable);
    }

    public static PhpPreviousArrayDfaAnalyzerProcessor createFromVariableName(@NotNull Project project, String stateVariableName, PsiElement condition, boolean stopOnNegations, TextRange outerTextRange, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global) {
        ArrayAccessExpression fieldReference;
        if (project == null) {
            PhpPreviousArrayDfaAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        return (fieldReference = (ArrayAccessExpression)ContainerUtil.find(PhpPsiUtil.findChildrenNonStrict(condition, ArrayAccessExpression.class), f -> stateVariableName.equals(PhpDfaBasedArrayAnalyzerProcessor.computeArrayName(f)))) != null ? new PhpPreviousArrayDfaAnalyzerProcessor(project, stateVariableName, fieldReference, stopOnNegations, outerTextRange, currentState, global) : null;
    }

    public static boolean applicable(String stateVariableName) {
        return stateVariableName.indexOf(35) > 0;
    }

    @Override
    public boolean registerStateFromAssignedValue(PhpInstruction instruction, @Nullable PsiElement value, @Nullable PsiElement variable) {
        if (PhpPreviousFunctionDfaAnalyzerProcessor.doRegisterStateFromArrayKeyInInit(value, (Processor<? super ArrayHashElement>)((Processor)hashElement -> this.tryRegisterArrayKeyAssignment(instruction, (ArrayHashElement)hashElement, variable)))) {
            return true;
        }
        return super.registerStateFromAssignedValue(instruction, value, variable);
    }

    private boolean tryRegisterArrayKeyAssignment(PhpInstruction instruction, ArrayHashElement element, PsiElement variable) {
        PhpPsiElement key = element.getKey();
        PhpPsiElement value = element.getValue();
        if (key == null || value == null) {
            return false;
        }
        String declaredArrayName = PhpDfaBasedArrayAnalyzerProcessor.computeArrayName(variable, key);
        if (this.myAnchor != null && declaredArrayName != null && declaredArrayName.equals(this.myArrayName)) {
            return this.doRegisterStateFromAssignedValue(instruction, (PsiElement)value, declaredArrayName);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/array/PhpPreviousArrayDfaAnalyzerProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/array/PhpPreviousArrayDfaAnalyzerProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateDependenciesCheckers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromVariableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

