/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpDuplicateArrayKeysInspection;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpRangeCheckDfaBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpStateArgumentInfo;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.function.PhpDfaBasedFunctionAnalyzerProcessor;
import com.jetbrains.php.lang.intentions.PhpReplaceQuotesIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.patterns.PhpPatterns;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPreviousFunctionDfaAnalyzerProcessor
extends PhpPreviousDfaAnalyzerProcessor {
    private static final String ARRAY_KEY_EXISTS_SIGNATURE = "#F\\array_key_exists";
    private static final String STRLEN_SIGNATURE = "#F\\strlen";
    private static final PhpStrLengthEstimation AMBIGUOUS_ESTIMATION = new PhpStrLengthEstimation(0, true);
    protected final PhpStateArgumentInfo.PhpFunctionStateArgumentInfo myInfo;

    public PhpPreviousFunctionDfaAnalyzerProcessor(@NotNull Project project, String argumentName, boolean stopOnNegations, TextRange outerTextRange, PhpStateArgumentInfo.PhpFunctionStateArgumentInfo info, PhpDfaBasedAnalyzerProcessor.PhpVariableDfaStateWithInstruction<PhpDfaBasedTypeState> currentState, boolean global, @Nullable FunctionReference functionReference) {
        if (project == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        super(project, info.getArgumentName(), argumentName, stopOnNegations, outerTextRange, (PsiElement)functionReference, currentState, global);
        this.myInfo = info;
        this.myStateDependenciesCheckers = ContainerUtil.union((Collection)this.myStateDependenciesCheckers, info.getStateDependenciesCheckers(this.myGlobal));
    }

    @Override
    public boolean sameElement(@Nullable PsiElement element) {
        if (element instanceof FunctionReference) {
            PhpStateArgumentInfo info = PhpStateArgumentInfo.tryCreateInfo(element, this.myGlobal);
            return info != null && info.getArgumentName().equals(this.myInfo.getArgumentName());
        }
        return false;
    }

    @Override
    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        if (this.tryRegisterArrayKeyExistsFromAssignment(instruction) || this.registerStateFromAssignedValue(instruction)) {
            return false;
        }
        return super.processArrayAccessInstruction(instruction);
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (this.registerStateFromAssignedValue(instruction)) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    @Override
    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
        if (this.registerStateFromAssignedValue(instruction)) {
            return false;
        }
        return super.processAccessFieldByVariableInstruction(instruction);
    }

    public static boolean doRegisterStateFromArrayKeyInInit(@Nullable PsiElement value, Processor<? super ArrayHashElement> stateRegisterFunction) {
        boolean res = false;
        for (ArrayHashElement element : PhpPreviousFunctionDfaAnalyzerProcessor.unwrapMergedArrays(value, false)) {
            res = stateRegisterFunction.process((Object)element) || res;
        }
        return res;
    }

    public static List<ArrayHashElement> unwrapMergedArrays(PsiElement value, boolean allowAmbiguous) {
        return ContainerUtil.map(PhpPreviousFunctionDfaAnalyzerProcessor.doUnwrapMergedArrays(value, allowAmbiguous, false).values(), ContainerUtil::getFirstItem);
    }

    public static Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> doUnwrapMergedArrays(PsiElement value, boolean allowAmbiguous, boolean inferAssignedValues) {
        if (value instanceof ArrayCreationExpression) {
            return PhpDuplicateArrayKeysInspection.getKeyValueToKeyElementMap((ArrayCreationExpression)value);
        }
        if (value instanceof BinaryExpression && ((BinaryExpression)value).getOperationType() == PhpTokenTypes.opPLUS) {
            return PhpPreviousFunctionDfaAnalyzerProcessor.mergeElements(Arrays.asList(((BinaryExpression)value).getLeftOperand(), ((BinaryExpression)value).getRightOperand()), allowAmbiguous, inferAssignedValues);
        }
        if (value instanceof FunctionReference && (PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)value, "array_merge") || PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)value, "array_merge_recursive"))) {
            return PhpPreviousFunctionDfaAnalyzerProcessor.mergeElements(ContainerUtil.reverse(Arrays.asList(((FunctionReference)value).getParameters())), allowAmbiguous, inferAssignedValues);
        }
        return Collections.emptyMap();
    }

    private static Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> mergeElements(Collection<PsiElement> values, boolean allowAmbiguous, boolean inferAssignedValues) {
        HashMap<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> res = new HashMap<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>>();
        for (PsiElement value : values) {
            Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> unwrappedArrayElements = PhpPreviousFunctionDfaAnalyzerProcessor.doUnwrapMergedArrays(value, allowAmbiguous, inferAssignedValues);
            if (ContainerUtil.all(unwrappedArrayElements.values(), List::isEmpty) && value instanceof Variable && inferAssignedValues) {
                unwrappedArrayElements = PhpPreviousFunctionDfaAnalyzerProcessor.inferFromAssignedValues((Variable)value);
            }
            if (!allowAmbiguous && unwrappedArrayElements.isEmpty()) break;
            for (Map.Entry<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> e : unwrappedArrayElements.entrySet()) {
                res.computeIfAbsent(e.getKey(), k -> new ArrayList()).addAll((Collection)e.getValue());
            }
        }
        return res;
    }

    @NotNull
    private static Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> inferFromAssignedValues(final @NotNull Variable variable) {
        if (variable == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        final HashMap res = new HashMap();
        final Ref ambiguous = new Ref((Object)false);
        if (instruction != null) {
            PhpControlFlowUtil.processPredecessorsIgnoreBackEdges(instruction, false, new PhpInstructionProcessor(){

                @Override
                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    PsiElement assignedValue;
                    if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName()) && (assignedValue = ((PhpAccessVariableInstructionImpl)instruction).getAssignedValue()) != null) {
                        Map assignedScalarValues = EntryStream.of(PhpPreviousFunctionDfaAnalyzerProcessor.doUnwrapMergedArrays(assignedValue, true, false)).mapValues(v -> ContainerUtil.filter((Collection)v, e -> PhpPreviousFunctionDfaAnalyzerProcessor.isScalarValue((PsiElement)e.getKey()))).toMap();
                        res.putAll(assignedScalarValues);
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction);
                }

                @Override
                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    CharSequence baseName;
                    if (instruction.getAccess().isUnset() && PhpLangUtil.equalsVariableNames(baseName = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction), variable.getName())) {
                        ambiguous.set((Object)true);
                        this.haltTraversal();
                        return false;
                    }
                    return super.processArrayAccessInstruction(instruction);
                }

                @Override
                public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                    ambiguous.set((Object)true);
                    this.haltTraversal();
                    return super.processEntryPointInstruction(instruction);
                }
            });
        }
        Map<PhpDuplicateArrayKeysInspection.KeyDescriptor, List<ArrayHashElement>> map = (Boolean)ambiguous.get() != false ? Collections.emptyMap() : res;
        if (map == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        return map;
    }

    private static boolean isScalarValue(@Nullable PsiElement e) {
        return e instanceof StringLiteralExpression || PhpPsiUtil.isOfType(e, PhpElementTypes.NUMBER);
    }

    private boolean tryRegisterArrayKeyExistsFromAssignment(PhpArrayAccessInstruction instruction) {
        Boolean exists;
        if (!this.myInfo.getArgumentName().startsWith(ARRAY_KEY_EXISTS_SIGNATURE)) {
            return false;
        }
        PhpAccessInstruction.Access access = instruction.getAccess();
        Boolean bl = access.isWrite() ? Boolean.TRUE : (exists = access.isUnset() ? Boolean.FALSE : null);
        if (exists == null) {
            return false;
        }
        PhpPsiElement anchor = instruction.getAnchor();
        while (anchor instanceof ArrayAccessExpression && ((ArrayAccessExpression)anchor).getValue() instanceof ArrayAccessExpression) {
            anchor = ((ArrayAccessExpression)anchor).getValue();
        }
        return this.tryRegisterArrayKeyExistsFromAssignment(instruction, (ArrayAccessExpression)ObjectUtils.tryCast((Object)anchor, ArrayAccessExpression.class), exists);
    }

    private boolean tryRegisterArrayKeyExistsFromAssignment(PhpArrayAccessInstruction instruction, @Nullable ArrayAccessExpression anchor, @NotNull Boolean exists) {
        if (exists == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        if (anchor == null) {
            return false;
        }
        ArrayIndex index = anchor.getIndex();
        if (index != null) {
            PhpPsiElement indexValue = index.getValue();
            PhpPsiElement arrayAccessValue = anchor.getValue();
            if (indexValue == null || arrayAccessValue == null) {
                return false;
            }
            return this.tryRegisterArrayKeyExistsFromAssignment(instruction, (PsiElement)anchor, exists, (PsiElement)indexValue, (PsiElement)arrayAccessValue);
        }
        return false;
    }

    private boolean tryRegisterArrayKeyExistsFromAssignment(PhpInstruction instruction, @Nullable PsiElement anchor, @NotNull Boolean exists, @Nullable PsiElement indexValue, PsiElement arrayAccessValue) {
        if (exists == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        if (anchor == null || indexValue == null) {
            return false;
        }
        PhpStateArgumentInfo.PhpFunctionStateArgumentInfo arrayKeyExistsInfo = new PhpStateArgumentInfo.PhpFunctionStateArgumentInfo(ARRAY_KEY_EXISTS_SIGNATURE, Arrays.asList(indexValue, arrayAccessValue));
        if (arrayKeyExistsInfo.getArgumentName().equals(this.myInfo.getArgumentName())) {
            PhpDfaBasedFunctionAnalyzerProcessor.PhpFunctionDfaState state = new PhpDfaBasedFunctionAnalyzerProcessor.PhpFunctionDfaState(arrayKeyExistsInfo.getArgumentName(), exists == Boolean.TRUE ? PhpDfaBaseStateConditionDFAnalyzer.STRICT_ALWAYS_TRUE : PhpDfaBasedTypeState.ALWAYS_FALSE, arrayKeyExistsInfo);
            return !this.registerState(instruction, anchor.getTextRange(), state);
        }
        return false;
    }

    @Override
    protected PhpPreviousDfaAnalyzerProcessor createProcessor(TextRange outerRange) {
        return new PhpPreviousFunctionDfaAnalyzerProcessor(this.myProject, this.myArgumentName, this.myStopOnNegations, outerRange, this.myInfo, this.myCurrentState, this.myGlobal, (FunctionReference)this.myAnchor);
    }

    @Override
    @NotNull
    protected PhpPreviousDfaBaseStateConditionDFAnalyzer createAnalyzer(boolean stopOnNegations) {
        return new PhpDfaBasedFunctionAnalyzerProcessor.PhpFunctionDfaBaseStateConditionDFAnalyzer((FunctionReference)this.myAnchor, stopOnNegations, false, this.myGlobal);
    }

    private boolean doRegisterStateFromAssignedValueForStrlen(PhpInstruction instruction, @Nullable PsiElement value, @Nullable PsiElement variable) {
        if (variable != null) {
            PhpDfaBasedTypeState state;
            PhpStateArgumentInfo.PhpFunctionStateArgumentInfo strlenInfo = new PhpStateArgumentInfo.PhpFunctionStateArgumentInfo(STRLEN_SIGNATURE, Collections.singleton(variable));
            if (!strlenInfo.getArgumentName().equals(this.myInfo.getArgumentName())) {
                return false;
            }
            PhpDfaBasedTypeState phpDfaBasedTypeState = state = value != null ? PhpPreviousFunctionDfaAnalyzerProcessor.getStrLengthState(value) : null;
            if (state != null) {
                return !this.registerState(instruction, value.getTextRange(), new PhpDfaBasedFunctionAnalyzerProcessor.PhpFunctionDfaState(strlenInfo.getArgumentName(), state, strlenInfo));
            }
        }
        return false;
    }

    @Nullable
    private static PhpDfaBasedTypeState getStrLengthState(@NotNull PsiElement value) {
        PhpStrLengthEstimation estimation;
        if (value == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        if ((estimation = PhpPreviousFunctionDfaAnalyzerProcessor.estimateStringLength(value)) == null || estimation.myMinLength == 0) {
            return null;
        }
        return estimation.myAmbiguous ? new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ, estimation.myMinLength) : new PhpDfaDelegateBasedTypeState(" == strlen", new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.GREATER_EQ, estimation.myMinLength), new PhpRangeCheckDfaBasedTypeState.PhpIntRangeCheckDfaBasedTypeState(PhpRangeCheckDfaBasedTypeState.Operand.LOWER_EQ, estimation.myMinLength));
    }

    @Nullable
    public static PhpStrLengthEstimation estimateStringLength(@Nullable PsiElement value) {
        if (value == null) {
            return null;
        }
        return PhpPatterns.unwrapConcatenation(value).stream().map(PhpPreviousFunctionDfaAnalyzerProcessor::estimateStrLength).reduce(PhpStrLengthEstimation::union).orElse(null);
    }

    @NotNull
    private static PhpStrLengthEstimation estimateStrLength(PsiElement s) {
        if (s instanceof StringLiteralExpression) {
            StringLiteralExpression value = (StringLiteralExpression)s;
            if (!PhpStringUtil.isUnescapableText(value.getContents(), value.isSingleQuote())) {
                PhpStrLengthEstimation phpStrLengthEstimation = AMBIGUOUS_ESTIMATION;
                if (phpStrLengthEstimation == null) {
                    PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(6);
                }
                return phpStrLengthEstimation;
            }
            boolean singleQuote = value.isSingleQuote();
            if (singleQuote || PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations((PsiElement)value)) {
                String escapedContent = singleQuote ? value.getContents() : PhpPreviousFunctionDfaAnalyzerProcessor.escapeText(value.getContents());
                return new PhpStrLengthEstimation(escapedContent.length(), false);
            }
            return new PhpStrLengthEstimation(PhpPreviousFunctionDfaAnalyzerProcessor.countMinLength(value), true);
        }
        PhpStrLengthEstimation phpStrLengthEstimation = AMBIGUOUS_ESTIMATION;
        if (phpStrLengthEstimation == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(7);
        }
        return phpStrLengthEstimation;
    }

    private static int countMinLength(@NotNull StringLiteralExpression value) {
        if (value == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(8);
        }
        int minLength = 0;
        for (PsiElement child = value.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.STRING_LITERAL)) continue;
            minLength += PhpPreviousFunctionDfaAnalyzerProcessor.escapeText(child.getText()).length();
        }
        return minLength;
    }

    @NotNull
    private static String escapeText(@NotNull String contents) {
        if (contents == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(9);
        }
        String string = PhpReplaceQuotesIntention.escapeString(contents, '\'', '\"');
        if (string == null) {
            PhpPreviousFunctionDfaAnalyzerProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean registerStateFromAssignedValue(PhpInstruction instruction, @Nullable PsiElement value, @Nullable PsiElement variable) {
        String argumentName = this.myInfo.getArgumentName();
        if (argumentName.startsWith(ARRAY_KEY_EXISTS_SIGNATURE)) {
            return PhpPreviousFunctionDfaAnalyzerProcessor.doRegisterStateFromArrayKeyInInit(value, (Processor<? super ArrayHashElement>)((Processor)hashElement -> this.tryRegisterArrayKeyExistsFromAssignment(instruction, (PsiElement)hashElement.getKey(), true, (PsiElement)hashElement.getKey(), variable)));
        }
        if (argumentName.startsWith(STRLEN_SIGNATURE)) {
            return this.doRegisterStateFromAssignedValueForStrlen(instruction, value, variable);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/function/PhpPreviousFunctionDfaAnalyzerProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exists";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/function/PhpPreviousFunctionDfaAnalyzerProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "inferFromAssignedValues";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "estimateStrLength";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inferFromAssignedValues";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterArrayKeyExistsFromAssignment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStrLengthState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countMinLength";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 10 -> new IllegalStateException(string);
        };
    }

    public static class PhpStrLengthEstimation {
        private final int myMinLength;
        private final boolean myAmbiguous;

        private PhpStrLengthEstimation(int minLength, boolean ambiguous) {
            this.myMinLength = minLength;
            this.myAmbiguous = ambiguous;
        }

        public int getMinLength() {
            return this.myMinLength;
        }

        @NotNull
        private static PhpStrLengthEstimation union(@NotNull PhpStrLengthEstimation a, @NotNull PhpStrLengthEstimation b) {
            if (a == null) {
                PhpStrLengthEstimation.$$$reportNull$$$0(0);
            }
            if (b == null) {
                PhpStrLengthEstimation.$$$reportNull$$$0(1);
            }
            return new PhpStrLengthEstimation(a.myMinLength + b.myMinLength, a.myAmbiguous || b.myAmbiguous);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "a";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "b";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/controlFlow/constantCondition/function/PhpPreviousFunctionDfaAnalyzerProcessor$PhpStrLengthEstimation";
            objectArray[2] = "union";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

