/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.controlFlow.dfa;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpInferredArrayEmptinessProcessorBase;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import org.jetbrains.annotations.Nullable;

public class PhpInferredFieldArrayEmptinessProcessor
extends PhpInferredArrayEmptinessProcessorBase<PhpAccessFieldByVariableInstruction> {
    private final FieldReference myElement;
    private final Variable myVariableClassReference;
    private final PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor myDelegateProcessor;

    public PhpInferredFieldArrayEmptinessProcessor(Ref<PhpInstruction> alwaysEmpty, Ref<Boolean> ambiguous, PhpAccessFieldByVariableInstruction original, FieldReference element, Variable variableClassReference) {
        super(alwaysEmpty, ambiguous, original);
        this.myElement = element;
        this.myVariableClassReference = variableClassReference;
        this.myDelegateProcessor = new PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor(element.getName(), variableClassReference, element);
    }

    @Override
    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
        FieldReference fieldReference = instruction.getFieldReference();
        if (this.sameElement((PsiElement)fieldReference) && PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor.isModifyingInstruction(instruction)) {
            PsiElement value = PhpInferredFieldArrayEmptinessProcessor.getAssignedValue(fieldReference);
            if (value instanceof ArrayCreationExpression && ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).isEmpty()) {
                this.myAlwaysEmpty.set((Object)instruction);
            } else {
                this.myAmbiguous.set((Object)true);
                this.haltTraversal();
            }
            return false;
        }
        return super.processAccessFieldByVariableInstruction(instruction);
    }

    @Override
    protected boolean sameElement(PsiElement anchor) {
        return anchor instanceof FieldReference && PhpFieldArrayEmptinessDfaBasedAnalyzerProcessor.sameFieldReference(this.myVariableClassReference, this.myElement.getName(), (FieldReference)anchor);
    }

    private static PsiElement getAssignedValue(@Nullable FieldReference reference) {
        PsiElement parent = reference != null ? reference.getParent() : null;
        return parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == reference ? ((AssignmentExpression)parent).getValue() : null;
    }

    @Override
    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        if (!this.myDelegateProcessor.processAccessVariableInstruction(instruction)) {
            this.myAmbiguous.set((Object)true);
            this.haltTraversal();
            return false;
        }
        return true;
    }

    @Override
    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
        if (!this.myDelegateProcessor.processPhpCallInstruction(instruction)) {
            this.myAmbiguous.set((Object)true);
            this.haltTraversal();
            return false;
        }
        return true;
    }

    @Override
    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        this.myAmbiguous.set((Object)true);
        this.haltTraversal();
        return super.processEntryPointInstruction(instruction);
    }
}

