/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.local;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationPresentation;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsCache;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsFilterVisitor;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsInspection;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.inspections.reference.util.PhpRefScopeUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnusedGlobalSymbolsPass
extends TextEditorHighlightingPass {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpUnusedSymbolsInspection.QUICK_FIX};
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final List<PsiElement> myUnusedSymbols;

    PhpUnusedGlobalSymbolsPass(@NotNull PsiFile file, @NotNull Document document) {
        if (file == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(1);
        }
        super(file.getProject(), document);
        this.myUnusedSymbols = new SmartList();
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(2);
        }
        if (!HighlightingLevelManager.getInstance((Project)this.myProject).shouldInspect((PsiElement)this.myFile)) {
            return;
        }
        Set candidates = (Set)CachedValuesManager.getCachedValue((PsiElement)this.myFile, PhpUnusedSymbolsInspection.DEFINITIONS_TO_PROCESS_KEY, PhpUnusedSymbolsInspection.getCachedSet(this.myFile));
        Collection<PsiElement> unusedSymbols = PhpUnusedGlobalSymbolsPass.collectUnusedSymbols(this.myProject, this.myFile, candidates);
        this.myUnusedSymbols.addAll(unusedSymbols);
    }

    public static boolean isSymbolUnused(@NotNull PhpNamedElement symbol) {
        if (symbol == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(3);
        }
        return PhpUnusedGlobalSymbolsPass.collectUnusedSymbols(symbol.getProject(), symbol.getContainingFile(), Collections.singleton(symbol)).contains(symbol);
    }

    @NotNull
    private static Collection<PsiElement> collectUnusedSymbols(@NotNull Project project, @NotNull PsiFile file, @NotNull Collection<? extends PsiElement> candidates) {
        PhpUnusedDeclarationInspection globalInspectionTool;
        if (project == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(6);
        }
        if ((globalInspectionTool = PhpUnusedSymbolsInspection.getPhpDeadCodeGlobalTool(project, file)) == null || !PhpUnusedSymbolsInspection.isDeadCodeEnabled(project, file)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(7);
            }
            return list;
        }
        List filteredCandidates = ContainerUtil.filter(candidates, candidate -> !PhpUnusedGlobalSymbolsPass.isCandidateSuppressed(candidate, globalInspectionTool));
        return PhpUnusedGlobalSymbolsPass.searchForUnusedSymbols(file, filteredCandidates);
    }

    private static boolean isCandidateSuppressed(@NotNull PsiElement candidate, @NotNull PhpUnusedDeclarationInspection inspectionTool) {
        if (candidate == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(8);
        }
        if (inspectionTool == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(9);
        }
        return inspectionTool.isSuppressedFor(candidate) || !PhpUnusedDeclarationPresentation.compareVisibilities((UserDataHolder)candidate, inspectionTool.getMembersToReportPanel()) || PhpUnusedDeclarationPresentation.acceptedByPatterns(candidate, inspectionTool);
    }

    public void doApplyInformationToEditor() {
        TextRange dirtyScope = this.getDirtyScope();
        PhpUnusedDeclarationInspection globalInspectionTool = PhpUnusedSymbolsInspection.getPhpDeadCodeGlobalTool(this.myProject, this.myFile);
        if (globalInspectionTool == null || dirtyScope == null) {
            return;
        }
        ArrayList infos = new ArrayList(this.myUnusedSymbols.size());
        HighlightSeverity severity = PhpUnusedSymbolsInspection.getPhpDeadCodeSeverity(this.myProject, (PsiElement)this.myFile);
        if (severity != HighlightSeverity.INFORMATION) {
            this.convertUnusedSymbolsToHighlightInfo(severity, infos);
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)dirtyScope.getStartOffset(), (int)dirtyScope.getEndOffset(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private void convertUnusedSymbolsToHighlightInfo(@NotNull HighlightSeverity severity, @NotNull List<? super HighlightInfo> infos) {
        if (severity == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(10);
        }
        if (infos == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(11);
        }
        for (PsiElement unusedSymbol : this.myUnusedSymbols) {
            PhpUnusedSymbolProblemDescriptor unused = PhpUnusedGlobalSymbolsPass.registerProblem(unusedSymbol);
            if (unused == null) continue;
            HighlightInfo.Builder info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.UNUSED_SYMBOL).range(unused.myIdentifier).descriptionAndTooltip(unused.myMessage).severity(severity);
            ProblemDescriptorBase problemDescriptor = new ProblemDescriptorBase(unused.myIdentifier, unused.myIdentifier, unused.myMessage, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            HighlightDisplayKey toolKey = HighlightDisplayKey.find((String)"PhpUnused");
            if (toolKey == null) continue;
            for (LocalQuickFix quickFix : unused.myFixes) {
                info.registerFix(QuickFixWrapper.wrap((ProblemDescriptor)problemDescriptor, (LocalQuickFix)quickFix), null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)toolKey), null, toolKey);
            }
            HighlightInfo highlightInfo = info.create();
            if (highlightInfo == null) continue;
            infos.add((HighlightInfo)highlightInfo);
        }
    }

    @Nullable
    private TextRange getDirtyScope() {
        return DaemonCodeAnalyzerEx.getInstanceEx((Project)this.myProject).getFileStatusMap().getFileDirtyScope(this.myDocument, this.myFile, this.getId());
    }

    @NotNull
    private static Collection<PsiElement> searchForUnusedSymbols(@NotNull PsiFile file, @NotNull Collection<? extends PsiElement> candidates) {
        if (file == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(12);
        }
        if (candidates == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(13);
        }
        UnusedElementsData unusedElementsData = new UnusedElementsData(file);
        PhpUnusedSymbolsFilterVisitor inspectionVisitor = new PhpUnusedSymbolsFilterVisitor(unusedElementsData::addProcessedCandidate);
        for (PsiElement psiElement : candidates) {
            psiElement.accept((PsiElementVisitor)inspectionVisitor);
        }
        unusedElementsData.searchForCandidateReferencingFiles();
        unusedElementsData.searchInCandidateFiles();
        unusedElementsData.nullizeReferencesForRemainingCandidates();
        Collection<PsiElement> collection = unusedElementsData.getUnusedElementsToReport();
        if (collection == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @Nullable
    private static String getNameToSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(15);
        }
        if (elementToSearch instanceof PhpNamedElement) {
            return ((PhpNamedElement)elementToSearch).getName();
        }
        Logger.getInstance(PhpUnusedSymbolsFilterVisitor.class).error("Unknown element passed: " + elementToSearch.getClass().getSimpleName());
        return null;
    }

    @Nullable
    private static GlobalSearchScope getScopeForSearch(@NotNull PsiElement elementToSearch) {
        if (elementToSearch == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(16);
        }
        Project project = elementToSearch.getProject();
        VirtualFile virtualFile = elementToSearch.getContainingFile().getVirtualFile();
        if (virtualFile == null || ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibrary(virtualFile) || PhpRefScopeUtil.isByBuiltInLibrary(virtualFile)) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return PhpRefScopeUtil.getReferencesSearchScope(scope);
    }

    @Nullable
    private static PhpUnusedSymbolProblemDescriptor registerProblem(@NotNull PsiElement element) {
        if (element == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(17);
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.VARIABLE, PhpTokenTypes.IDENTIFIER)) {
            return null;
        }
        PhpNamedElement namedElement = PhpPsiUtil.getParentOfClass(element, PhpNamedElement.class);
        if (namedElement == null) {
            return null;
        }
        return new PhpUnusedSymbolProblemDescriptor(element, PhpBundle.message("inspection.group.unused.quickfix.message", namedElement.getName()), PhpUnusedGlobalSymbolsPass.getFixes(namedElement));
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] getFixes(PhpNamedElement namedElement) {
        Collection<String> tags = PhpUnusedDeclarationPresentation.getCustomDocTags(namedElement);
        if (tags.isEmpty()) {
            if (FIXES == null) {
                PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(18);
            }
            return FIXES;
        }
        List<LocalQuickFix> fixes = tags.stream().map(PhpSuppressDocTagQuickFix::new).limit(10L).collect(Collectors.toList());
        fixes.add(PhpUnusedSymbolsInspection.QUICK_FIX);
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpUnusedGlobalSymbolsPass.$$$reportNull$$$0(19);
        }
        return localQuickFixArray;
    }

    @Nullable
    public static String extractTwigShortName(PsiElement element) {
        Method method = (Method)ObjectUtils.tryCast((Object)element, Method.class);
        if (method == null) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.length() > 2 && methodName.startsWith("is")) {
            return StringUtil.decapitalize((String)methodName.substring(2));
        }
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("has"))) {
            return StringUtil.decapitalize((String)methodName.substring(3));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnusedSymbols";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForUnusedSymbols";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSymbolUnused";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectUnusedSymbols";
                break;
            }
            case 7: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCandidateSuppressed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertUnusedSymbolsToHighlightInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchForUnusedSymbols";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNameToSearch";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getScopeForSearch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 14, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static class PhpUnusedSymbolProblemDescriptor {
        @NotNull
        public final PsiElement myIdentifier;
        @NotNull
        public final @NlsContexts.DetailedDescription String myMessage;
        @NotNull
        public final @NotNull LocalQuickFix @NotNull [] myFixes;

        PhpUnusedSymbolProblemDescriptor(@NotNull PsiElement nameIdentifier, @NotNull @NlsContexts.DetailedDescription String message, LocalQuickFix ... fixes) {
            if (nameIdentifier == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(0);
            }
            if (message == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(1);
            }
            if (fixes == null) {
                PhpUnusedSymbolProblemDescriptor.$$$reportNull$$$0(2);
            }
            this.myIdentifier = nameIdentifier;
            this.myMessage = message;
            this.myFixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "nameIdentifier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpUnusedSymbolProblemDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnusedElementsData {
        @NotNull
        private final BidirectionalMap<PsiElement, PsiElement> processedCandidates;
        @NotNull
        private final MultiMap<VirtualFile, PsiElement> candidateReferencingFiles;
        @NotNull
        private final Set<PsiElement> definitelyUnusedElementsToReport;
        @NotNull
        private final PsiFile myFile;

        UnusedElementsData(@NotNull PsiFile baseFile) {
            if (baseFile == null) {
                UnusedElementsData.$$$reportNull$$$0(0);
            }
            this.processedCandidates = new BidirectionalMap();
            this.candidateReferencingFiles = MultiMap.create();
            this.definitelyUnusedElementsToReport = new HashSet<PsiElement>();
            this.myFile = baseFile;
        }

        private void addProcessedCandidate(@NotNull PsiElement elementToSearch, @Nullable PsiElement elementToReport) {
            if (elementToSearch == null) {
                UnusedElementsData.$$$reportNull$$$0(1);
            }
            if (elementToReport != null) {
                this.processedCandidates.put((Object)elementToReport, (Object)elementToSearch);
            }
        }

        private void searchForCandidateReferencingFiles() {
            HashSet<PsiElement> definitelyUsedElementsToReport = new HashSet<PsiElement>();
            for (Map.Entry elementEntry : this.processedCandidates.entrySet()) {
                PsiElement elementToReport = (PsiElement)elementEntry.getKey();
                PsiElement elementToSearch = (PsiElement)elementEntry.getValue();
                ThreeState isUsed = PhpUnusedSymbolsCache.isUsedImplicitlyOrFromCache(elementToSearch);
                if (isUsed == ThreeState.YES || isUsed == ThreeState.NO) {
                    if (isUsed == ThreeState.YES) {
                        definitelyUsedElementsToReport.add(elementToReport);
                        continue;
                    }
                    this.definitelyUnusedElementsToReport.add(elementToReport);
                    continue;
                }
                GlobalSearchScope scope = PhpUnusedGlobalSymbolsPass.getScopeForSearch(elementToSearch);
                String name = PhpUnusedGlobalSymbolsPass.getNameToSearch(elementToSearch);
                if (scope == null || name == null) {
                    definitelyUsedElementsToReport.add(elementToReport);
                    continue;
                }
                this.processCandidatesFilesForText(name, elementToSearch, elementToReport, scope, definitelyUsedElementsToReport);
                String twigShortName = PhpUnusedGlobalSymbolsPass.extractTwigShortName(elementToSearch);
                if (!StringUtil.isNotEmpty((String)twigShortName)) continue;
                TwigScope twigScope = new TwigScope(scope);
                this.processCandidatesFilesForText(twigShortName, elementToSearch, elementToReport, (GlobalSearchScope)twigScope, definitelyUsedElementsToReport);
            }
            this.removeCandidateElementsToProcess(this.definitelyUnusedElementsToReport);
            this.removeCandidateElementsToProcess(definitelyUsedElementsToReport);
        }

        private void processCandidatesFilesForText(String text, PsiElement elementToSearch, PsiElement elementToReport, GlobalSearchScope scope, Set<PsiElement> definitelyUsedElementsToReport) {
            PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)this.myFile.getProject());
            if (helper.isCheapEnoughToSearch(text, scope, this.myFile) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                definitelyUsedElementsToReport.add(elementToReport);
            } else {
                helper.processCandidateFilesForText(scope, (short)255, true, text, virtualFile -> {
                    this.candidateReferencingFiles.putValue(virtualFile, (Object)elementToSearch);
                    return true;
                });
            }
        }

        private void removeCandidateElementsToProcess(@Nullable Collection<PsiElement> elementsToReport) {
            if (elementsToReport != null) {
                elementsToReport.forEach(arg_0 -> this.processedCandidates.remove(arg_0));
            }
        }

        private void searchInCandidateFiles() {
            PsiManager manager = this.myFile.getManager();
            for (Map.Entry entry : this.candidateReferencingFiles.entrySet()) {
                PsiFile candidateReferencingFile;
                Collection elementsToSearch = (Collection)entry.getValue();
                elementsToSearch.retainAll(this.processedCandidates.values());
                if (elementsToSearch.isEmpty() || (candidateReferencingFile = manager.findFile((VirtualFile)entry.getKey())) == null) continue;
                this.searchAndCacheReferences(elementsToSearch, candidateReferencingFile);
            }
        }

        private void searchAndCacheReferences(@NotNull Collection<? extends PsiElement> elementsToSearch, @NotNull PsiFile psiFile) {
            if (elementsToSearch == null) {
                UnusedElementsData.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                UnusedElementsData.$$$reportNull$$$0(3);
            }
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)psiFile);
            for (PsiElement psiElement : elementsToSearch) {
                PsiReference reference = PhpUnusedSymbolsCache.findAnyReference(psiElement, (SearchScope)fileScope);
                if (reference == null) continue;
                PhpUnusedSymbolsCache.saveFoundReference(reference, psiElement);
                this.removeCandidateElementsToProcess(this.processedCandidates.getKeysByValue((Object)psiElement));
            }
        }

        @NotNull
        private Collection<PsiElement> getUnusedElementsToReport() {
            ArrayList<PsiElement> unusedElements = new ArrayList<PsiElement>();
            unusedElements.addAll(this.definitelyUnusedElementsToReport);
            unusedElements.addAll(this.processedCandidates.keySet());
            ArrayList<PsiElement> arrayList = unusedElements;
            if (arrayList == null) {
                UnusedElementsData.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private void nullizeReferencesForRemainingCandidates() {
            for (PsiElement elementToSearch : this.processedCandidates.values()) {
                PhpUnusedSymbolsCache.saveFoundReference(null, elementToSearch);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementsToSearch";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$UnusedElementsData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$UnusedElementsData";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedElementsToReport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addProcessedCandidate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "searchAndCacheReferences";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PhpSuppressDocTagQuickFix
    implements LocalQuickFix {
        private final String myTagName;

        private PhpSuppressDocTagQuickFix(String tagName) {
            this.myTagName = tagName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("suppress.if.annotated.by.tag", this.myTagName);
            if (string == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(2);
            }
            PhpEntryPointsManagerImpl manager = (PhpEntryPointsManagerImpl)PhpEntryPointsManager.getProjectInstance(project);
            manager.getSuppressedAnnotations().add(this.myTagName);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                PhpSuppressDocTagQuickFix.$$$reportNull$$$0(4);
            }
            return new IntentionPreviewInfo.Html(HtmlChunk.text((String)PhpBundle.message("suppress.unused.preview", this.myTagName)));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpSuppressDocTagQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$PhpSuppressDocTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class TwigScope
    extends DelegatingGlobalSearchScope {
        public TwigScope(@NotNull GlobalSearchScope baseScope) {
            if (baseScope == null) {
                TwigScope.$$$reportNull$$$0(0);
            }
            super(baseScope);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                TwigScope.$$$reportNull$$$0(1);
            }
            if (!super.contains(file)) {
                return false;
            }
            return file.getFileType().getName().equals("Twig");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseScope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/local/PhpUnusedGlobalSymbolsPass$TwigScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

