/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.magicDeclaration;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicHandler;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMagicAdditionalInvokeProvider
implements PhpMagicHandler {
    @NotNull
    public static final String INVOKE = "__invoke";
    @NotNull
    public static final String CLONE_DECL = "__clone";
    @NotNull
    public static final String SET_STATE = "__set_state";
    @NotNull
    public static final String DEBUG_INFO = "__debugInfo";
    @NotNull
    public static final String VAR_DUMP = "var_dump";
    @NotNull
    public static final String CLONE = "clone";
    @NotNull
    public static final String VAR_EXPORT = "var_export";
    @NotNull
    public static final Set<String> HANDLERS = ContainerUtil.newHashSet((Object[])new String[]{"__invoke", "__set_state", "__clone", "__debugInfo"});
    @NotNull
    public static final Set<String> INVOCATORS = ContainerUtil.newHashSet((Object[])new String[]{"var_dump", "clone", "var_export"});

    @Override
    public boolean accept(@NotNull String magicMethodName) {
        if (magicMethodName == null) {
            PhpMagicAdditionalInvokeProvider.$$$reportNull$$$0(0);
        }
        return HANDLERS.contains(magicMethodName);
    }

    @Override
    public int getReferencedHash(@Nullable PhpExpression classReference, @Nullable PhpPsiElement referenceContext, boolean isForWrite, boolean isForRead) {
        if (referenceContext != null) {
            String referenceName = referenceContext.getName();
            if (referenceName != null) {
                return switch (referenceName) {
                    case "" -> 512;
                    case VAR_DUMP -> 2048;
                    case VAR_EXPORT -> 512;
                    default -> 0;
                };
            }
            if (referenceContext instanceof UnaryExpression && PhpPsiUtil.isOfType((PsiElement)referenceContext, PhpElementTypes.CLONE_EXPRESSION)) {
                return 1024;
            }
        }
        return 0;
    }

    @Override
    public int getReferencedHash(@NotNull PhpRefMethod methodDeclaration) {
        if (methodDeclaration == null) {
            PhpMagicAdditionalInvokeProvider.$$$reportNull$$$0(1);
        }
        return this.getReferencedHash(methodDeclaration.getName());
    }

    @Override
    public int getReferencedHash(@NotNull String name) {
        if (name == null) {
            PhpMagicAdditionalInvokeProvider.$$$reportNull$$$0(2);
        }
        return switch (name) {
            case INVOKE -> 512;
            case CLONE_DECL -> 1024;
            case SET_STATE -> 512;
            case DEBUG_INFO -> 2048;
            default -> 0;
        };
    }

    @Override
    public boolean accept(@Nullable PhpPsiElement magicMethodContext, @Nullable PhpExpression phpExpression, @Nullable Collection<PhpRefMethod> functionDeclarations) {
        boolean isCallable = magicMethodContext instanceof FunctionReference;
        if (isCallable && phpExpression != null) {
            Project project = magicMethodContext.getProject();
            for (String typeName : phpExpression.getType().getTypes()) {
                boolean isPrimitiveType = PhpType.isPrimitiveType(typeName) && !PhpLangUtil.isSpecialPrimitiveType(typeName, project);
                String functionReferenceName = magicMethodContext.getName();
                if (isPrimitiveType || functionReferenceName == null) continue;
                boolean accepted = functionReferenceName.isEmpty();
                if (!accepted) {
                    accepted = INVOCATORS.contains(functionReferenceName);
                }
                return accepted;
            }
        } else if (magicMethodContext instanceof UnaryExpression && PhpPsiUtil.isOfType((PsiElement)magicMethodContext, PhpElementTypes.CLONE_EXPRESSION)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magicMethodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/magicDeclaration/PhpMagicAdditionalInvokeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencedHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

