/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.deadcode.magicDeclaration;

import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicHandler;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMagicContext {
    @NotNull
    private static final Set<String> MAGIC_SEARCHABLE_METHODS = Set.of("__invoke", "__construct");
    @NotNull
    public static final TokenSet classExpressionContextToken = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpElementTypes.UNARY_EXPRESSIONS, TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.NEW_EXPRESSION, PhpElementTypes.FUNCTION_CALL, PhpElementTypes.ASSIGNMENT_EXPRESSION, PhpElementTypes.SELF_ASSIGNMENT_EXPRESSION, PhpElementTypes.PRINT_EXPRESSION, PhpElementTypes.ECHO, PhpElementTypes.CAST_EXPRESSION, PhpElementTypes.USE_LIST, PhpElementTypes.UNSET, PhpElementTypes.ISSET_EXPRESSION, PhpElementTypes.IF, PhpElementTypes.ELSE_IF, PhpElementTypes.FOREACH, PhpElementTypes.FOR, PhpElementTypes.SWITCH, PhpElementTypes.WHILE, PhpElementTypes.TRY, PhpElementTypes.CATCH, PhpElementTypes.RETURN, PhpElementTypes.YIELD})});
    public static final int IS_MAGIC_CREATION_REFERENCED = 1;
    public static final int IS_MAGIC_CALL_REFERENCED = 2;
    public static final int IS_MAGIC_STATIC_CALL_REFERENCED = 4;
    public static final int IS_MAGIC_GET_REFERENCED = 8;
    public static final int IS_MAGIC_SET_REFERENCED = 16;
    public static final int IS_MAGIC_ISSET_REFERENCED = 32;
    public static final int IS_MAGIC_UNSET_REFERENCED = 64;
    public static final int IS_MAGIC_SERIALIZATION_REFERENCED = 128;
    public static final int IS_MAGIC_OUTPUT_REFERENCED = 256;
    public static final int IS_MAGIC_INVOKE_REFERENCED = 512;
    public static final int IS_MAGIC_SET_STATE_REFERENCED = 512;
    public static final int IS_MAGIC_CLONE_REFERENCED = 1024;
    public static final int IS_MAGIC_DEBUG_REFERENCED = 2048;
    public static final int IS_MAGIC_UNSERIALIZE_REFERENCED = 4096;

    public static void markMagicDeclarations(int magicMethodHash, @NotNull PhpExpression phpExpression, @NotNull RefManager refManager) {
        if (phpExpression == null) {
            PhpMagicContext.$$$reportNull$$$0(0);
        }
        if (refManager == null) {
            PhpMagicContext.$$$reportNull$$$0(1);
        }
        Project project = phpExpression.getProject();
        PhpIndex phpIndex = PhpIndex.getInstance(project);
        StreamEx.of(phpExpression.getGlobalType().getTypes()).flatMap(fqn -> StreamEx.of(phpIndex.getAnyByFQN((String)fqn))).map(phpClass -> PhpRefUtil.getReferenceEx((PsiElement)phpClass, (RefManagerImpl)refManager)).select(PhpRefClass.class).forEach(refElement -> refElement.setMagicMethodReferenced(magicMethodHash));
    }

    public static boolean isMagicDeclarationReferenced(@NotNull String refMethod, int magicMethodsHash) {
        PhpMagicHandler provider;
        if (refMethod == null) {
            PhpMagicContext.$$$reportNull$$$0(2);
        }
        if ((provider = PhpMagicContext.getMagicProvider(refMethod)) != null) {
            return (provider.getReferencedHash(refMethod) & magicMethodsHash) > 0;
        }
        return false;
    }

    public static int getMagicDeclarationHash(@NotNull String refMethod) {
        PhpMagicHandler provider;
        if (refMethod == null) {
            PhpMagicContext.$$$reportNull$$$0(3);
        }
        if ((provider = PhpMagicContext.getMagicProvider(refMethod)) != null) {
            return provider.getReferencedHash(refMethod);
        }
        return 0;
    }

    @Nullable
    public static PhpMagicHandler getMagicProvider(@NotNull String magicName) {
        if (magicName == null) {
            PhpMagicContext.$$$reportNull$$$0(4);
        }
        if (!PhpLangUtil.isMagicMethod(magicName)) {
            return null;
        }
        return (PhpMagicHandler)ContainerUtil.find((Object[])((PhpMagicHandler[])PhpMagicHandler.EP_NAME.getExtensions()), handler -> handler.accept(magicName));
    }

    @Nullable
    public static PhpMagicHandler getMagicProvider(@NotNull PhpExpression classExpression, PhpPsiElement magicContext, @Nullable Collection<PhpRefMethod> functionDeclarations) {
        if (classExpression == null) {
            PhpMagicContext.$$$reportNull$$$0(5);
        }
        return (PhpMagicHandler)ContainerUtil.find((Object[])((PhpMagicHandler[])PhpMagicHandler.EP_NAME.getExtensions()), handler -> handler.accept(magicContext, classExpression, functionDeclarations));
    }

    @Nullable
    public static PhpPsiElement getMagicMethodContext(@NotNull PhpPsiElement classExpression) {
        if (classExpression == null) {
            PhpMagicContext.$$$reportNull$$$0(6);
        }
        return PhpMagicContext.getMagicMethodContext(classExpression, classExpressionContextToken);
    }

    @Nullable
    public static PhpPsiElement getMagicMethodContext(@NotNull PhpPsiElement classExpression, @NotNull TokenSet tokenSet) {
        if (classExpression == null) {
            PhpMagicContext.$$$reportNull$$$0(7);
        }
        if (tokenSet == null) {
            PhpMagicContext.$$$reportNull$$$0(8);
        }
        return (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)classExpression, (Condition<? super PsiElement>)((Condition)psiElement -> PhpPsiUtil.isOfType(psiElement, tokenSet)), (Condition<? super PsiElement>)((Condition)psiElement -> psiElement instanceof PhpClass || psiElement instanceof PhpScopeHolder));
    }

    public static boolean isMagicMethodReferenced(@NotNull PhpRefMethod refMethod, @NotNull String methodName) {
        PhpMagicHandler magicHandler;
        if (refMethod == null) {
            PhpMagicContext.$$$reportNull$$$0(9);
        }
        if (methodName == null) {
            PhpMagicContext.$$$reportNull$$$0(10);
        }
        if ((magicHandler = PhpMagicContext.getMagicProvider(methodName)) != null) {
            return magicHandler.isReferencedByMagic(refMethod, magicHandler.getReferencedHash(refMethod));
        }
        return false;
    }

    public static boolean canHaveExternalReferences(@NotNull PhpRefMethod refMethod) {
        String name;
        if (refMethod == null) {
            PhpMagicContext.$$$reportNull$$$0(11);
        }
        return !PhpLangUtil.isMagicMethod(name = refMethod.getName()) || MAGIC_SEARCHABLE_METHODS.contains(name) && !PhpMagicContext.isMagicMethodReferenced(refMethod, name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magicName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/deadcode/magicDeclaration/PhpMagicContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markMagicDeclarations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMagicDeclarationReferenced";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMagicDeclarationHash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMagicProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getMagicMethodContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isMagicMethodReferenced";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canHaveExternalReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

