/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.parameterCountMismatch;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureManuallyQuickFix;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureReversePassFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureHandler;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeFunctionSignatureFromUsageQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @IntentionName
    private String myText;

    public PhpChangeFunctionSignatureFromUsageQuickFix(@Nullable PsiElement element) {
        super(element);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        ParameterListOwner argumentsList;
        if (project == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(3);
        }
        if ((argumentsList = PhpPsiUtil.getParentOfClass(startElement, false, ParameterListOwner.class)) == null) {
            return false;
        }
        Object[] arguments = argumentsList.getParameters();
        List argumentTypes = ContainerUtil.map((Object[])arguments, PhpChangeFunctionSignatureFromUsageQuickFix::getArgumentType);
        if (argumentTypes.stream().anyMatch(PhpType::isAmbiguous)) {
            return false;
        }
        Function function = (Function)ContainerUtil.getFirstItem(PhpWorkaroundUtil.resolveTargetFunctions((PsiElement)argumentsList));
        if (!PhpChangeFunctionSignatureFromUsageQuickFix.supportChangeSignature(function)) {
            return false;
        }
        Parameter[] parameters = function.getParameters();
        if (Arrays.stream(parameters).anyMatch(parameter -> parameter.isVariadic() || parameter.isOptional())) {
            return false;
        }
        String text = this.createTextIfChangeIsPossible((PsiElement[])arguments, parameters, function, argumentTypes);
        if (text == null) {
            return false;
        }
        this.myText = text;
        return super.isAvailable(project, file, editor, startElement, endElement);
    }

    @Contract(value="null -> false")
    public static boolean supportChangeSignature(@Nullable Function function) {
        return function != null && !(function instanceof PhpDocMethod) && !function.isClosure();
    }

    @Nullable
    @IntentionName
    protected String createTextIfChangeIsPossible(PsiElement[] arguments, Parameter[] parameters, Function function, List<PhpType> argumentTypes) {
        HashMap<Integer, Parameter> removedParameters = new HashMap<Integer, Parameter>();
        HashMap<Integer, PhpParameterInfo> introducedParameters = new HashMap<Integer, PhpParameterInfo>();
        SmartList resultParameters = new SmartList();
        if (!this.collectChangedParametersIfPossible(arguments, argumentTypes, parameters, removedParameters, introducedParameters, (List<PhpParameterInfo>)resultParameters)) {
            return null;
        }
        return PhpChangeFunctionSignatureFromUsageQuickFix.createTextIfChangeIsPossible(function, parameters, removedParameters.values(), introducedParameters.values(), (List<PhpParameterInfo>)resultParameters);
    }

    @NotNull
    @IntentionName
    private static String createTextIfChangeIsPossible(Function function, Parameter[] parameters, Collection<Parameter> removedParameters, Collection<PhpParameterInfo> introducedParameters, List<PhpParameterInfo> resultParameters) {
        Collection<String> parts = !removedParameters.isEmpty() ? PhpChangeFunctionSignatureFromUsageQuickFix.getDescriptionPartsWithRemovedParameters(parameters, removedParameters) : PhpChangeFunctionSignatureFromUsageQuickFix.getDescriptionPartsWithIntroducedParameters(introducedParameters, resultParameters);
        String string = HtmlChunk.raw((String)PhpBundle.message("intention.name.change.signature", function.getName(), String.join((CharSequence)", ", parts))).wrapWith("html").toString();
        if (string == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        ParameterList argumentsList;
        if (project == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(8);
        }
        if ((argumentsList = (ParameterList)ObjectUtils.tryCast((Object)startElement, ParameterList.class)) == null) {
            return;
        }
        Function function = PhpChangeSignatureHandler.getSuperMethod((Function)ContainerUtil.getFirstItem(PhpWorkaroundUtil.resolveTargetFunctions(argumentsList.getParent())));
        if (function == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(function.getContainingFile())) {
            return;
        }
        Parameter[] parameters = function.getParameters();
        HashMap<Integer, Parameter> removedParameters = new HashMap<Integer, Parameter>();
        HashMap<Integer, PhpParameterInfo> introducedParameters = new HashMap<Integer, PhpParameterInfo>();
        SmartList resultParameters = new SmartList();
        this.collectChangedParametersIfPossible(argumentsList.getParameters(), parameters, removedParameters, introducedParameters, (List<PhpParameterInfo>)resultParameters);
        PhpChangeInfo info = PhpChangeFunctionSignatureFromUsageQuickFix.onlyParametersChangedInfo(function, resultParameters.toArray(new PhpParameterInfo[0]));
        if (PhpChangeFunctionSignatureFromUsageQuickFix.changeFunctionSignature(project, function, info) || editor == null) {
            return;
        }
        final Integer singleIntroducedIndex = (Integer)ContainerUtil.getOnlyItem(introducedParameters.keySet());
        PhpChangeSignatureDialog dialog = new PhpChangeSignatureDialog(project, new PhpMethodDescriptor(function), (PsiElement)argumentsList){

            protected int getSelectedIdx() {
                return singleIntroducedIndex != null ? singleIntroducedIndex.intValue() : super.getSelectedIdx();
            }
        };
        dialog.setParameterInfos((List)resultParameters);
        dialog.show();
    }

    public static boolean changeFunctionSignature(@NotNull Project project, Function function, PhpChangeInfo info) {
        Collection<UsageInfo> usages;
        if (project == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(9);
        }
        if ((usages = PhpChangeFunctionSignatureFromUsageQuickFix.getUsages(project, info)) == null) {
            return true;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || usages.isEmpty() || !info.isParameterSetOrOrderChanged()) {
            MultiMap descriptions = MultiMap.create();
            ChangeSignatureProcessorBase.collectConflictsFromExtensions((Ref)new Ref((Object)usages.toArray(UsageInfo.EMPTY_ARRAY)), (MultiMap)descriptions, (ChangeInfo)info);
            if (!PhpChangeFunctionSignatureFromUsageQuickFix.showConflicts(project, (MultiMap<PsiElement, String>)descriptions)) {
                return true;
            }
            WriteAction.run(() -> PhpChangeSignatureUsageProcessor.processFunctionDeclaration(info, function));
            return true;
        }
        return false;
    }

    private static boolean showConflicts(Project project, MultiMap<PsiElement, String> descriptions) {
        if (descriptions.isEmpty()) {
            return true;
        }
        return new ConflictsDialog(project, descriptions).showAndGet();
    }

    @NotNull
    private static PhpChangeInfo onlyParametersChangedInfo(@NotNull Function function, PhpParameterInfo[] newParameters) {
        if (function == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(10);
        }
        PhpMethodDescriptor descriptor = new PhpMethodDescriptor(function);
        return new PhpChangeInfo(descriptor, newParameters, descriptor.getVisibility(), descriptor.getName(), descriptor.getReturnTypeText(), null, false, true);
    }

    private void collectChangedParametersIfPossible(PsiElement[] arguments, Parameter[] parameters, Map<Integer, Parameter> removedParameters, Map<Integer, PhpParameterInfo> introducedParameters, List<PhpParameterInfo> resultParameters) {
        this.collectChangedParametersIfPossible(arguments, ContainerUtil.map((Object[])arguments, PhpChangeFunctionSignatureFromUsageQuickFix::getArgumentType), parameters, removedParameters, introducedParameters, resultParameters);
    }

    public static Collection<UsageInfo> getUsages(@NotNull Project project, PhpChangeInfo function) {
        if (project == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(11);
        }
        SmartList usages = new SmartList();
        Runnable runnable = () -> PhpChangeFunctionSignatureFromUsageQuickFix.lambda$getUsages$3(function, (Collection)usages);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, PhpBundle.message("searching.for.usages", new Object[0]), true, project)) {
            return null;
        }
        return usages;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        ParameterList argumentsList;
        if (project == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(13);
        }
        if (file == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(14);
        }
        if ((argumentsList = (ParameterList)ObjectUtils.tryCast((Object)this.getStartElement(), ParameterList.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(15);
            }
            return intentionPreviewInfo;
        }
        Function function = PhpChangeSignatureHandler.getSuperMethod((Function)ContainerUtil.getFirstItem(PhpWorkaroundUtil.resolveTargetFunctions(argumentsList.getParent())));
        if (function == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(16);
            }
            return intentionPreviewInfo;
        }
        Object[] parameters = function.getParameters();
        HashMap<Integer, Parameter> removedParameters = new HashMap<Integer, Parameter>();
        HashMap<Integer, PhpParameterInfo> introducedParameters = new HashMap<Integer, PhpParameterInfo>();
        SmartList resultParameters = new SmartList();
        this.collectChangedParametersIfPossible(argumentsList.getParameters(), (Parameter[])parameters, removedParameters, introducedParameters, (List<PhpParameterInfo>)resultParameters);
        PhpChangeInfo info = PhpChangeFunctionSignatureFromUsageQuickFix.onlyParametersChangedInfo(function, resultParameters.toArray(new PhpParameterInfo[0]));
        PhpParameterInfo[] paramInfos = (PhpParameterInfo[])ContainerUtil.map2Array((Object[])parameters, PhpParameterInfo.class, arg_0 -> PhpChangeFunctionSignatureFromUsageQuickFix.lambda$generatePreview$4((Parameter[])parameters, arg_0));
        String oldSignature = PhpChangeFunctionSignatureFromUsageQuickFix.buildMethodSignatureText(info, paramInfos);
        String newSignature = PhpChangeFunctionSignatureFromUsageQuickFix.buildMethodSignatureText(info, info.getNewParameters());
        return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, function.getContainingFile().getName(), oldSignature, newSignature);
    }

    public static String buildMethodSignatureText(PhpChangeInfo info, PhpParameterInfo @NotNull [] infos) {
        if (infos == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(17);
        }
        String newParams = StreamEx.of((Object[])infos).map(pi -> pi.getTypeText() + " $" + pi.getName()).joining((CharSequence)", ");
        return "%s function %s(%s)".formatted(info.getNewVisibility(), info.getNewName(), newParams);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static Collection<String> getDescriptionPartsWithIntroducedParameters(Collection<PhpParameterInfo> introducedParameters, List<PhpParameterInfo> resultParameters) {
        SmartList parts = new SmartList();
        for (PhpParameterInfo argument : resultParameters) {
            if (introducedParameters.contains(argument)) {
                parts.add("<b>" + PhpChangeFunctionSignatureFromUsageQuickFix.toString(argument) + "</b>");
                continue;
            }
            parts.add(PhpChangeFunctionSignatureFromUsageQuickFix.toString(argument));
        }
        return parts;
    }

    private static Collection<String> getDescriptionPartsWithRemovedParameters(Parameter[] parameters, Collection<Parameter> removedParameters) {
        SmartList parts = new SmartList();
        for (Parameter parameter : parameters) {
            if (removedParameters.contains(parameter)) {
                parts.add("<s>" + parameter.getText() + "</s>");
                continue;
            }
            parts.add(parameter.getText());
        }
        return parts;
    }

    protected boolean collectChangedParametersIfPossible(PsiElement[] arguments, List<PhpType> argumentTypes, Parameter[] parameters, Map<Integer, Parameter> removedParametersWithIndices, Map<Integer, PhpParameterInfo> introducedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        Set parametersNames = ContainerUtil.map2Set((Object[])parameters, Parameter::getName);
        if (arguments.length > parameters.length) {
            return this.findPlacesForIntroducedParameters(arguments, argumentTypes, parametersNames, parameters, introducedParametersWithIndices, resultParameters);
        }
        if (arguments.length < parameters.length) {
            return this.findRemovedParameters(arguments, argumentTypes, parametersNames, parameters, removedParametersWithIndices, resultParameters);
        }
        return false;
    }

    protected boolean findRemovedParameters(PsiElement[] arguments, List<PhpType> argumentTypes, Set<String> parametersNames, Parameter[] parameters, Map<Integer, Parameter> removedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        int argumentIndex = 0;
        for (int parameterIndex = 0; parameterIndex < parameters.length; ++parameterIndex) {
            if (argumentIndex < arguments.length && PhpChangeFunctionSignatureFromUsageQuickFix.argumentTypeApplicableToParameter(parameters[parameterIndex], argumentTypes.get(argumentIndex))) {
                resultParameters.add(new PhpParameterInfo(parameterIndex, parameters[parameterIndex]));
                ++argumentIndex;
                continue;
            }
            removedParametersWithIndices.put(parameterIndex, parameters[parameterIndex]);
        }
        return argumentIndex == arguments.length;
    }

    protected boolean findPlacesForIntroducedParameters(PsiElement[] arguments, List<PhpType> argumentTypes, Set<String> parametersNames, Parameter[] parameters, Map<Integer, PhpParameterInfo> introducedParametersWithIndices, List<PhpParameterInfo> resultParameters) {
        int parameterIndex = 0;
        for (int argumentIndex = 0; argumentIndex < arguments.length; ++argumentIndex) {
            if (parameterIndex < parameters.length && PhpChangeFunctionSignatureFromUsageQuickFix.argumentTypeApplicableToParameter(parameters[parameterIndex], argumentTypes.get(argumentIndex))) {
                resultParameters.add(new PhpParameterInfo(parameterIndex, parameters[parameterIndex]));
                ++parameterIndex;
                continue;
            }
            PhpParameterInfo introducedParameter = PhpChangeFunctionSignatureFromUsageQuickFix.createParameter(arguments[argumentIndex], parametersNames, resultParameters);
            introducedParametersWithIndices.put(argumentIndex, introducedParameter);
            resultParameters.add(introducedParameter);
        }
        return parameterIndex == parameters.length;
    }

    @NotNull
    private static String toString(PhpParameterInfo info) {
        String parameterIdentifierText = "$" + info.getName();
        String string = StringUtil.isNotEmpty((String)info.getTypeText()) ? PhpLangUtil.toShortName(info.getTypeText()) + " " + parameterIdentifierText : parameterIdentifierText;
        if (string == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    protected static PhpParameterInfo createParameter(PsiElement argument, Set<String> parametersNames, List<PhpParameterInfo> result) {
        String name = PhpNameUtil.unique(PhpNameSuggestionUtil.parameterNameByElement(argument), "", "", (Condition<? super String>)((Condition)a -> parametersNames.contains(a) || result.stream().anyMatch(e -> e.getName().equalsIgnoreCase((String)a))));
        PhpParameterInfo info = new PhpParameterInfo(-1, name);
        Project project = argument.getProject();
        String typeText = PhpAddMethodDeclarationQuickFix.createTypeHint(PhpLanguageLevel.current((Project)project), new PhpType().add(argument).global(project), null, false, false);
        PhpType type = Optional.ofNullable((PhpTypedElement)ObjectUtils.tryCast((Object)argument, PhpTypedElement.class)).map(a -> a.getType()).orElse(PhpType.EMPTY);
        info.setType(type, typeText);
        PhpParameterInfo phpParameterInfo = info;
        if (phpParameterInfo == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(19);
        }
        return phpParameterInfo;
    }

    protected static boolean argumentTypeApplicableToParameter(Parameter parameter, PhpType argumentType) {
        PhpType declType = parameter.getGlobalType();
        if (declType.isAmbiguous()) {
            return true;
        }
        if (declType.isNotExtendablePrimitiveType() || argumentType.isNotExtendablePrimitiveType()) {
            return PhpType.intersects(declType, argumentType);
        }
        PhpIndex index = PhpIndex.getInstance(parameter.getProject());
        return declType.isConvertibleFrom(argumentType, index);
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.change.function.signature.from.usage.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static ProblemDescriptor getDescriptor(@NotNull PsiElement argumentsList, @InspectionMessage String message, boolean onTheFly) {
        if (argumentsList == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(22);
        }
        LocalQuickFix[] fixes = PhpChangeFunctionSignatureFromUsageQuickFix.getFixes(argumentsList, onTheFly);
        PsiElement startElement = argumentsList.getPrevSibling();
        PsiElement endElement = argumentsList.getNextSibling();
        if (startElement == null || endElement == null) {
            ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)argumentsList.getProject()).createProblemDescriptor(argumentsList, argumentsList, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, fixes);
            if (problemDescriptor == null) {
                PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(23);
            }
            return problemDescriptor;
        }
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)argumentsList.getProject()).createProblemDescriptor(startElement, endElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, fixes);
        if (problemDescriptor == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(24);
        }
        return problemDescriptor;
    }

    @NotNull
    public static LocalQuickFix[] getFixes(@NotNull PsiElement argumentsList, boolean onTheFly) {
        LocalQuickFix[] fixes;
        if (argumentsList == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(25);
        }
        if (onTheFly) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[3];
            localQuickFixArray[0] = new PhpChangeFunctionSignatureFromUsageQuickFix(argumentsList);
            localQuickFixArray[1] = new PhpChangeFunctionSignatureReversePassFromUsageQuickFix(argumentsList);
            v1 = localQuickFixArray;
            localQuickFixArray[2] = new PhpChangeFunctionSignatureManuallyQuickFix(argumentsList);
        } else {
            v1 = fixes = LocalQuickFix.EMPTY_ARRAY;
        }
        if (fixes == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(26);
        }
        return fixes;
    }

    @NotNull
    private static PhpType getArgumentType(@NotNull PsiElement argument) {
        if (argument == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(27);
        }
        PhpType phpType = new PhpType().add(argument).global(argument.getProject()).filterNull().filterUnknown();
        if (phpType == null) {
            PhpChangeFunctionSignatureFromUsageQuickFix.$$$reportNull$$$0(28);
        }
        return phpType;
    }

    private static /* synthetic */ PhpParameterInfo lambda$generatePreview$4(Parameter[] parameters, Parameter p) {
        return new PhpParameterInfo(ArrayUtil.indexOf((Object[])parameters, (Object)p), p);
    }

    private static /* synthetic */ void lambda$getUsages$3(PhpChangeInfo function, Collection usages) {
        ReadAction.run(() -> {
            for (UsageInfo usage : ChangeSignatureProcessorBase.findUsages((ChangeInfo)function)) {
                if (function.getMethod() == usage.getElement() || PhpPsiUtil.getParentByCondition(usage.getElement(), false, PhpUse.INSTANCEOF, Statement.INSTANCEOF) != null) continue;
                usages.add(usage);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 15, 16, 18, 19, 20, 21, 23, 24, 26, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/parameterCountMismatch/PhpChangeFunctionSignatureFromUsageQuickFix";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsList";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/parameterCountMismatch/PhpChangeFunctionSignatureFromUsageQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextIfChangeIsPossible";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeFunctionSignature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onlyParametersChangedInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildMethodSignatureText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 15, 16, 18, 19, 20, 21, 23, 24, 26, 28 -> new IllegalStateException(string);
        };
    }
}

