/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocFinalChecksInspection
extends PhpHierarchyChecksInspection {
    private static final PhpHierarchyChecksInspection.MethodCheck DOC_FINAL = new PhpHierarchyChecksInspection.MethodCheck(){

        @Override
        @NotNull
        public PhpHierarchyChecksInspection.MethodProblem findProblem(PhpClass clazz, PhpClass subClass, PhpClass baseClass, Method superMethod, Method method, String superName, @NotNull PsiElement node, boolean isOnTheFly) {
            PhpDocTag finalTag;
            if (node == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((finalTag = PhpDocUtil.getFinalDocTag(superMethod)) != null) {
                String descriptionTemplate = isOnTheFly ? PhpBundle.message("inspection.message.0.overrides.method.with.final.tag", method.getName()) : PhpBundle.message("inspection.message.overrides.method.with.final.tag", new Object[0]);
                Method owner = (Method)ObjectUtils.tryCast((Object)PhpDocFinalChecksInspection.getCommentOwner(finalTag), Method.class);
                if (owner == null || owner.getContainingClass() == null) {
                    PhpHierarchyChecksInspection.MethodProblem methodProblem = PhpHierarchyChecksInspection.MethodProblem.empty(superMethod.getContainingClass());
                    if (methodProblem == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return methodProblem;
                }
                String message = PhpBundle.message("inspection.message.remove.final.tag.from.0", isOnTheFly ? PhpLangUtil.toPresentableFQN(owner.getFQN()) : null);
                return new PhpHierarchyChecksInspection.MethodProblem(superMethod.getContainingClass(), node, holder -> holder.registerProblem(PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, LocalQuickFix.from((ModCommandAction)new PhpRemoveDocTagQuickFix(finalTag, message)), LocalQuickFix.from((ModCommandAction)new PhpNavigateToElementQuickFix(owner)))));
            }
            PhpHierarchyChecksInspection.MethodProblem methodProblem = PhpHierarchyChecksInspection.MethodProblem.empty(superMethod.getContainingClass());
            if (methodProblem == null) {
                1.$$$reportNull$$$0(2);
            }
            return methodProblem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFinalChecksInspection$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocFinalChecksInspection$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findProblem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findProblem";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    };

    @Override
    protected Collection<PhpHierarchyChecksInspection.MethodCheck> getMethodChecks() {
        return List.of(DOC_FINAL);
    }

    @Override
    protected void doCheckClass(PhpClass clazz, boolean isOnTheFly, ProblemsHolder holder) {
        PhpClass identifier;
        PhpClass superClass = (PhpClass)ContainerUtil.getOnlyItem(clazz.getSuperClasses());
        if (superClass == null) {
            return;
        }
        PhpClass phpClass = identifier = clazz.isAnonymous() ? clazz : clazz.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        PhpDocTag tag = PhpDocUtil.getFinalDocTag(superClass);
        if (tag == null) {
            return;
        }
        PhpClass owner = (PhpClass)ObjectUtils.tryCast((Object)PhpDocFinalChecksInspection.getCommentOwner(tag), PhpClass.class);
        if (owner == null) {
            return;
        }
        String message = isOnTheFly && !clazz.isAnonymous() ? PhpBundle.message("inspection.message.0.extends.class.with.final.tag", clazz.getName()) : PhpBundle.message("inspection.message.extends.class.with.final.tag", new Object[0]);
        String qfMessage = isOnTheFly ? PhpBundle.message("inspection.message.remove.final.tag.from.0", PhpLangUtil.toPresentableFQN(owner.getFQN())) : PhpBundle.message("inspection.message.remove.final.tag", new Object[0]);
        holder.problem((PsiElement)identifier, message).fix((ModCommandAction)new PhpRemoveDocTagQuickFix(tag, qfMessage)).fix((ModCommandAction)new PhpNavigateToElementQuickFix(owner)).register();
    }

    @Nullable
    private static PhpNamedElement getCommentOwner(PhpDocTag tag) {
        PhpDocComment comment = (PhpDocComment)PhpPsiUtil.getParentByCondition((PsiElement)tag, PhpDocComment.INSTANCEOF, PhpFile.INSTANCEOF);
        if (comment == null) {
            return null;
        }
        return (PhpNamedElement)ObjectUtils.tryCast((Object)comment.getOwner(), PhpNamedElement.class);
    }
}

