/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.exception.PhpExceptionAnalysisService;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocRedundantThrowsInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "<init>", "()V", "buildVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "Companion", "PhpRemoveThrowsTagQuickFix", "PhpExceptionFromThrowsTagQuickFix", "intellij.php.impl"})
public final class PhpDocRedundantThrowsInspection
extends PhpInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public PhpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitPhpMethod(Method method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (method.isAbstract()) {
                    return;
                }
                this.visitPhpFunction(method);
            }

            /*
             * WARNING - void declaration
             */
            public void visitPhpFunction(Function function) {
                void $this$fold$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                boolean bl;
                Set thrownExceptionItems;
                Iterable $this$filterTo$iv$iv;
                List throwsTags;
                block14: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    PhpDocComment docComment = function.getDocComment();
                    if (docComment == null) {
                        return;
                    }
                    PhpDocTag[] $this$filterIsInstance$iv = this.getThrowsTags(docComment);
                    boolean $i$f$filterIsInstance = false;
                    PhpDocTag[] phpDocTagArray = $this$filterIsInstance$iv;
                    Iterable<E> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PhpDocThrowsTag)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    throwsTags = (List)destination$iv$iv;
                    if (throwsTags.isEmpty()) {
                        return;
                    }
                    Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> set = PhpExceptionAnalysisService.getThrownExceptions(function, null, null, false);
                    Intrinsics.checkNotNullExpressionValue(set, (String)"getThrownExceptions(...)");
                    Iterable $this$filter$iv = set;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    Iterator<T> iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv;
                        element$iv$iv = iterator.next();
                        PhpExceptionAnalysisService.PhpThrownExceptionItem it = (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)element$iv$iv);
                        boolean bl2 = false;
                        if (!(!it.isThrownInConstructorWithConstantParameters() || !PhpExceptionAnalysisService.getSkipConstantParams(function))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    thrownExceptionItems = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                    Iterable $this$any$iv = thrownExceptionItems;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            PhpExceptionAnalysisService.PhpThrownExceptionItem it = (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)element$iv);
                            boolean bl3 = false;
                            if (!it.isAmbiguous()) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> set = PhpThrownExceptionsAnalyzer.getExceptionClasses((PhpScopeHolder)function, false, thrownExceptionItems);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getExceptionClasses(...)");
                Set<PhpExceptionAnalysisService.PhpThrownExceptionItem> exceptionClasses = set;
                $this$filterTo$iv$iv = exceptionClasses;
                boolean $i$f$map = false;
                void it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    PhpExceptionAnalysisService.PhpThrownExceptionItem phpThrownExceptionItem = (PhpExceptionAnalysisService.PhpThrownExceptionItem)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it2.getException());
                }
                $this$map$iv = (List)destination$iv$iv;
                PhpType initial$iv = new PhpType();
                boolean $i$f$fold = false;
                PhpType accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void it3;
                    PhpType item$iv$iv = (PhpType)element$iv;
                    PhpType acc = accumulator$iv;
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)acc.add((PhpType)it3), (String)"add(...)");
                }
                PhpType thrownExceptions = accumulator$iv;
                for (PhpDocThrowsTag throwsTag : throwsTags) {
                    void $this$filterTo$iv$iv2;
                    List<T> docTypes;
                    Intrinsics.checkNotNullExpressionValue(PhpPsiUtil.getChildren((PsiElement)throwsTag, PhpDocType.INSTANCEOF), (String)"getChildren(...)");
                    Iterable $this$filter$iv = docTypes;
                    boolean $i$f$filter2 = false;
                    Iterable it3 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv2) {
                        PhpDocType it4 = (PhpDocType)element$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull((Object)it4);
                        if (!this.exceptionIsNotThrown(it4, thrownExceptions)) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    List notThrownDocTypes = (List)destination$iv$iv3;
                    if (notThrownDocTypes.isEmpty()) continue;
                    if (notThrownDocTypes.size() == docTypes.size()) {
                        String exception = CollectionsKt.joinToString$default((Iterable)notThrownDocTypes, (CharSequence)"|", null, null, (int)0, null, arg_0 -> buildVisitor.1.visitPhpFunction$lambda$5(this, arg_0), (int)30, null);
                        Object[] $i$f$filter2 = new Object[]{exception};
                        this.$holder.problem((PsiElement)throwsTag, PhpBundle.message("php.exception.is.never.thrown", $i$f$filter2)).fix((ModCommandAction)new PhpRemoveThrowsTagQuickFix(throwsTag)).fix((LocalQuickFix)PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX).register();
                        continue;
                    }
                    for (PhpDocType notThrownDocType : notThrownDocTypes) {
                        String m;
                        Object[] objectArray = new Object[1];
                        Intrinsics.checkNotNull((Object)notThrownDocType);
                        objectArray[0] = this.exceptionPresentableName(notThrownDocType);
                        Intrinsics.checkNotNullExpressionValue((Object)PhpBundle.message("php.exception.is.never.thrown", objectArray), (String)"message(...)");
                        this.$holder.problem((PsiElement)notThrownDocType, m).fix((ModCommandAction)new PhpExceptionFromThrowsTagQuickFix(notThrownDocType)).fix((LocalQuickFix)PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX).register();
                    }
                }
            }

            private final String exceptionPresentableName(PhpDocType $this$exceptionPresentableName) {
                Set<String> set = this.getException($this$exceptionPresentableName).getTypes();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getTypes(...)");
                String string = PhpLangUtil.toShortName((String)CollectionsKt.single((Iterable)set));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortName(...)");
                return string;
            }

            private final boolean exceptionIsNotThrown(PhpDocType docType, PhpType actualThrownExceptions) {
                PhpType declaredException = this.getException(docType);
                PhpIndex phpIndex = PhpIndex.getInstance(docType.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)phpIndex, (String)"getInstance(...)");
                PhpIndex instance = phpIndex;
                PhpType phpType = new PhpType().add(PhpType.EXCEPTION).add(PhpType.THROWABLE).add(actualThrownExceptions);
                Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"add(...)");
                PhpType possibleThrownException = phpType;
                Project project = docType.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return !PhpDocRedundantThrowsInspection.Companion.isRuntime(declaredException, project) && !declaredException.isConvertibleFrom(possibleThrownException, instance) && (actualThrownExceptions.isEmpty() || !actualThrownExceptions.isConvertibleFrom(declaredException, instance));
            }

            private final PhpDocTag[] getThrowsTags(PhpDocComment $this$getThrowsTags) {
                PhpDocTag[] phpDocTagArray = $this$getThrowsTags.getTagElementsByName("@throws");
                Intrinsics.checkNotNullExpressionValue((Object)phpDocTagArray, (String)"getTagElementsByName(...)");
                return phpDocTagArray;
            }

            /*
             * WARNING - void declaration
             */
            private final PhpType getException(PhpDocType $this$getException) {
                void $this$fold$iv;
                Collection<String> collection = PhpThrownExceptionsAnalyzer.filterNonThrowable($this$getException.getType(), $this$getException.getProject());
                Intrinsics.checkNotNullExpressionValue(collection, (String)"filterNonThrowable(...)");
                Iterable iterable = collection;
                PhpType initial$iv = new PhpType();
                boolean $i$f$fold = false;
                PhpType accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void it;
                    String string = (String)element$iv;
                    PhpType acc = accumulator$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)acc.add((String)it), (String)"add(...)");
                }
                return accumulator$iv;
            }

            private static final CharSequence visitPhpFunction$lambda$5(buildVisitor.1 this$0, PhpDocType it) {
                Intrinsics.checkNotNull((Object)it);
                return this$0.exceptionPresentableName(it);
            }
        };
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.settingLink((String)PhpBundle.message("exception.analysis.settings.path", new Object[0]), (String)"reference.webide.settings.project.settings.php", (String)PhpBundle.message("PhpProjectConfigurable.analysis", new Object[0]))};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$Companion;", "", "<init>", "()V", "isRuntime", "", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.php.impl"})
    @SourceDebugExtension(value={"SMAP\nPhpDocRedundantThrowsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpDocRedundantThrowsInspection.kt\ncom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1755#2,3:135\n*S KotlinDebug\n*F\n+ 1 PhpDocRedundantThrowsInspection.kt\ncom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$Companion\n*L\n106#1:135,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRuntime(@NotNull PhpType $this$isRuntime, @NotNull Project project) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$isRuntime, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PhpAnalysisConfiguration configuration = PhpAnalysisConfiguration.getInstance(project);
                PhpIndex phpIndex = PhpIndex.getInstance(project);
                Intrinsics.checkNotNullExpressionValue((Object)phpIndex, (String)"getInstance(...)");
                PhpIndex index = phpIndex;
                Set<String> set = configuration.getUncheckedExceptions();
                Intrinsics.checkNotNullExpressionValue(set, (String)"getUncheckedExceptions(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!new PhpType().add(it).isConvertibleFrom($this$isRuntime, index)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpExceptionFromThrowsTagQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocType;", "docType", "<init>", "(Lcom/jetbrains/php/lang/documentation/phpdoc/psi/PhpDocType;)V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.php.impl"})
    private static final class PhpExceptionFromThrowsTagQuickFix
    extends PsiUpdateModCommandAction<PhpDocType> {
        public PhpExceptionFromThrowsTagQuickFix(@NotNull PhpDocType docType) {
            Intrinsics.checkNotNullParameter((Object)docType, (String)"docType");
            super((PsiElement)docType);
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PhpDocType element) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Object[] objectArray = new Object[]{element.getText()};
            Presentation presentation = Presentation.of((String)PhpBundle.message("php.remove.exception.from.throws", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
            return presentation;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{"exception"};
            String string = PhpBundle.message("php.remove.exception.from.throws", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpDocType element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)element, PhpDocTokenTypes.DOC_PIPE);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpRemoveThrowsTagQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocThrowsTag;", "throwsTag", "<init>", "(Lcom/jetbrains/php/lang/documentation/phpdoc/psi/tags/PhpDocThrowsTag;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.php.impl"})
    private static final class PhpRemoveThrowsTagQuickFix
    extends PsiUpdateModCommandAction<PhpDocThrowsTag> {
        public PhpRemoveThrowsTagQuickFix(@NotNull PhpDocThrowsTag throwsTag) {
            Intrinsics.checkNotNullParameter((Object)throwsTag, (String)"throwsTag");
            super((PsiElement)throwsTag);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.remove.throws.tag", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpDocThrowsTag throwsTag, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)throwsTag, (String)"throwsTag");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            PhpPsiElement next = throwsTag.getNextPsiSibling();
            PsiElement psiElement = throwsTag.getNextSibling();
            if (psiElement == null) {
                psiElement = (PsiElement)throwsTag;
            }
            PsiElement last = psiElement;
            throwsTag.getParent().deleteChildRange(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)throwsTag, true), last);
            if (next != null) {
                updater.moveCaretTo((PsiElement)next);
            }
        }
    }
}

