/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.UpdatePhpDocQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpDocSignatureInspection
extends PhpInspection {
    static final UpdatePhpDocQuickFix UPDATE_PHP_DOC_QUICK_FIX = new UpdatePhpDocQuickFix();
    static final LocalQuickFix UPDATE_SIGNATURE_QUICK_FIX = new PhpUpdateSignatureFromPhpDocQuickFix();
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX};
    private static final LocalQuickFix[] FIXES_WITH_SIGNATURE = new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX, UPDATE_SIGNATURE_QUICK_FIX};
    private static final PhpType TRUE_FALSE = PhpType.builder().add("true").add("false").build();
    @NotNull
    private static final PhpType VOID_NEVER = PhpType.or(PhpType.VOID, PhpType.NEVER);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null || docComment.hasInheritDocTag() || PhpDocUtil.hasOnlyNoInspectionTag(docComment)) {
                    return;
                }
                PhpDocSignatureInspection.checkSignature(docComment, function, holder, isOnTheFly);
            }

            @Override
            public void visitPhpMethod(Method method) {
                this.visitPhpFunction(method);
            }
        };
    }

    private static void checkSignature(@NotNull PhpDocComment comment, @NotNull Function function, ProblemsHolder holder, boolean isOnTheFly) {
        if (comment == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(1);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(2);
        }
        Parameter[] parameters = function.getParameters();
        Map<String, PhpDocParamTag> paramTags = PhpDocSignatureInspection.getNonGlobalTags(comment, function, holder);
        LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
        for (Parameter parameter : parameters) {
            String paramName = parameter.getName();
            if (StringUtil.isEmpty((String)paramName)) continue;
            parameterMap.put(paramName, parameter);
            if (paramTags.containsKey(paramName)) {
                PhpDocParamTag paramTag = paramTags.get(paramName);
                PhpType docType = PhpDocUtil.getParamType(paramTag, function);
                if (!docType.isEmpty() && parameter.getTypeDeclaration() == null) {
                    if (!isOnTheFly) continue;
                    holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_SIGNATURE_QUICK_FIX});
                    continue;
                }
                if (paramTag.getTagValue().isEmpty() && paramTag.getType().isEmpty() && parameter.getTypeDeclaration() != null) {
                    holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX, RemovePhpDocTagQuickFix.REMOVE_PARAM_TAG});
                    if (!isOnTheFly) continue;
                    PhpDocSignatureInspection.addUpdateDocCommentQuickFixForParameter(parameter, holder);
                    continue;
                }
                if (PhpDocSignatureInspection.typesMatch(parameter, paramTag, docType)) continue;
                LocalQuickFix[] fixes = PhpUpdateSignatureFromPhpDocQuickFix.getParameterTypeString(function, paramTag) != null ? FIXES_WITH_SIGNATURE : FIXES;
                holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), fixes);
                if (!isOnTheFly) continue;
                PhpDocSignatureInspection.addUpdateDocCommentQuickFixForParameter(parameter, holder);
                continue;
            }
            if (!isOnTheFly) continue;
            PhpDocSignatureInspection.addUpdateDocCommentQuickFixForParameter(parameter, holder);
        }
        for (String name : paramTags.keySet()) {
            if (parameterMap.containsKey(name)) continue;
            holder.registerProblem((PsiElement)paramTags.get(name), PhpBundle.message("inspection.php.doc.signature.description3", new Object[0]), FIXES_WITH_SIGNATURE);
        }
        PhpDocReturnTag returnTag = comment.getReturnTag();
        if (returnTag == null) {
            return;
        }
        if (!returnTag.getType().isEmpty() && function.getTypeDeclaration() == null) {
            if (!isOnTheFly) {
                return;
            }
            holder.registerProblem((PsiElement)returnTag, PhpBundle.message("inspection.php.doc.signature.description2", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_SIGNATURE_QUICK_FIX});
        } else if (!PhpDocSignatureInspection.returnTypesMatch(returnTag, function)) {
            LocalQuickFix[] localQuickFixArray;
            String string = PhpBundle.message("inspection.php.doc.signature.description2", new Object[0]);
            if (returnTag.getType().isEmpty() && returnTag.getTagValue().isEmpty()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
                localQuickFixArray2[0] = UPDATE_PHP_DOC_QUICK_FIX;
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[1] = RemovePhpDocTagQuickFix.REMOVE_RETURN_TAG;
            } else {
                localQuickFixArray = FIXES_WITH_SIGNATURE;
            }
            holder.registerProblem((PsiElement)returnTag, string, localQuickFixArray);
            if (isOnTheFly) {
                PhpDocSignatureInspection.addUpdateDocCommentQuickFixForReturnType(function, holder);
            }
        }
    }

    private static void addUpdateDocCommentQuickFixForParameter(@NotNull Parameter parameter, @NotNull ProblemsHolder holder) {
        if (parameter == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(4);
        }
        holder.registerProblem((PsiElement)parameter, PhpBundle.message("inspection.php.doc.signature.description5", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX});
    }

    private static void addUpdateDocCommentQuickFixForReturnType(@NotNull Function function, @NotNull ProblemsHolder holder) {
        PhpReturnType typeDeclaration;
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(6);
        }
        if ((typeDeclaration = (PhpReturnType)function.getTypeDeclaration()) == null) {
            return;
        }
        holder.registerProblem((PsiElement)typeDeclaration, PhpBundle.message("inspection.php.doc.signature.description2", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{UPDATE_PHP_DOC_QUICK_FIX});
    }

    public static boolean typesMatch(Parameter parameter, PhpDocParamTag paramTag, PhpType paramDocType) {
        boolean emptyPhpDocTagVariadic = paramTag.isVariadic() && PhpDocTagImpl.getTypeFromDeclaration(paramTag).isEmpty();
        return (!emptyPhpDocTagVariadic || ParameterImpl.getTypeFromDeclaration(parameter).isEmpty()) && PhpDocSignatureInspection.typesMatch(parameter.getProject(), paramDocType, PhpDocUtil.getParameterType(parameter));
    }

    private static Map<String, PhpDocParamTag> getNonGlobalTags(PhpDocComment comment, Function function, ProblemsHolder holder) {
        LinkedHashMap<String, PhpDocParamTag> nonGlobalTags = new LinkedHashMap<String, PhpDocParamTag>();
        int paramIndex = 0;
        for (PhpDocParamTag paramTag : comment.getParamTags()) {
            if (paramTag.getName().equals("@global")) continue;
            String paramName = PhpDocUtil.getParamName(paramTag, function);
            if (paramName == null) {
                Parameter parameter = function.getParameter(paramIndex);
                String string = paramName = parameter != null ? parameter.getName() : null;
            }
            if (paramName != null && nonGlobalTags.put(paramName, paramTag) != null) {
                holder.registerProblem((PsiElement)paramTag, PhpBundle.message("inspection.php.doc.signature.description", new Object[0]), FIXES);
            }
            ++paramIndex;
        }
        return nonGlobalTags;
    }

    public static boolean typesMatch(Project project, PhpType docType, PhpType paramType) {
        return PhpDocSignatureInspection.typesMatch(project, docType, paramType, PhpIndex.getInstance(project), true);
    }

    private static boolean typesMatch(@NotNull Project project, @NotNull PhpType docType, @NotNull PhpType paramType, PhpIndex index, boolean strict) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(7);
        }
        if (docType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(8);
        }
        if (paramType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(9);
        }
        paramType = paramType.filterUnknown();
        if (!PhpLanguageFeature.NULLABLES.isSupported(project)) {
            paramType = paramType.filterNull();
        }
        boolean isUnionTypesSupported = PhpLanguageFeature.UNION_TYPES.isSupported(project);
        if (docType.equals(PhpType.FALSE) && paramType.equals(PhpType.TRUE) || docType.equals(PhpType.TRUE) && paramType.equals(PhpType.FALSE)) {
            return false;
        }
        return paramType.isEmpty() || PhpType.intersects(PhpType.MIXED, paramType) || PhpType.intersects(PhpType.MIXED, docType) || docType.equals(paramType) || !isUnionTypesSupported && PhpType.isSubType(paramType, docType) || !strict && PhpType.isSubType(docType, paramType) || PhpDocSignatureInspection.areCompatibleAsArrayTypes(project, paramType, docType, index, strict) || PhpDocSignatureInspection.areCompatibleAsArrayTypes(project, docType, paramType, index, strict) || PhpType.intersects(TRUE_FALSE, docType) && PhpType.intersects(PhpType.BOOLEAN, paramType) || PhpType.intersects(PhpType.BOOLEAN, docType) && PhpType.intersects(TRUE_FALSE, paramType) || PhpType.ITERABLE.equals(paramType) && PhpType.ITERABLE.isConvertibleFrom(docType, index) || PhpType.intersects(PhpType.CLASS_STRING, docType) && PhpType.intersects(PhpType.STRING, paramType) || PhpDocSignatureInspection.isCompatibleByHierarchy(project, paramType, docType);
    }

    public static boolean isCompatibleByHierarchy(@NotNull Project project, @NotNull PhpType declaredType, @NotNull PhpType docType) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(10);
        }
        if (declaredType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(11);
        }
        if (docType == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(12);
        }
        if (PhpLanguageFeature.UNION_TYPES.isSupported(project) && declaredType.size() != docType.size()) {
            return false;
        }
        Set<String> superTypes = declaredType.getTypes();
        Set<String> types = docType.global(project).getTypes();
        PhpIndex index = PhpIndex.getInstance(project);
        return ContainerUtil.and(superTypes, s -> types.stream().anyMatch(c -> PhpType.findSuper(s, c, index)));
    }

    private static boolean areCompatibleAsArrayTypes(@NotNull Project project, @NotNull PhpType type, PhpType docType, PhpIndex index, boolean strict) {
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(13);
        }
        if (type == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(14);
        }
        for (String t1 : type.getTypes()) {
            for (String t2 : docType.getTypes()) {
                if (!PhpType.isPluralType(t2)) continue;
                if (PhpType.isArray(t1)) {
                    return true;
                }
                if (!PhpType.isPluralType(t1)) continue;
                return PhpDocSignatureInspection.typesMatch(project, new PhpType().add(docType).elementType(), new PhpType().add(t1).elementType(), index, strict);
            }
        }
        return false;
    }

    public static boolean returnTypesMatch(@NotNull PhpDocReturnTag tag, @NotNull Function function) {
        PhpType tagType;
        if (tag == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(15);
        }
        if (function == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(16);
        }
        if ((tagType = tag.getGlobalType()).isEmpty()) {
            return false;
        }
        Project project = function.getProject();
        if (!PhpDocSignatureInspection.isReturnTypeSupported(tagType, project)) {
            return true;
        }
        PhpType declaredType = function.getDeclaredType().globalLocationAware(function);
        PhpIndex index = PhpIndex.getInstance(project);
        if (!declaredType.isEmpty()) {
            if (!PhpDocSignatureInspection.numberSubtypesMatch(project, declaredType, tagType)) {
                return false;
            }
            if (tagType.isNotExtendablePrimitiveType()) {
                if (PhpType.intersects(declaredType, VOID_NEVER) || PhpType.intersects(tagType, VOID_NEVER)) {
                    return declaredType.equals(tagType);
                }
                return PhpDocSignatureInspection.typesMatch(project, tagType, declaredType, index, false);
            }
            return declaredType.isConvertibleFrom(tagType, PhpIndex.getInstance(project));
        }
        PhpType inferredType = function.getInferredType().globalLocationAware(function);
        return tagType.isConvertibleFrom(inferredType, index) || inferredType.isConvertibleFrom(tagType, index);
    }

    private static boolean numberSubtypesMatch(Project project, PhpType declaredType, PhpType tagType) {
        if (!PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            return true;
        }
        if (PhpType.intersects(PhpType.MIXED, declaredType)) {
            return true;
        }
        return declaredType.size() == tagType.map(t -> PhpType.isPluralType(t) ? "\\array" : t).size();
    }

    public static boolean isReturnTypeSupported(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(17);
        }
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(18);
        }
        if (PhpType.intersects(type, PhpType.OBJECT) && !PhpLanguageFeature.OBJECT_TYPE_HINT.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects(type, PhpType.ITERABLE) && !PhpLanguageFeature.ITERABLE_TYPE_HINT.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects(type, PhpType.NULL) && !PhpLanguageFeature.NULLABLES.isSupported(project)) {
            return false;
        }
        if (PhpType.intersects(type, PhpType.VOID) && !PhpLanguageFeature.RETURN_VOID.isSupported(project)) {
            return false;
        }
        if (PhpDocSignatureInspection.isTypeUnion(type, project) && !PhpLanguageFeature.UNION_TYPES.isSupported(project)) {
            return false;
        }
        return !PhpType.intersects(type, PhpType.RESOURCE);
    }

    private static boolean isTypeUnion(@NotNull PhpType type, @NotNull Project project) {
        PhpType nonNullableType;
        if (type == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(19);
        }
        if (project == null) {
            PhpDocSignatureInspection.$$$reportNull$$$0(20);
        }
        return !(nonNullableType = type.filterNull()).isEmpty() && PhpAddMethodDeclarationQuickFix.createTypeHint(PhpLanguageLevel.current((Project)project), nonNullableType, null, false, false).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSignature";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addUpdateDocCommentQuickFixForParameter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addUpdateDocCommentQuickFixForReturnType";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "typesMatch";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompatibleByHierarchy";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "areCompatibleAsArrayTypes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "returnTypesMatch";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isReturnTypeSupported";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeUnion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RemovePhpDocTagQuickFix
    extends PsiUpdateModCommandQuickFix
    implements LowPriorityAction {
        public static final RemovePhpDocTagQuickFix REMOVE_PARAM_TAG = new RemovePhpDocTagQuickFix(PhpDocParamTag.class);
        public static final RemovePhpDocTagQuickFix REMOVE_RETURN_TAG = new RemovePhpDocTagQuickFix(PhpDocReturnTag.class);
        private final Class<? extends PhpDocTag> myTagClass;

        private RemovePhpDocTagQuickFix(Class<? extends PhpDocTag> tagClass) {
            this.myTagClass = tagClass;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            if (this.myTagClass == PhpDocParamTag.class) {
                String string = PhpBundle.message("quickfix.remove.phpdoc.param.tag", new Object[0]);
                if (string == null) {
                    RemovePhpDocTagQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("quickfix.remove.phpdoc.return.tag", new Object[0]);
            if (string == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                RemovePhpDocTagQuickFix.$$$reportNull$$$0(4);
            }
            PhpDocTag docTag = (PhpDocTag)ObjectUtils.tryCast((Object)element, PhpDocTag.class);
            assert (docTag != null);
            PhpDocComment docComment = PhpPsiUtil.getParentOfClass((PsiElement)docTag, PhpDocComment.class);
            assert (docComment != null);
            ((PhpDocTagImpl)docTag).deleteWithLeadingAsterisk();
            if (PhpDocSignatureIsNotCompleteInspection.RemovePhpDocSignatureTagsQuickFix.isEmptyPhpDoc(docComment)) {
                docComment.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection$RemovePhpDocTagQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpDocSignatureInspection$RemovePhpDocTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

