/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIntRangesMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                if (assignmentExpression instanceof SelfAssignmentExpression) {
                    return;
                }
                FieldReference variable = (FieldReference)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), FieldReference.class);
                if (variable == null) {
                    return;
                }
                PhpType expected = PhpType.from(variable.resolve());
                PhpPsiElement actual = assignmentExpression.getValue();
                String message = PhpIntRangesMismatchInspection.getErrorMessage(holder.getProject(), expected, PhpType.from(new PsiElement[]{actual}));
                if (message != null) {
                    holder.registerProblem((PsiElement)assignmentExpression, message, new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitPhpReturn(PhpReturn returnStatement) {
                Function containingFunction = PhpPsiUtil.getParentOfClass((PsiElement)returnStatement, Function.class);
                PhpType expected = containingFunction != null ? containingFunction.getDocType() : PhpType.EMPTY;
                String message = PhpIntRangesMismatchInspection.getErrorMessage(holder.getProject(), expected, PhpType.from(returnStatement.getArgument()));
                if (message != null) {
                    holder.registerProblem((PsiElement)returnStatement, message, new LocalQuickFix[0]);
                }
            }
        };
    }

    @InspectionMessage
    @Nullable
    public static String getErrorMessage(@NotNull Project project, @NotNull PhpType expected, @NotNull PhpType actual) {
        List<Range<Integer>> valueRanges;
        if (project == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(1);
        }
        if (expected == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(2);
        }
        if (actual == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(3);
        }
        if ((valueRanges = PhpIntRangesMismatchInspection.getIntRanges(project, actual)).isEmpty()) {
            return null;
        }
        List<Range<Integer>> variableRanges = PhpIntRangesMismatchInspection.getIntRanges(project, expected);
        if (variableRanges.isEmpty()) {
            return null;
        }
        if (ContainerUtil.exists(valueRanges, valueRange -> ContainerUtil.exists((Iterable)variableRanges, variableRange -> PhpIntRangesMismatchInspection.intersects((Range<Integer>)variableRange, (Range<Integer>)valueRange)))) {
            return null;
        }
        return PhpBundle.message("inspection.message.value.ranges.mismatch.expected.actual", PhpIntRangesMismatchInspection.format(variableRanges), PhpIntRangesMismatchInspection.format(valueRanges));
    }

    private static String format(List<Range<Integer>> ranges) {
        return StringUtil.join(ranges, r -> String.format("<%s, %s>", r.getFrom(), r.getTo()), (String)",");
    }

    private static boolean intersects(@NotNull Range<Integer> f, @NotNull Range<Integer> s) {
        if (f == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(4);
        }
        if (s == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(5);
        }
        return Math.max((Integer)f.getFrom(), (Integer)s.getFrom()) <= Math.min((Integer)f.getTo(), (Integer)s.getTo());
    }

    private static boolean isValidIntRanges(List<@Nullable Range<Integer>> valueTypes) {
        return !valueTypes.isEmpty() && !valueTypes.contains(null);
    }

    private static @NotNull List<@Nullable Range<Integer>> getIntRanges(Project project, PhpType type) {
        List<@Nullable Range<Integer>> res = ContainerUtil.map(type.global(project).filterNull().getTypesWithParametrisedParts(), PhpType::getIntRangeBounds);
        List<Range<Integer>> list = PhpIntRangesMismatchInspection.isValidIntRanges(res) ? res : Collections.emptyList();
        if (list == null) {
            PhpIntRangesMismatchInspection.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpIntRangesMismatchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpIntRangesMismatchInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

