/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.completion.PhpObjectShapeCompletionProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureIsNotCompleteInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpRemoveDocTagQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpRedundantVariableDocTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRedundantVariableDocTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpVariable(Variable variable) {
                PhpDocParamTag tag = VariableImpl.getDocTag(variable);
                if (tag == null || PhpRedundantVariableDocTypeInspection.ambiguityDocTag(variable, tag) || PhpDocSignatureIsNotCompleteInspection.isExtendedBySpecialType(null, tag)) {
                    return;
                }
                PhpType docType = tag.getDocType().global(holder.getProject());
                if (docType.size() != 1 || !PhpObjectShapeCompletionProvider.getObjectShapes(variable).isEmpty()) {
                    return;
                }
                PhpType inferredType = PhpRedundantVariableDocTypeInspection.inferTypeWithoutDocs(variable);
                if (inferredType.size() != 1) {
                    return;
                }
                if (PhpRedundantVariableDocTypeInspection.docTypeIsCoveredByInferred(variable.getProject(), docType, inferredType)) {
                    holder.problem((PsiElement)tag, PhpBundle.message("inspection.php.redundant.variable.doc.type.description", new Object[0])).fix((ModCommandAction)new PhpRemoveDocTagQuickFix(tag, PhpBundle.message("php.remove.doc.tag.quick.fix.family.name", tag.getName()))).register();
                }
            }
        };
    }

    private static PhpType inferTypeWithoutDocs(Variable variable) {
        return PhpTypeInfo.getTypeFromAST((PsiElement)variable, new PhpTypeAnalyserVisitor(){

            @Override
            public void visitPhpVariable(Variable variable1) {
                this.addInferredType(variable1, new PhpTypeAnalyzerProcessor());
            }
        }).global(variable.getProject());
    }

    private static boolean ambiguityDocTag(Variable variable, PhpDocParamTag tag) {
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass((PsiElement)tag, PhpDocComment.class);
        if (docComment == null) {
            return true;
        }
        return PsiTreeUtil.findChildrenOfAnyType((PsiElement)docComment.getOwner(), (boolean)false, (Class[])new Class[]{Variable.class}).stream().filter(v -> v != variable).map(VariableImpl::getDocTag).anyMatch(tag::equals);
    }

    private static boolean docTypeIsCoveredByInferred(Project project, PhpType docType, PhpType inferredType) {
        if (PhpType.intersects(docType, inferredType)) {
            return true;
        }
        List<PhpClass> docClasses = PhpRedundantVariableDocTypeInspection.getClasses(project, docType);
        List<PhpClass> inferredClasses = PhpRedundantVariableDocTypeInspection.getClasses(project, inferredType);
        for (PhpClass docClass : docClasses) {
            for (PhpClass inferredClass : inferredClasses) {
                if (!PhpClassHierarchyUtils.isSuperClass(docClass, inferredClass, false)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<PhpClass> getClasses(Project project, PhpType inferredType) {
        PhpIndex index = PhpIndex.getInstance(project);
        List<PhpClass> list = inferredType.getTypes().stream().flatMap(t -> index.getAnyByFQN((String)t).stream()).collect(Collectors.toList());
        if (list == null) {
            PhpRedundantVariableDocTypeInspection.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantVariableDocTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpRedundantVariableDocTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

