/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpVarTagWithoutVariableNameInspection
extends PhpInspection {
    private static final int VARIABLE_NAMES_LIMIT = 4;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpDocParamTag(PhpDocParamTag tag) {
                if (StringUtil.isEmpty((String)tag.getVarName())) {
                    if ("@name".equals(tag.getName())) {
                        return;
                    }
                    if (tag.getType().isEmpty()) {
                        return;
                    }
                    PhpDocComment docComment = (PhpDocComment)ObjectUtils.tryCast((Object)tag.getParent(), PhpDocComment.class);
                    if (docComment == null) {
                        return;
                    }
                    PsiElement owner = docComment.getOwner();
                    if (!(owner instanceof Function) && owner instanceof PhpTypedElement && !((PhpTypedElement)owner).getDocType().isEmpty()) {
                        return;
                    }
                    if (PhpVarTagWithoutVariableNameInspection.isVarTag(docComment, tag) && owner instanceof PhpReturn) {
                        return;
                    }
                    holder.registerProblem((PsiElement)tag, PhpBundle.message("inspection.message.doc.tag.without.variable.name.doesn.t.provide.type.information.for.any.expression", new Object[0]), PhpVarTagWithoutVariableNameInspection.getFixes(owner, tag, docComment));
                }
            }
        };
    }

    private static LocalQuickFix @NotNull [] getFixes(PsiElement docOwner, PhpDocParamTag tag, PhpDocComment docComment) {
        if (!PhpVarTagWithoutVariableNameInspection.isVarTag(docComment, tag)) {
            if (docOwner instanceof Field) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpReplaceWithTagQuickFixBase.VAR_INSTANCE};
                if (localQuickFixArray == null) {
                    PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(1);
                }
                return localQuickFixArray;
            }
            if (docOwner instanceof Function) {
                String parameterName;
                Parameter[] parameters = ((Function)docOwner).getParameters();
                int paramTagIndex = docComment.getParamTags().indexOf(tag);
                if (paramTagIndex >= 0 && paramTagIndex < parameters.length && docComment.getParamTagByName(parameterName = parameters[paramTagIndex].getName()) == null) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PhpAddVariableNameQuickFix(parameterName)};
                    if (localQuickFixArray == null) {
                        PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(2);
                    }
                    return localQuickFixArray;
                }
            }
        } else {
            Set variableNames;
            if (docOwner instanceof Function && docComment.getReturnTag() == null) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{PhpReplaceWithTagQuickFixBase.RETURN_INSTANCE};
                if (localQuickFixArray == null) {
                    PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(3);
                }
                return localQuickFixArray;
            }
            if (docOwner instanceof Statement && !(variableNames = ContainerUtil.map2Set((Collection)PsiTreeUtil.findChildrenOfType((PsiElement)docOwner, Variable.class), PhpNamedElement::getName)).isEmpty() && variableNames.size() <= 4) {
                LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ContainerUtil.map2Array((Collection)variableNames, (Object[])new LocalQuickFix[variableNames.size()], PhpAddVariableNameQuickFix::new);
                if (localQuickFixArray == null) {
                    PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(4);
                }
                return localQuickFixArray;
            }
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            PhpVarTagWithoutVariableNameInspection.$$$reportNull$$$0(5);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static boolean isVarTag(PhpDocComment docComment, PhpDocParamTag tag) {
        return PhpDocCommentImpl.isVarTag(tag) || VariableImpl.customVarTags(docComment).contains(tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceWithTagQuickFixBase
    extends PsiUpdateModCommandQuickFix {
        private static final PhpReplaceWithTagQuickFixBase RETURN_INSTANCE = new PhpReplaceWithTagQuickFixBase("@return");
        private static final PhpReplaceWithTagQuickFixBase VAR_INSTANCE = new PhpReplaceWithTagQuickFixBase("@var");
        @NlsSafe
        private final String myTagName;

        private PhpReplaceWithTagQuickFixBase(@NlsSafe String tagName) {
            this.myTagName = tagName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myTagName);
            if (string == null) {
                PhpReplaceWithTagQuickFixBase.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpReplaceWithTagQuickFixBase.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithTagQuickFixBase.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithTagQuickFixBase.$$$reportNull$$$0(3);
            }
            PhpDocParamTag tag = (PhpDocParamTag)element;
            String tagContent = tag.getText().substring(tag.getFirstChild().getTextLength());
            tag.replace((PsiElement)PhpPsiElementFactory.createPhpDocTag(project, this.myTagName + tagContent));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection$PhpReplaceWithTagQuickFixBase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection$PhpReplaceWithTagQuickFixBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpAddVariableNameQuickFix
    extends PsiUpdateModCommandQuickFix {
        @NlsSafe
        private final String myVariableName;

        private PhpAddVariableNameQuickFix(@NlsSafe String variableName) {
            this.myVariableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.family.name.add", this.myVariableName);
            if (string == null) {
                PhpAddVariableNameQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.variable.name", new Object[0]);
            if (string == null) {
                PhpAddVariableNameQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement docTag, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpAddVariableNameQuickFix.$$$reportNull$$$0(2);
            }
            if (docTag == null) {
                PhpAddVariableNameQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpAddVariableNameQuickFix.$$$reportNull$$$0(4);
            }
            PsiElement lastTagChild = docTag.getLastChild();
            PhpDocVariable docVar = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)PhpPsiElementFactory.createPhpDocTag(project, "@param$" + this.myVariableName), PhpDocVariable.class);
            assert (docVar != null);
            if (PhpPsiUtil.isOfType(lastTagChild, (IElementType)PhpDocElementTypes.phpDocTagValue)) {
                docTag.addBefore((PsiElement)docVar, lastTagChild);
            } else {
                docTag.add((PsiElement)docVar);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection$PhpAddVariableNameQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docTag";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpVarTagWithoutVariableNameInspection$PhpAddVariableNameQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

