/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertArrayHasKeyInspection
extends PhpInspection {
    private static final String ASSERT_ARRAY_HAS_KEY = "assertArrayHasKey";
    private static final String ASSERT_ARRAY_NOT_HAS_KEY = "assertArrayNotHasKey";
    private static final String ASSERT_TRUE = "assertTrue";
    private static final String ASSERT_FALSE = "assertFalse";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                String methodName = reference.getName();
                if (methodName == null || !StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)PhpUnitAssertArrayHasKeyInspection.ASSERT_TRUE) && !StringUtil.equalsIgnoreCase((CharSequence)methodName, (CharSequence)PhpUnitAssertArrayHasKeyInspection.ASSERT_FALSE) || !PhpUnitAssertUtil.isInsideTestClass((PsiElement)reference) || !PhpUnitAssertUtil.isImplementedInPhpUnitAssertClass(reference)) {
                    return;
                }
                PsiElement argumentMappedToFirstParam = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
                if (argumentMappedToFirstParam == null) {
                    return;
                }
                String newMethodName = PhpUnitAssertArrayHasKeyInspection.getNewMethodName(argumentMappedToFirstParam, methodName);
                if (newMethodName == null) {
                    return;
                }
                String description = PhpBundle.message("inspection.phpunit.asserts.array.has.key.can.be.used.instead", newMethodName);
                PsiElement methodIdentifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                if (methodIdentifier == null) {
                    return;
                }
                holder.registerProblem(methodIdentifier, description, new LocalQuickFix[]{new PhpUnitAssertArrayHasKeyQuickFix(newMethodName, reference.getParameters().length)});
            }
        };
    }

    public static PsiElement findArgumentWithMappedParamIndex(FunctionReference reference, int paramIndex) {
        List<PsiElement> arguments = Arrays.asList(reference.getParameters());
        if (ContainerUtil.all(arguments, a -> ParameterListImpl.getNameIdentifier(a) == null)) {
            return paramIndex < arguments.size() ? arguments.get(paramIndex) : null;
        }
        Collection<Function> functions = PhpAnnotatorVisitor.resolveFunctions(reference);
        for (Function function : functions) {
            List<Parameter> parameters = Arrays.asList(function.getParameters());
            for (int i = 0; i < arguments.size(); ++i) {
                Parameter param = PhpParamsInspection.getMappedParam(arguments, parameters, i);
                if (param == null || parameters.indexOf(param) != paramIndex) continue;
                return arguments.get(i);
            }
        }
        return null;
    }

    @Nullable
    private static String getNewMethodName(@NotNull PsiElement firstParameter, @NotNull String originalName) {
        if (firstParameter == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(1);
        }
        if (originalName == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(2);
        }
        if (firstParameter instanceof UnaryExpression) {
            FunctionReference functionReference = PhpUnitAssertArrayHasKeyInspection.getFunctionReferenceFromUnaryExpression((UnaryExpression)firstParameter);
            return PhpUnitAssertArrayHasKeyInspection.getNewMethodName(functionReference, originalName, true);
        }
        FunctionReference functionReference = (FunctionReference)ObjectUtils.tryCast((Object)firstParameter, FunctionReference.class);
        return PhpUnitAssertArrayHasKeyInspection.getNewMethodName(functionReference, originalName, false);
    }

    @Nullable
    private static String getNewMethodName(@Nullable FunctionReference functionReference, @NotNull String originalName, boolean hasLogicalNot) {
        if (originalName == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(3);
        }
        if (functionReference == null || !PhpUnitAssertArrayHasKeyInspection.isStandardArrayKeyExistsFunction(functionReference)) {
            return null;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)originalName, (CharSequence)ASSERT_TRUE) && !hasLogicalNot || StringUtil.equalsIgnoreCase((CharSequence)originalName, (CharSequence)ASSERT_FALSE) && hasLogicalNot ? ASSERT_ARRAY_HAS_KEY : ASSERT_ARRAY_NOT_HAS_KEY;
    }

    @Nullable
    private static FunctionReference getFunctionReferenceFromUnaryExpression(@NotNull UnaryExpression unaryExpression) {
        if (unaryExpression == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(4);
        }
        if (!PhpPsiUtil.isOfType(unaryExpression.getOperation(), PhpTokenTypes.opNOT)) {
            return null;
        }
        return (FunctionReference)ObjectUtils.tryCast((Object)unaryExpression.getValue(), FunctionReference.class);
    }

    private static boolean isStandardArrayKeyExistsFunction(@NotNull FunctionReference functionReference) {
        Function resolvedFunction;
        if (functionReference == null) {
            PhpUnitAssertArrayHasKeyInspection.$$$reportNull$$$0(5);
        }
        return (resolvedFunction = (Function)ObjectUtils.tryCast((Object)functionReference.resolve(), Function.class)) != null && StringUtil.equalsIgnoreCase((CharSequence)resolvedFunction.getFQN(), (CharSequence)"\\array_key_exists");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstParameter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertArrayHasKeyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewMethodName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionReferenceFromUnaryExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isStandardArrayKeyExistsFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class PhpUnitAssertArrayHasKeyQuickFix
    extends PhpUnitReplaceAssertMethodReferenceQuickFix {
        private PhpUnitAssertArrayHasKeyQuickFix(@NotNull String newMethodName, int parametersNumber) {
            if (newMethodName == null) {
                PhpUnitAssertArrayHasKeyQuickFix.$$$reportNull$$$0(0);
            }
            super(newMethodName, parametersNumber);
        }

        @Override
        protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
            PsiElement[] newParametersArray;
            if (parameters == null) {
                PhpUnitAssertArrayHasKeyQuickFix.$$$reportNull$$$0(1);
            }
            if ((newParametersArray = super.createNewParameters(parameters)) == null) {
                return null;
            }
            PsiElement firstParameter = newParametersArray[0];
            FunctionReference functionReference = firstParameter instanceof UnaryExpression ? PhpUnitAssertArrayHasKeyInspection.getFunctionReferenceFromUnaryExpression((UnaryExpression)firstParameter) : (FunctionReference)ObjectUtils.tryCast((Object)firstParameter, FunctionReference.class);
            if (functionReference == null) {
                return null;
            }
            ParameterList functionReferenceParameterList = functionReference.getParameterList();
            if (functionReferenceParameterList == null) {
                return null;
            }
            functionReferenceParameterList = (ParameterList)functionReferenceParameterList.copy();
            PhpUnitReplaceAssertMethodReferenceQuickFix.dropNameIdentifiers(functionReferenceParameterList);
            newParametersArray[0] = functionReferenceParameterList;
            return newParametersArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMethodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertArrayHasKeyInspection$PhpUnitAssertArrayHasKeyQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

