/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.inspections.controlFlow.constantCondition.PhpPreviousDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.lang.inspections.controlFlow.dfa.PhpArrayEmptinessConditionDfaAnalyzer;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertCanBeReplacedWithEmptyInspection
extends PhpUnitAssertInspectionBase {
    private static final String ASSERT_EMPTY = "assertEmpty";
    private static final String ASSERT_NOT_EMPTY = "assertNotEmpty";

    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitAssertCanBeReplacedWithEmptyInspection.$$$reportNull$$$0(0);
        }
        return assertType == AssertType.ASSERT_TRUE || assertType == AssertType.ASSERT_FALSE;
    }

    @Override
    protected Collection<String> getSpecializedAssertMethodNames() {
        return Arrays.asList(ASSERT_EMPTY, ASSERT_NOT_EMPTY);
    }

    @Override
    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        PsiElement parameter;
        Pair<Boolean, PsiElement> emptinessCheck;
        if (methodReference == null) {
            PhpUnitAssertCanBeReplacedWithEmptyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnitAssertCanBeReplacedWithEmptyInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertCanBeReplacedWithEmptyInspection.$$$reportNull$$$0(3);
        }
        if ((emptinessCheck = PhpUnitAssertCanBeReplacedWithEmptyInspection.findEmptinessCheck(parameter = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(methodReference, 0), assertType == AssertType.ASSERT_TRUE)) == null) {
            return;
        }
        String methodName = (Boolean)emptinessCheck.first != false ? ASSERT_EMPTY : ASSERT_NOT_EMPTY;
        this.registerProblem(holder, methodReference, PhpBundle.message("inspection.message.can.be.replaced.with.fail", methodName), new LocalQuickFix[]{new PhpUnitReplaceWithAssertEmptyQuickFix(methodName, (PsiElement)emptinessCheck.second)});
    }

    private static Pair<Boolean, PsiElement> findEmptinessCheck(PsiElement parameter, boolean base) {
        PhpExpression[] variables;
        if (parameter instanceof PhpEmpty && (variables = ((PhpEmpty)parameter).getVariables()).length == 1) {
            return Pair.create((Object)base, (Object)variables[0]);
        }
        if (parameter instanceof UnaryExpression && PhpPsiUtil.isOfType(((UnaryExpression)parameter).getOperation(), PhpTokenTypes.opNOT)) {
            return PhpUnitAssertCanBeReplacedWithEmptyInspection.findEmptinessCheck((PsiElement)((UnaryExpression)parameter).getValue(), !base);
        }
        if (parameter instanceof BinaryExpression) {
            PsiElement right;
            PsiElement left;
            Pair<Boolean, PsiElement> emptinessCheckFromCountCall;
            IElementType type = ((BinaryExpression)parameter).getOperationType();
            if (!base) {
                type = PhpArrayEmptinessConditionDfaAnalyzer.invert(type);
            }
            if ((emptinessCheckFromCountCall = PhpUnitAssertCanBeReplacedWithEmptyInspection.findEmptinessCheckFromCountCall(left = ((BinaryExpression)parameter).getLeftOperand(), right = ((BinaryExpression)parameter).getRightOperand(), type)) != null) {
                return emptinessCheckFromCountCall;
            }
            return PhpUnitAssertCanBeReplacedWithEmptyInspection.findEmptinessCheckFromCountCall(right, left, PhpPreviousDfaBaseStateConditionDFAnalyzer.invertNonSymmetricOperands(type));
        }
        return null;
    }

    private static Pair<Boolean, PsiElement> findEmptinessCheckFromCountCall(PsiElement left, PsiElement right, IElementType tokenType) {
        PsiElement[] arguments;
        Integer value = PhpDfaDelegateBasedTypeState.getValue(right);
        if (value == null) {
            return null;
        }
        if (left instanceof FunctionReference && PhpCodeInsightUtil.isGlobalFunctionCallWithName((FunctionReference)left, "count") && (arguments = ((FunctionReference)left).getParameters()).length == 1) {
            if ((tokenType == PhpTokenTypes.opNOT_IDENTICAL || tokenType == PhpTokenTypes.opNOT_EQUAL) && value == 0 || tokenType == PhpTokenTypes.opGREATER && value <= 0 || tokenType == PhpTokenTypes.opGREATER_OR_EQUAL && value > 0) {
                return Pair.create((Object)false, (Object)arguments[0]);
            }
            if ((tokenType == PhpTokenTypes.opIDENTICAL || tokenType == PhpTokenTypes.opEQUAL) && value == 0 || tokenType == PhpTokenTypes.opLESS && value <= 1 || tokenType == PhpTokenTypes.opLESS_OR_EQUAL && value <= 0) {
                return Pair.create((Object)true, (Object)arguments[0]);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertCanBeReplacedWithEmptyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedAssertType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "declareProblemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnitReplaceWithAssertEmptyQuickFix
    extends PhpUnitReplaceAssertMethodReferenceQuickFix {
        protected final SmartPsiElementPointer<PsiElement> myElementToCheckEmptiness;

        private PhpUnitReplaceWithAssertEmptyQuickFix(String name, PsiElement elementToCheckEmptiness) {
            super(name, 0);
            this.myElementToCheckEmptiness = SmartPointerManager.getInstance((Project)elementToCheckEmptiness.getProject()).createSmartPsiElementPointer(elementToCheckEmptiness);
        }

        @Override
        protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
            if (parameters == null) {
                PhpUnitReplaceWithAssertEmptyQuickFix.$$$reportNull$$$0(0);
            }
            PsiElement[] parametersCopy = (PsiElement[])ArrayUtil.copyOf((Object[])parameters);
            parametersCopy[0] = this.myElementToCheckEmptiness.getElement();
            return parametersCopy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertCanBeReplacedWithEmptyInspection$PhpUnitReplaceWithAssertEmptyQuickFix", "createNewParameters"));
        }
    }
}

