/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertInspectionBase;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertCanBeReplacedWithFailInspection
extends PhpUnitAssertInspectionBase {
    private static final String FAIL_METHOD_NAME = "fail";

    @Override
    protected boolean isSupportedAssertType(@NotNull AssertType assertType) {
        if (assertType == null) {
            PhpUnitAssertCanBeReplacedWithFailInspection.$$$reportNull$$$0(0);
        }
        return assertType == AssertType.ASSERT_TRUE || assertType == AssertType.ASSERT_FALSE;
    }

    @Override
    protected Collection<String> getSpecializedAssertMethodNames() {
        return Collections.singleton(FAIL_METHOD_NAME);
    }

    @Override
    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        PsiElement parameter;
        if (methodReference == null) {
            PhpUnitAssertCanBeReplacedWithFailInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpUnitAssertCanBeReplacedWithFailInspection.$$$reportNull$$$0(2);
        }
        if (assertType == null) {
            PhpUnitAssertCanBeReplacedWithFailInspection.$$$reportNull$$$0(3);
        }
        if (PhpLangUtil.isTrue(parameter = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(methodReference, 0)) && assertType == AssertType.ASSERT_FALSE || PhpLangUtil.isFalse(parameter) && assertType == AssertType.ASSERT_TRUE) {
            this.registerProblem(holder, methodReference, PhpBundle.message("inspection.message.can.be.replaced.with.fail", FAIL_METHOD_NAME), new LocalQuickFix[]{PhpUnitReplaceWithFailQuickFix.INSTANCE});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertCanBeReplacedWithFailInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedAssertType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "declareProblemType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnitReplaceWithFailQuickFix
    extends PhpUnitReplaceAssertMethodReferenceQuickFix {
        private static final PhpUnitReplaceWithFailQuickFix INSTANCE = new PhpUnitReplaceWithFailQuickFix();

        private PhpUnitReplaceWithFailQuickFix() {
            super(PhpUnitAssertCanBeReplacedWithFailInspection.FAIL_METHOD_NAME, 0);
        }

        @Override
        protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
            PsiElement[] psiElementArray;
            if (parameters == null) {
                PhpUnitReplaceWithFailQuickFix.$$$reportNull$$$0(0);
            }
            if (parameters.length > 1) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = parameters[1];
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            return psiElementArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertCanBeReplacedWithFailInspection$PhpUnitReplaceWithFailQuickFix", "createNewParameters"));
        }
    }
}

