/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.AssertType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.AssertParameter;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitAssertEqualsWithDeltaQuickFix;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitDropOptionalParametersQuickFix;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceAssertMethodReferenceQuickFix;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDivisionByZeroInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpUnitAssertInspectionBase
extends PhpInspection {
    private static final String DEFAULT_MAX_DEPTH = "10";
    private static final String PHPUNIT_ASSERT_FQN = "\\PHPUnit\\Framework\\Assert";
    @NotNull
    private static final Key<CachedValue<Collection<PhpClass>>> KEY = Key.create((String)"php.phpunit.assert");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(0);
        }
        if (!this.existAllSpecializedAssertEqualsMethods(holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpUnitAssertInspectionBase.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                AssertType assertType = AssertType.getAssertType(reference);
                if (assertType != null && PhpUnitAssertInspectionBase.this.isSupportedAssertType(assertType) && PhpUnitAssertUtil.isInsideTestClass((PsiElement)reference) && PhpUnitAssertUtil.isImplementedInPhpUnitAssertClass(reference)) {
                    PhpUnitAssertInspectionBase.this.declareProblemType(reference, holder, assertType);
                }
            }
        };
    }

    private boolean existAllSpecializedAssertEqualsMethods(@NotNull Project project) {
        if (project == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(2);
        }
        Collection<PhpClass> phpUnitAssertClasses = PhpIndex.getInstance(project).getLibClassesCached(PHPUNIT_ASSERT_FQN, KEY);
        for (PhpClass phpUnitAssertClass : phpUnitAssertClasses) {
            Method[] classMethods;
            HashSet<String> curAssertEqualsMethodNames = new HashSet<String>();
            for (Method method : classMethods = phpUnitAssertClass.getOwnMethods()) {
                String methodName = method.getName();
                if (method.isValid() && this.getSpecializedAssertMethodNames().contains(methodName)) {
                    curAssertEqualsMethodNames.add(methodName);
                }
                if (curAssertEqualsMethodNames.size() != this.getSpecializedAssertMethodNames().size()) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isSupportedAssertType(@NotNull AssertType var1);

    protected abstract Collection<String> getSpecializedAssertMethodNames();

    protected void declareProblemType(@NotNull MethodReference methodReference, @NotNull ProblemsHolder holder, @NotNull AssertType assertType) {
        PsiElement[] parameters;
        if (methodReference == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(4);
        }
        if (assertType == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(5);
        }
        if (!this.suitableNumberOfParameters(parameters = methodReference.getParameters())) {
            return;
        }
        Set nonDefaultParameters = this.possibleNonDefaultParameters().filter(p -> this.isNonDefaultParameter(parameters, (AssertParameter)((Object)p))).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        String descriptionParameters = this.possibleNonDefaultParameters().filter(p -> this.getParameterIndex((AssertParameter)((Object)p)) < parameters.length).map(p -> "$" + p.getParameterName()).collect(Collectors.joining(", "));
        String description = this.getMessage(parameters, descriptionParameters);
        PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.IDENTIFIER);
        if (identifier == null) {
            return;
        }
        holder.registerProblem(identifier, description, LocalQuickFix.notNullElements((LocalQuickFix)this.getAssertEqualsQuickFix(nonDefaultParameters, assertType)));
    }

    protected void registerProblem(@NotNull ProblemsHolder holder, @NotNull MethodReference methodReference, @InspectionMessage String message, LocalQuickFix ... fixes) {
        ASTNode nameNode;
        PsiElement nameIdentifier;
        if (holder == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(6);
        }
        if (methodReference == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(7);
        }
        if (fixes == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(8);
        }
        PsiElement psiElement = nameIdentifier = (nameNode = methodReference.getNameNode()) != null ? nameNode.getPsi() : null;
        if (nameIdentifier != null) {
            holder.registerProblem(nameIdentifier, message, fixes);
        }
    }

    @NotNull
    @InspectionMessage
    protected String getMessage(PsiElement[] parameters, String descriptionParameters) {
        if (StringUtil.isEmpty((String)descriptionParameters)) {
            String string = PhpBundle.message("inspection.phpunit.asserts.assertEquals.parameters.empty", new Object[0]);
            if (string == null) {
                PhpUnitAssertInspectionBase.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = parameters.length > 4 ? PhpBundle.message("inspection.phpunit.asserts.assertEquals.parameters.many", descriptionParameters) : PhpBundle.message("inspection.phpunit.asserts.assertEquals.parameters.single", descriptionParameters);
        if (string == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean suitableNumberOfParameters(PsiElement[] parameters) {
        return parameters.length > 3 && parameters.length <= 7;
    }

    @NotNull
    protected Stream<AssertParameter> possibleNonDefaultParameters() {
        Stream<AssertParameter> stream = Stream.empty();
        if (stream == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(11);
        }
        return stream;
    }

    private boolean isNonDefaultParameter(PsiElement[] parameters, AssertParameter assertParameter) {
        int index = this.getParameterIndex(assertParameter);
        return parameters.length > index && PhpUnitAssertInspectionBase.nonDefaultParameter(assertParameter, parameters[index]);
    }

    protected int getParameterIndex(AssertParameter assertParameter) {
        return assertParameter.ordinal() + 3;
    }

    private static boolean nonDefaultParameter(AssertParameter maxDepth, PsiElement parameter) {
        return switch (maxDepth) {
            default -> throw new IncompatibleClassChangeError();
            case AssertParameter.DELTA -> {
                if (!PhpDivisionByZeroInspection.isZero(parameter)) {
                    yield true;
                }
                yield false;
            }
            case AssertParameter.MAX_DEPTH -> {
                if (!StringUtil.equals((CharSequence)DEFAULT_MAX_DEPTH, (CharSequence)PhpPsiUtil.getLiteralText(parameter))) {
                    yield true;
                }
                yield false;
            }
            case AssertParameter.CANONICALIZE, AssertParameter.IGNORE_CASE -> PhpLangUtil.isTrue(parameter);
        };
    }

    @Nullable
    protected LocalQuickFix getAssertEqualsQuickFix(@NotNull Set<AssertParameter> nonDefaultParametersSet, @NotNull AssertType assertType) {
        if (nonDefaultParametersSet == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(12);
        }
        if (assertType == null) {
            PhpUnitAssertInspectionBase.$$$reportNull$$$0(13);
        }
        if (nonDefaultParametersSet.isEmpty()) {
            return new PhpUnitDropOptionalParametersQuickFix(assertType.toString());
        }
        if (nonDefaultParametersSet.size() == 1) {
            return switch ((AssertParameter)((Object)ContainerUtil.getFirstItem(nonDefaultParametersSet))) {
                default -> throw new IncompatibleClassChangeError();
                case AssertParameter.DELTA -> new PhpUnitAssertEqualsWithDeltaQuickFix(assertType);
                case AssertParameter.MAX_DEPTH -> null;
                case AssertParameter.CANONICALIZE -> new PhpUnitReplaceAssertMethodReferenceQuickFix(assertType + AssertParameter.CANONICALIZE.getMethodNameSuffix(), 3);
                case AssertParameter.IGNORE_CASE -> new PhpUnitReplaceAssertMethodReferenceQuickFix(assertType + AssertParameter.IGNORE_CASE.getMethodNameSuffix(), 3);
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertInspectionBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonDefaultParametersSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "possibleNonDefaultParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "existAllSpecializedAssertEqualsMethods";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "declareProblemType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAssertEqualsQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

