/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpTestFrameworkVersionDetector;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class PhpUnitDeprecatedCallsIn11VersionInspection
extends PhpInspection {
    private static final Map<String, String> DEPRECATED_CALLS = Map.of("onConsecutiveCalls", "willReturn", "returnValue", "willReturn", "returnValueMap", "willReturnMap", "returnArgument", "willReturnArgument", "returnSelf", "willReturnSelf", "returnCallback", "willReturnCallback");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitDeprecatedCallsIn11VersionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                if (!PhpUnitDeprecatedCallsIn11VersionInspection.isSuitableMethod(reference)) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                PsiElement identifier = nameNode.getPsi();
                String name = DEPRECATED_CALLS.get(reference.getName());
                boolean shouldNotify = false;
                @NotNull Collection<PhpUnitSettings> instance = PhpUnitSettingsManager.getInstance(holder.getProject()).getLocalSettings();
                for (PhpUnitSettings settings : instance) {
                    String version = PhpTestFrameworkVersionCache.getCache(holder.getProject(), settings);
                    if (!StringUtil.isNotEmpty((String)version) || PhpTestFrameworkVersionDetector.versionCompare(version, "11.0.0") < 0) continue;
                    shouldNotify = true;
                }
                if (shouldNotify || ApplicationManager.getApplication().isUnitTestMode()) {
                    holder.registerProblem(identifier, PhpUnitDeprecatedCallsIn11VersionInspection.buildDescription(reference.getName()), new LocalQuickFix[]{new PhpUnitReplaceWithExistingMethodQuickFix(name)});
                }
            }
        };
    }

    @NotNull
    @InspectionMessage
    private static String buildDescription(String methodName) {
        String string = PhpBundle.message("inspection.phpunit.will.deprecation", methodName, DEPRECATED_CALLS.get(methodName));
        if (string == null) {
            PhpUnitDeprecatedCallsIn11VersionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static boolean isSuitableMethod(@NotNull MethodReference reference) {
        String referenceName;
        if (reference == null) {
            PhpUnitDeprecatedCallsIn11VersionInspection.$$$reportNull$$$0(2);
        }
        if ((referenceName = reference.getName()) == null) {
            return false;
        }
        if (!DEPRECATED_CALLS.containsKey(referenceName)) {
            return false;
        }
        MethodReference willMethodReference = PhpPsiUtil.getParentOfClass((PsiElement)reference, MethodReference.class);
        PsiElement type = PhpPsiUtil.getChildOfType((PsiElement)willMethodReference, PhpTokenTypes.IDENTIFIER);
        if (type == null) {
            return false;
        }
        if (willMethodReference == null || !type.getText().equals("will")) {
            return false;
        }
        Set classes = reference.multiResolveStrict(Method.class).stream().map(PhpClassMember::getContainingClass).filter(Objects::nonNull).collect(Collectors.toSet());
        return !classes.isEmpty() && ContainerUtil.and(classes, c -> "\\PHPUnit\\Framework\\TestCase".equals(c.getFQN()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn11VersionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn11VersionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class PhpUnitReplaceWithExistingMethodQuickFix
    extends PsiUpdateModCommandQuickFix
    implements HighPriorityAction {
        private final String myNewMethodName;

        private PhpUnitReplaceWithExistingMethodQuickFix(@NotNull String newMethodName) {
            if (newMethodName == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(0);
            }
            this.myNewMethodName = newMethodName;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.suggested.call.in.phpunit.11", new Object[0]);
            if (string == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(4);
            }
            ParameterList newList = PhpPsiUtil.getParentOfClass(element, ParameterList.class);
            ParameterList oldList = (ParameterList)PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)i -> i instanceof ParameterList));
            if (newList != null) {
                Object name = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)newList, (Condition<? super PsiElement>)((Condition)i -> PhpPsiUtil.isOfType(i, PhpTokenTypes.IDENTIFIER)));
                if (oldList != null) {
                    newList.replace((PsiElement)oldList);
                    if (name != null) {
                        name.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
                    }
                }
            }
        }

        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
            if (string == null) {
                PhpUnitReplaceWithExistingMethodQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newMethodName";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn11VersionInspection$PhpUnitReplaceWithExistingMethodQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedCallsIn11VersionInspection$PhpUnitReplaceWithExistingMethodQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 5 -> new IllegalStateException(string);
            };
        }
    }
}

