/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitDataProviderInspectionBase;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePublicIntention;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitDeprecatedDataProviderSignatureInspection
extends PhpUnitDataProviderInspectionBase {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitDeprecatedDataProviderSignatureInspection.$$$reportNull$$$0(0);
        }
        if (!PhpUnitDeprecatedDataProviderSignatureInspection.atLeastPhpUnit10(holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpUnitDeprecatedDataProviderSignatureInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            PhpUnitDeprecatedDataProviderSignatureInspection.$$$reportNull$$$0(2);
        }
        return psiElementVisitor;
    }

    public static boolean atLeastPhpUnit10(Project project) {
        return !PhpIndex.getInstance(project).getAnyByFQN("\\PHPUnit\\Framework\\Attributes\\Test").isEmpty();
    }

    @Override
    protected void doCheck(@NotNull PsiElement elementToHighlight, Pair<String, String> classFqnAndMethodName, Pair<PhpClass, Method> classAndMethod, @NotNull ProblemsHolder holder) {
        Method method;
        if (elementToHighlight == null) {
            PhpUnitDeprecatedDataProviderSignatureInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpUnitDeprecatedDataProviderSignatureInspection.$$$reportNull$$$0(4);
        }
        if ((method = (Method)classAndMethod.getSecond()) == null) {
            return;
        }
        if (method.getParameter(0) != null) {
            holder.registerProblem(elementToHighlight, PhpBundle.message("inspection.message.data.provider.method.should.not.require.arguments", new Object[0]), new LocalQuickFix[0]);
            return;
        }
        boolean isPublic = method.getAccess().isPublic();
        boolean isStatic = method.isStatic();
        if (isPublic && isStatic) {
            return;
        }
        String suffix = PhpUnitDeprecatedDataProviderSignatureInspection.getSuffix(isPublic, isStatic);
        holder.registerProblem(elementToHighlight, PhpBundle.message("inspection.message.data.provider.method.should.be", suffix), new LocalQuickFix[]{new PhpUpdateDataProviderSignatureQuickFix(method, isPublic, isStatic)});
    }

    @NotNull
    private static String getSuffix(boolean isPublic, boolean isStatic) {
        return !isPublic && !isStatic ? PhpBundle.message("public.and.static", new Object[0]) : (!isPublic ? "'public'" : "'static'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedDataProviderSignatureInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedDataProviderSignatureInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpUpdateDataProviderSignatureQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final boolean myIsPublic;
        private final boolean myIsStatic;

        private PhpUpdateDataProviderSignatureQuickFix(Method method, boolean isPublic, boolean isStatic) {
            super((PsiElement)method);
            this.myIsPublic = isPublic;
            this.myIsStatic = isStatic;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement instanceof Method) {
                Method method = (Method)startElement;
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)method)) {
                    return;
                }
                if (!this.myIsStatic) {
                    method = PhpUpdateDataProviderSignatureQuickFix.makeStatic(project, method);
                }
                if (!this.myIsPublic) {
                    new PhpMakePublicIntention().doChangeAccess(project, null, method);
                }
            }
        }

        private static Method makeStatic(@NotNull Project project, Method method) {
            if (project == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(4);
            }
            return (Method)WriteAction.compute(() -> PhpMakeStaticProcessor.doMakeStaticMethod(project, method));
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            Method method;
            if (project == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(6);
            }
            if (file == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(7);
            }
            if ((method = (Method)ObjectUtils.tryCast((Object)this.getStartElement(), Method.class)) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(8);
                }
                return intentionPreviewInfo;
            }
            String memberSuffix = " function " + method.getName();
            String oldModifier = method.getModifier() + memberSuffix;
            String newModifier = PhpModifier.instance(PhpModifier.Access.PUBLIC, method.getModifier().getAbstractness(), PhpModifier.State.STATIC) + memberSuffix;
            return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, method.getContainingFile().getName(), oldModifier, newModifier);
        }

        @NotNull
        public String getText() {
            PsiElement element = this.myStartElement.getElement();
            String string = element instanceof Method ? PhpBundle.message("intention.name.change.method.to", ((Method)element).getName(), PhpUnitDeprecatedDataProviderSignatureInspection.getSuffix(this.myIsPublic, this.myIsStatic)) : this.getFamilyName();
            if (string == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.make.data.provider.method.public.static", new Object[0]);
            if (string == null) {
                PhpUpdateDataProviderSignatureQuickFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedDataProviderSignatureInspection$PhpUpdateDataProviderSignatureQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedDataProviderSignatureInspection$PhpUpdateDataProviderSignatureQuickFix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "makeStatic";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

