/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitMisorderedAssertEqualsArgumentsInspection
extends PhpInspection {
    private static final LocalQuickFix[] FIXES = new LocalQuickFix[]{PhpUnitFlipArgumentsQuickFix.INSTANCE};
    private static final IElementType[] EXPECTED_PARAMETER_TYPES = new IElementType[]{PhpElementTypes.STRING, PhpElementTypes.NUMBER, PhpElementTypes.CONSTANT_REF, PhpElementTypes.CLASS_CONSTANT_REFERENCE};

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                if (!(PhpUnitMisorderedAssertEqualsArgumentsInspection.isSuitableAssertMethod(reference) && PhpUnitAssertUtil.isInsideTestClass((PsiElement)reference) && PhpUnitAssertUtil.isImplementedInPhpUnitAssertClass(reference))) {
                    return;
                }
                PsiElement first = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
                PsiElement second = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 1);
                if (first == null || second == null || PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(first) || !PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(second)) {
                    return;
                }
                PsiElement methodIdentifier = PhpPsiUtil.getChildOfType((PsiElement)reference, PhpTokenTypes.IDENTIFIER);
                if (methodIdentifier != null) {
                    holder.registerProblem(methodIdentifier, PhpBundle.message("inspection.phpunit.asserts.assertEquals.misordered.arguments", methodIdentifier.getText()), FIXES);
                }
            }
        };
    }

    private static boolean isSuitableAssertMethod(MethodReference reference) {
        String name = reference.getName();
        if (name != null && name.startsWith("assert") && !StringUtil.containsIgnoreCase((String)name, (String)"less") && !StringUtil.containsIgnoreCase((String)name, (String)"greater")) {
            Collection methods = reference.multiResolveStrict(Method.class);
            return !methods.isEmpty() && ContainerUtil.all((Collection)methods, PhpUnitMisorderedAssertEqualsArgumentsInspection::isSuitableAssertMethod);
        }
        return false;
    }

    private static boolean isSuitableAssertMethod(Method m) {
        Parameter firstParameter = m.getParameter(0);
        Parameter secondParameter = m.getParameter(1);
        return firstParameter != null && secondParameter != null && PhpLangUtil.equalsParameterNames(firstParameter.getName(), "expected") && PhpType.globalTypeEquals((PhpTypedElement)firstParameter, secondParameter);
    }

    private static boolean looksLikeExpectedArgument(@NotNull PsiElement parameter) {
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
            return PhpUnitMisorderedAssertEqualsArgumentsInspection.isExpectedValueArrayElements(parameter);
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.INFIX_EXPRESSION)) {
            PsiElement unaryExpressionValue = PhpUnitMisorderedAssertEqualsArgumentsInspection.getUnaryExpressionValue(parameter);
            return unaryExpressionValue != null && PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument(unaryExpressionValue);
        }
        if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.STRING) && PsiTreeUtil.findChildOfType((PsiElement)parameter, Variable.class) != null) {
            return false;
        }
        return PhpPsiUtil.isOfType(parameter, EXPECTED_PARAMETER_TYPES);
    }

    private static boolean isExpectedValueArrayElements(@NotNull PsiElement parameter) {
        ArrayCreationExpression arrayCreationExpression;
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(2);
        }
        if ((arrayCreationExpression = (ArrayCreationExpression)ObjectUtils.tryCast((Object)parameter, ArrayCreationExpression.class)) == null) {
            return false;
        }
        for (PhpPsiElement element : ArrayCreationExpressionImpl.children(arrayCreationExpression)) {
            PhpPsiElement innerArrayElement = element instanceof ArrayHashElement ? ((ArrayHashElement)element).getValue() : element.getFirstPsiChild();
            if (innerArrayElement != null && PhpUnitMisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument((PsiElement)innerArrayElement)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiElement getUnaryExpressionValue(@NotNull PsiElement parameter) {
        UnaryExpression unaryExpression;
        if (parameter == null) {
            PhpUnitMisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(3);
        }
        if ((unaryExpression = (UnaryExpression)ObjectUtils.tryCast((Object)parameter, UnaryExpression.class)) == null) {
            return null;
        }
        return unaryExpression.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "looksLikeExpectedArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpectedValueArrayElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnaryExpressionValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpUnitFlipArgumentsQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final PhpUnitFlipArgumentsQuickFix INSTANCE = new PhpUnitFlipArgumentsQuickFix();

        private PhpUnitFlipArgumentsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.phpunit.assert.equals.flip.compared.arguments", new Object[0]);
            if (string == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodIdentifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            if (methodIdentifier == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpUnitFlipArgumentsQuickFix.$$$reportNull$$$0(3);
            }
            if (!PhpPsiUtil.isOfType(methodIdentifier, PhpTokenTypes.IDENTIFIER)) {
                return;
            }
            MethodReference reference = PhpPsiUtil.getParentOfClass(methodIdentifier, MethodReference.class);
            if (reference == null) {
                return;
            }
            PsiElement first = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 0);
            PsiElement second = PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex(reference, 1);
            if (first == null || second == null) {
                return;
            }
            PsiElement tmp = first.copy();
            first.replace(second);
            second.replace(tmp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection$PhpUnitFlipArgumentsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitMisorderedAssertEqualsArgumentsInspection$PhpUnitFlipArgumentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

