/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.classes.PhpNamedArgumentsWithChangedOrderInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitReplaceAssertMethodReferenceQuickFix
extends PsiUpdateModCommandQuickFix {
    private final String myNewMethodName;
    private final int myParametersNumberToReplace;

    public PhpUnitReplaceAssertMethodReferenceQuickFix(@NotNull String newMethodName, int parametersNumberToReplace) {
        if (newMethodName == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(0);
        }
        this.myNewMethodName = newMethodName;
        this.myParametersNumberToReplace = parametersNumberToReplace;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.phpunit.replace.current.method.with.alternative", this.myNewMethodName);
        if (string == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement methodIdentifier;
        if (project == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(4);
        }
        if ((methodIdentifier = this.getMethodIdentifierFromProblemDescriptor(element)) == null) {
            return;
        }
        ParameterList parameterList = (ParameterList)PhpPsiUtil.getNextSiblingByCondition(methodIdentifier, ParameterList.INSTANCEOF);
        if (parameterList == null) {
            return;
        }
        PhpNamedArgumentsWithChangedOrderInspection.sortNamedArguments(project, parameterList);
        PhpUnitReplaceAssertMethodReferenceQuickFix.dropNameIdentifiers(parameterList);
        methodIdentifier.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, this.myNewMethodName));
        String newParametersListText = this.getNewParameterListText(parameterList);
        if (newParametersListText != null) {
            parameterList.replace((PsiElement)PhpPsiElementFactory.createArgumentList(project, newParametersListText));
        }
    }

    public static void dropNameIdentifiers(ParameterList parameterList) {
        ArrayList<PsiElement> elementsToDelete = new ArrayList<PsiElement>();
        for (PsiElement child = parameterList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER, PhpTokenTypes.opCOLON)) continue;
            elementsToDelete.add(child);
        }
        elementsToDelete.forEach(PsiElement::delete);
    }

    @Nullable
    protected PsiElement getMethodIdentifierFromProblemDescriptor(@NotNull PsiElement startElement) {
        if (startElement == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(5);
        }
        if (!PhpPsiUtil.isOfType(startElement, PhpTokenTypes.IDENTIFIER)) {
            return null;
        }
        return startElement;
    }

    @Nullable
    private String getNewParameterListText(@NotNull ParameterList parameterList) {
        PsiElement[] parameterArray;
        PsiElement[] newParameterArray;
        if (parameterList == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(6);
        }
        if ((newParameterArray = this.createNewParameters(parameterArray = parameterList.getParameters())) == null) {
            return null;
        }
        if (newParameterArray.length == 0) {
            return "";
        }
        String fileContent = parameterList.getContainingFile().getText();
        StringBuilder formattedParameterListString = new StringBuilder();
        formattedParameterListString.append(newParameterArray[0].getText());
        for (int i = 1; i < newParameterArray.length; ++i) {
            PsiElement currentParameter = newParameterArray[i];
            String textBeforeCurrentParameter = fileContent.substring(parameterArray[i - 1].getTextRange().getEndOffset(), parameterArray[i].getTextRange().getStartOffset());
            formattedParameterListString.append(textBeforeCurrentParameter);
            formattedParameterListString.append(currentParameter.getText());
        }
        return formattedParameterListString.toString();
    }

    protected PsiElement @Nullable [] createNewParameters(PsiElement @NotNull [] parameters) {
        if (parameters == null) {
            PhpUnitReplaceAssertMethodReferenceQuickFix.$$$reportNull$$$0(7);
        }
        if (this.myParametersNumberToReplace <= parameters.length) {
            return Arrays.copyOf(parameters, this.myParametersNumberToReplace);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceAssertMethodReferenceQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/quickfix/PhpUnitReplaceAssertMethodReferenceQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMethodIdentifierFromProblemDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewParameterListText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNewParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

