/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.surroundWith.PhpBlockSurrounder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAssignmentInConditionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpIf(If ifStatement) {
                PhpPsiElement condition = ifStatement.getCondition();
                if (condition instanceof MultiassignmentExpression) {
                    PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)condition, new LocalQuickFix[0]);
                } else {
                    PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)condition, PhpMoveAssignmentOutOfTheConditionQuickFix.INSTANCE);
                }
            }

            @Override
            public void visitPhpElseIf(ElseIf elseIfStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)elseIfStatement.getCondition(), new LocalQuickFix[0]);
            }

            @Override
            public void visitPhpTernaryExpression(TernaryExpression ternaryExpression) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)ternaryExpression.getCondition(), new LocalQuickFix[0]);
            }

            @Override
            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)doWhileStatement.getCondition(), new LocalQuickFix[0]);
            }

            @Override
            public void visitPhpWhile(While whileStatement) {
                PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)whileStatement.getCondition(), new LocalQuickFix[0]);
            }

            @Override
            public void visitPhpFor(For forStatement) {
                for (PhpPsiElement condition : forStatement.getConditionalExpressions()) {
                    PhpAssignmentInConditionInspection.checkCondition(holder, (PsiElement)condition, new LocalQuickFix[0]);
                }
            }
        };
    }

    private static void checkCondition(@NotNull ProblemsHolder holder, @Nullable PsiElement condition, LocalQuickFix ... fixes) {
        if (holder == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            PhpAssignmentInConditionInspection.$$$reportNull$$$0(2);
        }
        for (AssignmentExpression assignment : PhpPsiUtil.findChildrenNonStrict(condition, AssignmentExpression.class)) {
            holder.registerProblem((PsiElement)assignment, PhpBundle.message("inspection.assignment.in.condition", new Object[0]), fixes);
        }
    }

    @Nls
    public static String getMoveAssignmentOutOfTheConditionFixName() {
        return PhpBundle.message("inspection.assignment.in.condition.move.assignment.out.of.condition.fix.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpAssignmentInConditionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpMoveAssignmentOutOfTheConditionQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpMoveAssignmentOutOfTheConditionQuickFix();

        private PhpMoveAssignmentOutOfTheConditionQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpAssignmentInConditionInspection.getMoveAssignmentOutOfTheConditionFixName();
            if (string == null) {
                PhpMoveAssignmentOutOfTheConditionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            AssignmentExpression assignmentExpression;
            if (project == null) {
                PhpMoveAssignmentOutOfTheConditionQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpMoveAssignmentOutOfTheConditionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpMoveAssignmentOutOfTheConditionQuickFix.$$$reportNull$$$0(3);
            }
            if ((assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)element, AssignmentExpression.class)) == null) {
                return;
            }
            PhpPsiElement variable = assignmentExpression.getVariable();
            if (variable == null) {
                return;
            }
            If parentIf = PhpPsiUtil.getParentOfClass((PsiElement)assignmentExpression, If.class);
            if (parentIf == null) {
                return;
            }
            PsiElement parent = parentIf.getParent();
            PsiElement introducedAssignmentStatement = parent.addBefore((PsiElement)PhpPsiElementFactory.createStatement(project, assignmentExpression.getText() + ";"), (PsiElement)parentIf);
            assignmentExpression.replace((PsiElement)variable);
            if (parent instanceof ControlStatement || parent instanceof Else) {
                new PhpBlockSurrounder().surroundElements(project, new PsiElement[]{introducedAssignmentStatement, parentIf});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpAssignmentInConditionInspection$PhpMoveAssignmentOutOfTheConditionQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpAssignmentInConditionInspection$PhpMoveAssignmentOutOfTheConditionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

